/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class DropPlanOrderLogUpgradeService
implements IUpgradeService {
    private static final String ALGO_KEY = DropPlanOrderLogUpgradeService.class.getName();
    private static final DBRoute DB_ROUTE = DBRoute.of((String)"scm");
    private static final int BATCH_NUM = 1000;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.upgrade();
            result.setSuccess(true);
            result.setLog("dropPlanOrderLog upgrade success");
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrorInfo(e.getMessage());
            result.setLog("dropPlanOrderLog upgrade failed");
        }
        return result;
    }

    private void upgrade() {
        String queryDropLog = "select fid, fplanorderid from t_mrp_dropplanorderlog;";
        DataSet dropLogDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUTE, (String)queryDropLog);
        HashSet<Long> planOrderIdSet = new HashSet<Long>(1000);
        for (Row row : dropLogDataSet) {
            Long planOrderId = row.getLong("fplanorderid");
            planOrderIdSet.add(planOrderId);
            if (planOrderIdSet.size() < 1000) continue;
            this.handleBatch(planOrderIdSet);
            planOrderIdSet.clear();
        }
        if (!planOrderIdSet.isEmpty()) {
            this.handleBatch(planOrderIdSet);
        }
    }

    private void handleBatch(Set<Long> planOrderIdSet) {
        if (planOrderIdSet == null || planOrderIdSet.isEmpty()) {
            return;
        }
        SqlBuilder queryPlanOrder = new SqlBuilder();
        queryPlanOrder.append("select fid, forgid, fproorpurorg, fmaterial, funit, forderqty, fbilltypeid, fordertype, fconfiguredcode, ftracknumber, fplanoperatenum from t_mrp_planorder where ", new Object[0]);
        queryPlanOrder.appendIn("fid", planOrderIdSet.toArray());
        DataSet planOrderDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUTE, (SqlBuilder)queryPlanOrder);
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(1000);
        for (Row row : planOrderDataSet) {
            Object[] param = new Object[11];
            Long orgId = row.getLong("forgid");
            orgId = orgId == null ? Long.valueOf(0L) : orgId;
            param[0] = orgId;
            Long proOrPurOrgId = row.getLong("fproorpurorg");
            proOrPurOrgId = proOrPurOrgId == null ? Long.valueOf(0L) : proOrPurOrgId;
            param[1] = proOrPurOrgId;
            Long materialId = row.getLong("fmaterial");
            materialId = materialId == null ? Long.valueOf(0L) : materialId;
            param[2] = materialId;
            Long unitId = row.getLong("funit");
            unitId = unitId == null ? Long.valueOf(0L) : unitId;
            param[3] = unitId;
            BigDecimal orderQty = row.getBigDecimal("forderqty");
            orderQty = orderQty == null ? BigDecimal.ZERO : orderQty;
            param[4] = orderQty;
            Long billTypeId = row.getLong("fbilltypeid");
            billTypeId = billTypeId == null ? Long.valueOf(0L) : billTypeId;
            param[5] = billTypeId;
            String orderType = row.getString("fordertype");
            orderType = orderType == null ? "" : orderType;
            param[6] = orderType;
            Long configuredCodeId = row.getLong("fconfiguredcode");
            configuredCodeId = configuredCodeId == null ? Long.valueOf(0L) : configuredCodeId;
            param[7] = configuredCodeId;
            Long trackNumberId = row.getLong("ftracknumber");
            trackNumberId = trackNumberId == null ? Long.valueOf(0L) : trackNumberId;
            param[8] = trackNumberId;
            String planOperateNum = row.getString("fplanoperatenum");
            planOperateNum = planOperateNum == null ? "" : planOperateNum;
            param[9] = planOperateNum;
            Long planOrderId = row.getLong("fid");
            param[10] = planOrderId;
            updateParamList.add(param);
        }
        if (!updateParamList.isEmpty()) {
            String updateDropLog = "update t_mrp_dropplanorderlog set forgid = ?, fproorpurorg = ?, fmaterial = ?, funit = ?, forderqty = ?, fbilltype = ?, fordertype = ?, fconfiguredcode = ?, ftracknumberid = ?, fplanoperatenum = ? where fplanorderid = ?;";
            DB.executeBatch((DBRoute)DB_ROUTE, (String)updateDropLog, updateParamList);
        }
    }
}

