/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.UpgradeResult;

public class ExcuteSQLMSPLANMuLanguageSynHistory {
    private static final String ALGO_KEY = ExcuteSQLMSPLANMuLanguageSynHistory.class.getName();
    private static final DBRoute DB_ROUTE = DBRoute.of((String)"scm");
    private static final int DEFAULT_BATCHSIZE = 5000;

    public static UpgradeResult synHistoryData() {
        UpgradeResult result = new UpgradeResult();
        ExcuteSQLMSPLANMuLanguageSynHistory.updatePmodelentry();
        ExcuteSQLMSPLANMuLanguageSynHistory.updatePriorityentry();
        result.setSuccess(true);
        return result;
    }

    private static void updatePriorityentry() {
        String queryDropLog = "SELECT FENTRYID, FELEMENTFIELD FROM T_MSPLAN_PRIORITYENTRY where fid not in (select fid from T_MSPLAN_PRIORITYENTRY_L)";
        DataSet dropLogDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUTE, (String)queryDropLog);
        int count = dropLogDataSet.copy().count("FENTRYID", false);
        String[] pkids = DB.genStringIds((String)"T_MSPLAN_PRIORITYENTRY_L", (int)count);
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(count);
        int i = 0;
        for (Row row : dropLogDataSet) {
            Long mappingEntryId = row.getLong("FENTRYID");
            String fieldname = row.getString("FELEMENTFIELD");
            Object[] param = new Object[]{pkids[i], mappingEntryId, "zh_CN", fieldname};
            updateParamList.add(param);
            ++i;
        }
        String insertSQL = "INSERT INTO T_MSPLAN_PRIORITYENTRY_L(FPKID, FENTRYID, FLOCALEID, FELEMENTFIELD) VALUES (?,?,?,?)";
        if (updateParamList.size() != 0) {
            ExcuteSQLMSPLANMuLanguageSynHistory.batchSave(DB_ROUTE, insertSQL, updateParamList);
        }
    }

    private static void updatePmodelentry() {
        String queryDropLog = "SELECT FENTRYID, FFIELDNAME FROM T_MSPLAN_PMODELENTRY where fid not in (select fid from T_MSPLAN_PMODELENTRY_L)";
        DataSet dropLogDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUTE, (String)queryDropLog);
        int count = dropLogDataSet.copy().count("FENTRYID", false);
        String[] pkids = DB.genStringIds((String)"T_MSPLAN_PMODELENTRY_L", (int)count);
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(count);
        int i = 0;
        for (Row row : dropLogDataSet) {
            Long mappingEntryId = row.getLong("FENTRYID");
            String fieldname = row.getString("FFIELDNAME");
            Object[] param = new Object[]{pkids[i], mappingEntryId, "zh_CN", fieldname};
            updateParamList.add(param);
            ++i;
        }
        String insertSQL = "INSERT INTO T_MSPLAN_PMODELENTRY_L(FPKID, FENTRYID, FLOCALEID, FFIELDNAME) VALUES (?,?,?,?);";
        if (updateParamList.size() != 0) {
            ExcuteSQLMSPLANMuLanguageSynHistory.batchSave(DB_ROUTE, insertSQL, updateParamList);
        }
    }

    public static void batchSave(DBRoute dbRoute, String sql, List<Object[]> values) {
        int totalCount = values.size();
        if (totalCount > 5000) {
            int times = totalCount / 5000;
            times = totalCount % 5000 != 0 ? times + 1 : times;
            for (int i = 0; i < times; ++i) {
                int startIndex = i * 5000;
                int endIndex = Math.min(startIndex + 5000, totalCount);
                DB.executeBatch((DBRoute)dbRoute, (String)sql, values.subList(startIndex, endIndex));
            }
        } else {
            DB.executeBatch((DBRoute)dbRoute, (String)sql, values);
        }
    }
}

