/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mspur.business;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.mspur.common.consts.BizTypePreConst;

public class MaterialHelper {
    public static final String MASTERID = "masterid";
    public static final String ID = "id";
    public static final String ENABLE = "enable";
    public static final String PURCHASEUNIT = "purchaseunit";
    public static final String STATUS = "status";
    public static final String DESCRIPTION = "description";
    public static final String MASTER = "material";
    public static final String GROUP = "group";
    public static final String ISAPPROVEDSUPPLIER = "isapprovedsupplier";
    public static final String ISQUOTACONTROL = "isquotacontrol";
    public static final String ISNEEDREQUEST = "isneedrequest";
    public static final String ISRETURN = "isreturn";
    public static final String ISCONTROLDAY = "iscontrolday";
    public static final String PURLEADDAY = "purleadday";
    public static final String RECEIVEDAYUP = "receivedayup";
    public static final String RECEIVEDAYDOWN = "receivedaydown";
    public static final String ISCONTROLQTY = "iscontrolqty";
    public static final String RECEIVERATEUP = "receiverateup";
    public static final String RECEIVERATEDOWN = "receiveratedown";
    public static final String CTRLSTRAGY = "ctrlstrategy";
    public static final String CREATEORG = "createorg";
    public static final String ORG = "org";
    public static final String USERORG = "useorg";
    public static final String TAXRATE = "taxrate";
    public static final String ENABLE_VMI = "enablevmi";

    public static DynamicObject getDefaultTaxRate(DynamicObject supplier, DynamicObject material) {
        DynamicObject master;
        DynamicObject taxRate = null;
        if (material != null && (master = material.getDynamicObject(MASTERID)) != null && master.getDynamicObject(TAXRATE) != null) {
            taxRate = master.getDynamicObject(TAXRATE);
        }
        if (taxRate == null && supplier != null) {
            taxRate = supplier.getDynamicObject(TAXRATE);
        }
        if (taxRate != null) {
            Long taxRateId = (Long)taxRate.getPkValue();
            taxRate = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"id, taxrate", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)taxRateId)});
        }
        return taxRate;
    }

    public static List<QFilter> getQFilterByLineType(Long billTypeId, Long bizTypeId, Long lineTypeId, boolean isMaterialInfo) {
        QFilter[] qFilterByLineType;
        if (CommonUtils.isNull((Object)billTypeId) || CommonUtils.isNull((Object)bizTypeId) || CommonUtils.isNull((Object)lineTypeId)) {
            return null;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        if (BizTypePreConst.BIZTYPE_VMI_PUR_ID.equals(bizTypeId) || BizTypePreConst.BIZTYPE_VMI_PURRETURN_ID.equals(bizTypeId)) {
            qFilters.add(new QFilter((isMaterialInfo ? "masterid." : "") + ENABLE_VMI, "=", (Object)Boolean.TRUE));
        }
        if ((qFilterByLineType = kd.mpscmm.msbd.business.helper.MaterialHelper.getQFilterByLineType((Long)billTypeId, (Long)bizTypeId, (Long)lineTypeId, (boolean)isMaterialInfo)) != null) {
            qFilters.addAll(Arrays.asList(qFilterByLineType));
        }
        return qFilters;
    }
}

