/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mspur.business;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.business.helper.AmountPlanHelper;
import kd.mpscmm.msbd.business.helper.BillQuantityHelper;
import kd.mpscmm.msbd.business.helper.InvoiceBiztypeHelper;
import kd.mpscmm.msbd.common.context.CommonContext;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.mspur.business.PurTplHelper;
import kd.mpscmm.mspur.business.SupplierHelper;

public class PoTplHelper
extends PurTplHelper {
    public static void calAmountPlan(IFormView view) {
        AmountPlanHelper.calAmountPlanForView((CommonContext)PoTplHelper.getPayPlanCommonText(view.getEntityId()), (IFormView)view);
    }

    public static void calAmountPlan(DynamicObject bill) {
        AmountPlanHelper.calAmountPlanForDynamicObject((CommonContext)PoTplHelper.getPayPlanCommonText(bill.getDataEntityType().getName()), (DynamicObject)bill);
    }

    public static CommonContext getPayPlanCommonText(String entityId) {
        CommonContext commonContext = CommonContext.get();
        commonContext.setEntityId(entityId);
        Map propertyMapping = commonContext.getProperytMapping();
        propertyMapping.putAll(PoTplHelper.getPlanCommonFieldMapping());
        return commonContext;
    }

    public static Map<String, String> getPlanCommonFieldMapping() {
        HashMap<String, String> properytMapping = new HashMap<String, String>();
        properytMapping.put("appid", "/JJVO8XV9MVB");
        properytMapping.put("viewtype", "02");
        properytMapping.put("plantype", "purchase");
        properytMapping.put("totalallamount", "totalallamount");
        properytMapping.put("amountcondition", "paycondition");
        properytMapping.put("settlecurrency", "settlecurrency");
        properytMapping.put("ispayrate", "ispayrate");
        properytMapping.put("biztime", "biztime");
        properytMapping.put("entrynum", "billentry_pay");
        properytMapping.put("amount", "payamount");
        properytMapping.put("changetype", "payentrychangetype");
        properytMapping.put("rate", "payrate");
        properytMapping.put("itemname", "payname");
        properytMapping.put("isprepay", "isprepay");
        properytMapping.put("amountdate", "paydate");
        return properytMapping;
    }

    public static void calReceiveQtyUpDown(IDataModel model, int rowIndex) {
        if (model == null) {
            return;
        }
        DynamicObjectCollection entryEntity = model.getEntryEntity("billentry");
        PoTplHelper.calcReceiveQtyUpDown((DynamicObject)entryEntity.get(rowIndex));
    }

    public static void calcReceiveQtyUpDown(DynamicObject row) {
        BigDecimal qty = BigDecimalUtil.getNotNull((Object)row.getBigDecimal("qty"));
        BigDecimal baseQty = BigDecimalUtil.getNotNull((Object)row.getBigDecimal("baseqty"));
        BigDecimal receiveRateUp = BigDecimalUtil.getNotNull((Object)row.getBigDecimal("receiverateup"));
        BigDecimal receiveRateDown = BigDecimalUtil.getNotNull((Object)row.getBigDecimal("receiveratedown"));
        DynamicObject unit = row.getDynamicObject("unit");
        DynamicObject baseUnit = row.getDynamicObject("baseunit");
        row.set("receiveqtyup", (Object)PoTplHelper.getReceiveQtyUp(qty, receiveRateUp, unit));
        row.set("receiveqtydown", (Object)PoTplHelper.getReceiveQtyDown(qty, receiveRateDown, unit));
        row.set("receivebaseqtyup", (Object)PoTplHelper.getReceiveQtyUp(baseQty, receiveRateUp, baseUnit));
        row.set("receivebaseqtydown", (Object)PoTplHelper.getReceiveQtyDown(baseQty, receiveRateDown, baseUnit));
    }

    public static void updateReceiveQtyUpDown(IFormView view, int rowIndex) {
        if (view == null) {
            return;
        }
        view.updateView("receiveqtyup", rowIndex);
        view.updateView("receiveqtydown", rowIndex);
        view.updateView("receivebaseqtyup", rowIndex);
        view.updateView("receivebaseqtydown", rowIndex);
    }

    public static BigDecimal getReceiveQtyUp(BigDecimal qty, BigDecimal receiveRateUp, DynamicObject unit) {
        return PoTplHelper.getReceiveQtyUp(qty, receiveRateUp, BillQuantityHelper.getPrecision((DynamicObject)unit), BillQuantityHelper.getUnitRoundingMode((DynamicObject)unit));
    }

    public static BigDecimal getReceiveQtyDown(BigDecimal qty, BigDecimal receiveRateDown, DynamicObject unit) {
        return PoTplHelper.getReceiveQtyDown(qty, receiveRateDown, BillQuantityHelper.getPrecision((DynamicObject)unit), BillQuantityHelper.getUnitRoundingMode((DynamicObject)unit));
    }

    public static BigDecimal getReceiveQtyUp(BigDecimal qty, BigDecimal receiveRateUp, int scale, RoundingMode roundingMode) {
        return BigDecimalUtil.getByGrowRate((BigDecimal)qty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateUp)).setScale(scale, roundingMode);
    }

    public static BigDecimal getReceiveQtyDown(BigDecimal qty, BigDecimal receiveRateDown, int scale, RoundingMode roundingMode) {
        return BigDecimalUtil.getByReduceRate((BigDecimal)qty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateDown)).setScale(scale, roundingMode);
    }

    public static BigDecimal getReceiveQtyUpDown(BigDecimal qty, BigDecimal receiveRate, int scale, RoundingMode roundingMode, boolean isUp) {
        if (isUp) {
            return PoTplHelper.getReceiveQtyUp(qty, receiveRate, scale, roundingMode);
        }
        return PoTplHelper.getReceiveQtyDown(qty, receiveRate, scale, roundingMode);
    }

    public static void initBillInfo(IDataModel bill) {
        PurTplHelper.initBillInfo(bill);
    }

    public static void completeBillInfo(DynamicObject bill) {
        PurTplHelper.completeBillInfo(bill);
        DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject billEntry : billEntrys) {
            BigDecimal qty = billEntry.getBigDecimal("qty");
            BigDecimal baseQty = billEntry.getBigDecimal("baseqty");
            DynamicObject unit = billEntry.getDynamicObject("unit");
            DynamicObject baseUnit = billEntry.getDynamicObject("baseunit");
            Boolean isControlQty = (Boolean)billEntry.get("iscontrolqty");
            if (unit != null && baseUnit != null && isControlQty.booleanValue()) {
                BigDecimal receiveRateUp = billEntry.getBigDecimal("receiverateup");
                BigDecimal receiveRateDown = billEntry.getBigDecimal("receiveratedown");
                if (receiveRateUp == null || receiveRateDown == null) continue;
                BigDecimal receiveQtyUp = PoTplHelper.getReceiveQtyUp(qty, receiveRateUp, unit);
                BigDecimal receiveQtyDown = PoTplHelper.getReceiveQtyDown(qty, receiveRateDown, unit);
                BigDecimal receiveBaseQtyUp = PoTplHelper.getReceiveQtyUp(baseQty, receiveRateUp, baseUnit);
                BigDecimal receiveBaseQtyDown = PoTplHelper.getReceiveQtyDown(baseQty, receiveRateDown, baseUnit);
                billEntry.set("iscontrolqty", (Object)Boolean.TRUE);
                billEntry.set("receiverateup", (Object)receiveRateUp);
                billEntry.set("receiveratedown", (Object)receiveRateDown);
                billEntry.set("receiveqtyup", (Object)receiveQtyUp);
                billEntry.set("receiveqtydown", (Object)receiveQtyDown);
                billEntry.set("receivebaseqtyup", (Object)receiveBaseQtyUp);
                billEntry.set("receivebaseqtydown", (Object)receiveBaseQtyDown);
                continue;
            }
            billEntry.set("receiverateup", (Object)BigDecimalUtil.ZERO);
            billEntry.set("receiveratedown", (Object)BigDecimalUtil.ZERO);
            billEntry.set("receiveqtyup", (Object)qty);
            billEntry.set("receiveqtydown", (Object)qty);
            billEntry.set("receivebaseqtyup", (Object)baseQty);
            billEntry.set("receivebaseqtydown", (Object)baseQty);
        }
        DynamicObjectCollection billentry_pay = bill.getDynamicObjectCollection("billentry_pay");
        DynamicObject payCondition = bill.getDynamicObject("paycondition");
        if (payCondition != null && billentry_pay != null && billentry_pay.size() == 0) {
            PoTplHelper.calAmountPlan(bill);
        }
    }

    public static QFilter getSupplierFilter(String key) {
        if (key == null) {
            return null;
        }
        switch (key) {
            case "supplier": {
                return SupplierHelper.getPurchaseFilter();
            }
            case "providersupplier": {
                return SupplierHelper.getDeliverFilter();
            }
            case "invoicesupplier": {
                return SupplierHelper.getInvoiceFilter();
            }
            case "receivesupplier": {
                return SupplierHelper.getReceiveFilter();
            }
        }
        return null;
    }

    public static DynamicObject getInvoiceType(DynamicObject supplier, String appNmuber) {
        if (supplier != null) {
            Object invoicetype = supplier.get("invoicecategory");
            Long invoicetypeId = 0L;
            if (invoicetype != null) {
                invoicetypeId = (Long)((DynamicObject)invoicetype).getPkValue();
            }
            return InvoiceBiztypeHelper.getInvoiceBizType((Long)invoicetypeId, (String)appNmuber);
        }
        return null;
    }
}

