/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mspur.business;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.BillAmountHelper;
import kd.mpscmm.msbd.business.helper.BillQuantityHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.business.helper.CurrencyHelper;
import kd.mpscmm.msbd.business.helper.OperatorGroupHelper;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.business.helper.OwnerHelper;
import kd.mpscmm.msbd.common.enums.BizCloseStatusEnum;
import kd.mpscmm.msbd.common.enums.ChangeTypeEnum;
import kd.mpscmm.msbd.common.enums.DiscountTypeEnum;
import kd.mpscmm.msbd.common.enums.ExchangeTypeEnum;
import kd.mpscmm.msbd.common.enums.OperatorGrpTypeEnum;
import kd.mpscmm.msbd.common.enums.OwnerTypeEnum;
import kd.mpscmm.msbd.common.pojo.BillAmountInfo;
import kd.mpscmm.msbd.common.pojo.BillQuantityInfo;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.MetadataUtils;
import kd.mpscmm.mspur.business.BizCategoryHelper;
import kd.mpscmm.mspur.business.SupplierHelper;

public class PurTplHelper {
    public static int RECALTOTALAMOUNT_COUNT = 1000;

    public static void calBillQuantity(String fieldName, IDataModel model, int rowIndex) {
        if (model == null || fieldName == null) {
            return;
        }
        BillQuantityInfo quantityInfo = new BillQuantityInfo();
        quantityInfo.setChangePropertyName(fieldName);
        quantityInfo.setMaterial((DynamicObject)model.getValue("material", rowIndex));
        quantityInfo.setQty((BigDecimal)model.getValue("qty", rowIndex));
        quantityInfo.setUnit((DynamicObject)model.getValue("unit", rowIndex));
        quantityInfo.setBaseQty((BigDecimal)model.getValue("baseqty", rowIndex));
        quantityInfo.setBaseUnit((DynamicObject)model.getValue("baseunit", rowIndex));
        quantityInfo.setAuxQty((BigDecimal)model.getValue("auxqty", rowIndex));
        quantityInfo.setAuxUnit((DynamicObject)model.getValue("auxunit", rowIndex));
        Map result = BillQuantityHelper.calQuantity((BillQuantityInfo)quantityInfo);
        model.setValue("baseqty", result.get(quantityInfo.getCommonContext().getProperytMapping().get("BASEQTY")), rowIndex);
        model.setValue("auxqty", result.get(quantityInfo.getCommonContext().getProperytMapping().get("AUXQTY")), rowIndex);
        model.setValue("qty", result.get(quantityInfo.getCommonContext().getProperytMapping().get("QTY")), rowIndex);
    }

    public static void calBillQuantity(String fieldName, DynamicObject bill, DynamicObjectCollection billentrys, int rowIndex) {
        if (bill == null || billentrys == null || billentrys.size() == 0) {
            return;
        }
        DynamicObject billentry = (DynamicObject)billentrys.get(rowIndex);
        BillQuantityInfo quantityInfo = new BillQuantityInfo();
        if (fieldName != null) {
            quantityInfo.setChangePropertyName(fieldName);
        }
        quantityInfo.setMaterial(billentry.getDynamicObject("material"));
        quantityInfo.setQty(billentry.getBigDecimal("qty"));
        quantityInfo.setUnit(billentry.getDynamicObject("unit"));
        quantityInfo.setBaseQty(billentry.getBigDecimal("baseqty"));
        quantityInfo.setBaseUnit(billentry.getDynamicObject("baseunit"));
        quantityInfo.setAuxQty(billentry.getBigDecimal("auxqty"));
        quantityInfo.setAuxUnit(billentry.getDynamicObject("auxunit"));
        Map result = BillQuantityHelper.calQuantity((BillQuantityInfo)quantityInfo);
        billentry.set("qty", result.get(quantityInfo.getCommonContext().getProperytMapping().get("QTY")));
        billentry.set("baseqty", result.get(quantityInfo.getCommonContext().getProperytMapping().get("BASEQTY")));
        billentry.set("auxqty", result.get(quantityInfo.getCommonContext().getProperytMapping().get("AUXQTY")));
    }

    public static void updateBillQuantity(IFormView view, int rowIndex) {
        if (view == null) {
            return;
        }
        view.updateView("qty", rowIndex);
        view.updateView("baseqty", rowIndex);
        view.updateView("auxqty", rowIndex);
    }

    public static void calBillAmount(IDataModel model, IFormView view, int rowIndex, boolean isReCalTotalAmount) {
        PurTplHelper.calBillAmount(model, view, rowIndex, isReCalTotalAmount, Boolean.FALSE);
    }

    public static void calBillAmount(IDataModel model, IFormView view, int rowIndex, boolean isReCalTotalAmount, Boolean isCalDiscountRate) {
        if (model == null) {
            return;
        }
        PurTplHelper.calBillAmount(model.getDataEntity(), model.getEntryEntity("billentry"), rowIndex, isReCalTotalAmount, isCalDiscountRate);
    }

    public static void calBillAmount(DynamicObject bill, DynamicObjectCollection billentrys, int rowIndex, boolean isReCalTotalAmount) {
        PurTplHelper.calBillAmount(bill, billentrys, rowIndex, isReCalTotalAmount, Boolean.FALSE);
    }

    public static void calBillAmount(DynamicObject bill, DynamicObjectCollection billentrys, int rowIndex, boolean isReCalTotalAmount, Boolean isCalDiscountRate) {
        if (bill == null || billentrys == null || billentrys.size() == 0) {
            return;
        }
        DynamicObject billentry = (DynamicObject)billentrys.get(rowIndex);
        BillAmountInfo amountInfo = new BillAmountInfo();
        amountInfo.setInputamount(bill.getBoolean("inputamount"));
        amountInfo.setTax(bill.getBoolean("istax"));
        amountInfo.setQty(billentry.getBigDecimal("qty"));
        amountInfo.setPrice(billentry.getBigDecimal("price"));
        amountInfo.setPriceAndTax(billentry.getBigDecimal("priceandtax"));
        amountInfo.setTaxRate(billentry.getBigDecimal("taxrate"));
        amountInfo.setDiscountType(billentry.getString("discounttype"));
        amountInfo.setDiscountRate(billentry.getBigDecimal("discountrate"));
        amountInfo.setDiscountAmount(billentry.getBigDecimal("discountamount"));
        amountInfo.setExChangeRate(bill.getBigDecimal("exchangerate"));
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
        int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt("amtprecision");
        amountInfo.setSettleAmtPrecision(settleAmtPrecision);
        DynamicObject currency = bill.getDynamicObject("currency");
        int currencyAmtPrecision = currency == null ? 10 : currency.getInt("amtprecision");
        amountInfo.setCurrencyAmtPrecision(currencyAmtPrecision);
        String exchangeType = bill.getString("exchangetype");
        amountInfo.setIndirectExRate(ExchangeTypeEnum.isIndirectRate((Object)exchangeType));
        amountInfo.setAmount(billentry.getBigDecimal("amount"));
        amountInfo.setTaxAmount(billentry.getBigDecimal("taxamount"));
        amountInfo.setDiscountAmount(billentry.getBigDecimal("discountamount"));
        amountInfo.setAmountAndTax(billentry.getBigDecimal("amountandtax"));
        Map result = BillAmountHelper.calAmount((BillAmountInfo)amountInfo, (Boolean)isCalDiscountRate);
        billentry.set("price", result.get(amountInfo.getProperytMappingName("PRICE")));
        billentry.set("priceandtax", result.get(amountInfo.getProperytMappingName("PRICEANDTAX")));
        billentry.set("amount", result.get(amountInfo.getProperytMappingName("AMOUNT")));
        billentry.set("taxamount", result.get(amountInfo.getProperytMappingName("TAXAMOUNT")));
        billentry.set("discountamount", result.get(amountInfo.getProperytMappingName("DISCOUNTAMOUNT")));
        billentry.set("discountrate", result.get(amountInfo.getProperytMappingName("DISCOUNTRATE")));
        billentry.set("amountandtax", result.get(amountInfo.getProperytMappingName("AMOUNTANDTAX")));
        billentry.set("curamount", result.get(amountInfo.getProperytMappingName("CURAMOUNT")));
        billentry.set("curtaxamount", result.get(amountInfo.getProperytMappingName("CURTAXAMOUNT")));
        billentry.set("curamountandtax", result.get(amountInfo.getProperytMappingName("CURAMOUNTANDTAX")));
        PurTplHelper.calTotalBillAmount(bill, isReCalTotalAmount, result, rowIndex, RECALTOTALAMOUNT_COUNT);
    }

    public static Map<String, BigDecimal> calBillAmount(DynamicObject bill) {
        HashMap<String, BigDecimal> totalResult = new HashMap<String, BigDecimal>(8);
        if (bill == null) {
            return totalResult;
        }
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        BigDecimal totalAmount = BigDecimalUtil.ZERO;
        BigDecimal totalTaxAmount = BigDecimalUtil.ZERO;
        BigDecimal totalAllAmount = BigDecimal.ZERO;
        if (entry != null) {
            for (DynamicObject row : entry) {
                BillAmountInfo amountInfo = new BillAmountInfo();
                amountInfo.setInputamount(bill.getBoolean("inputamount"));
                amountInfo.setTax(bill.getBoolean("istax"));
                amountInfo.setQty(row.getBigDecimal("qty"));
                amountInfo.setPrice(row.getBigDecimal("price"));
                amountInfo.setPriceAndTax(row.getBigDecimal("priceandtax"));
                amountInfo.setTaxRate(row.getBigDecimal("taxrate"));
                amountInfo.setDiscountType(row.getString("discounttype"));
                amountInfo.setDiscountRate(row.getBigDecimal("discountrate"));
                amountInfo.setExChangeRate(bill.getBigDecimal("exchangerate"));
                DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
                int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt("amtprecision");
                amountInfo.setSettleAmtPrecision(settleAmtPrecision);
                DynamicObject currency = bill.getDynamicObject("currency");
                int currencyAmtPrecision = currency == null ? 10 : currency.getInt("amtprecision");
                amountInfo.setCurrencyAmtPrecision(currencyAmtPrecision);
                String exchangeType = bill.getString("exchangetype");
                amountInfo.setIndirectExRate(ExchangeTypeEnum.isIndirectRate((Object)exchangeType));
                Map result = BillAmountHelper.calAmount((BillAmountInfo)amountInfo);
                BigDecimal amount = BigDecimalUtil.getNotNull(result.get(amountInfo.getProperytMappingName("AMOUNT")));
                BigDecimal taxAmount = BigDecimalUtil.getNotNull(result.get(amountInfo.getProperytMappingName("TAXAMOUNT")));
                BigDecimal amountAndTax = BigDecimalUtil.getNotNull(result.get(amountInfo.getProperytMappingName("AMOUNTANDTAX")));
                row.set("price", result.get(amountInfo.getProperytMappingName("PRICE")));
                row.set("priceandtax", result.get(amountInfo.getProperytMappingName("PRICEANDTAX")));
                row.set("discountamount", result.get(amountInfo.getProperytMappingName("DISCOUNTAMOUNT")));
                row.set("curamount", result.get(amountInfo.getProperytMappingName("CURAMOUNT")));
                row.set("curtaxamount", result.get(amountInfo.getProperytMappingName("CURTAXAMOUNT")));
                row.set("curamountandtax", result.get(amountInfo.getProperytMappingName("CURAMOUNTANDTAX")));
                row.set("amount", (Object)amount);
                row.set("taxamount", (Object)taxAmount);
                row.set("amountandtax", (Object)amountAndTax);
                totalAmount = totalAmount.add(amount);
                totalTaxAmount = totalTaxAmount.add(taxAmount);
                totalAllAmount = totalAllAmount.add(amountAndTax);
            }
        }
        totalResult.put("totalamount", totalAmount);
        totalResult.put("totaltaxamount", totalTaxAmount);
        totalResult.put("totalallamount", totalAllAmount);
        return totalResult;
    }

    public static void calBillAllAmount(IFormView view, DynamicObject bill) {
        if (bill == null) {
            return;
        }
        Map<String, BigDecimal> totalAmountMap = PurTplHelper.calBillAmount(bill);
        view.updateView("billentry");
        if (totalAmountMap == null) {
            bill.set("totalamount", (Object)BigDecimalUtil.ZERO);
            bill.set("totaltaxamount", (Object)BigDecimalUtil.ZERO);
            bill.set("totalallamount", (Object)BigDecimalUtil.ZERO);
        } else {
            for (Map.Entry<String, BigDecimal> entry : totalAmountMap.entrySet()) {
                bill.set(entry.getKey(), (Object)entry.getValue());
            }
        }
        PurTplHelper.updateBillTotalAmount(view);
    }

    public static void updateBillAmount(IFormView view, int rowIndex) {
        if (view == null) {
            return;
        }
        view.updateView("price", rowIndex);
        view.updateView("priceandtax", rowIndex);
        view.updateView("amount", rowIndex);
        view.updateView("taxamount", rowIndex);
        view.updateView("discountamount", rowIndex);
        view.updateView("discountrate", rowIndex);
        view.updateView("amountandtax", rowIndex);
        view.updateView("curamount", rowIndex);
        view.updateView("curtaxamount", rowIndex);
        view.updateView("curamountandtax", rowIndex);
        PurTplHelper.updateBillTotalAmount(view);
    }

    public static void updateBillTotalAmount(IFormView view) {
        view.updateView("totalamount");
        view.updateView("totaltaxamount");
        view.updateView("totalallamount");
    }

    public static void calTotalBillAmount(DynamicObject bill, boolean isReCalTotalAmount, Map<String, Object> rowCalresult, int rowIndex, int reCalTotalAMountCount) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        BigDecimal totalAllAmount = BigDecimal.ZERO;
        if (bill == null) {
            return;
        }
        DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
        if (billEntrys == null || billEntrys.size() == 0) {
            bill.set("totalamount", (Object)totalAmount);
            bill.set("totaltaxamount", (Object)totalTaxAmount);
            bill.set("totalallamount", (Object)totalAllAmount);
            return;
        }
        if (isReCalTotalAmount || rowIndex < 0 || rowIndex > billEntrys.size()) {
            if (reCalTotalAMountCount == 0) {
                reCalTotalAMountCount = RECALTOTALAMOUNT_COUNT;
            }
            if (billEntrys.size() <= reCalTotalAMountCount) {
                for (DynamicObject billEntry : billEntrys) {
                    if (ChangeTypeEnum.isCancel((String)billEntry.getString("entrychangetype"))) continue;
                    BigDecimal amount = billEntry.getBigDecimal("amount");
                    BigDecimal taxamount = billEntry.getBigDecimal("taxamount");
                    BigDecimal amountandtax = billEntry.getBigDecimal("amountandtax");
                    if (amount != null) {
                        totalAmount = totalAmount.add(amount);
                    }
                    if (taxamount != null) {
                        totalTaxAmount = totalTaxAmount.add(taxamount);
                    }
                    if (amountandtax == null) continue;
                    totalAllAmount = totalAllAmount.add(amountandtax);
                }
                bill.set("totalamount", (Object)totalAmount);
                bill.set("totaltaxamount", (Object)totalTaxAmount);
                bill.set("totalallamount", (Object)totalAllAmount);
            } else {
                DynamicObject billEntry = (DynamicObject)billEntrys.get(rowIndex);
                if (billEntry == null || ChangeTypeEnum.isCancel((String)billEntry.getString("entrychangetype"))) {
                    return;
                }
                BigDecimal amount_old = billEntry.getBigDecimal("amount");
                BigDecimal taxamount_old = billEntry.getBigDecimal("taxamount");
                BigDecimal amountandtax_old = billEntry.getBigDecimal("amountandtax");
                BigDecimal amount_new = (BigDecimal)rowCalresult.get("amount");
                BigDecimal taxamount_new = (BigDecimal)rowCalresult.get("taxamount");
                BigDecimal amountandtax_new = (BigDecimal)rowCalresult.get("amountandtax");
                if (amount_old != null && amount_new != null) {
                    bill.set("totalamount", (Object)totalAmount.subtract(amount_old).add(amount_new));
                }
                if (taxamount_old != null && taxamount_new != null) {
                    bill.set("totaltaxamount", (Object)totalTaxAmount.subtract(taxamount_old).add(taxamount_new));
                }
                if (amountandtax_old != null && amountandtax_new != null) {
                    bill.set("totalallamount", (Object)totalAllAmount.subtract(amountandtax_old).add(amountandtax_new));
                }
            }
        }
    }

    public static void updateMaterial(IFormView view, int rowIndex) {
        if (view == null) {
            return;
        }
        view.updateView("material", rowIndex);
        view.updateView("materialname", rowIndex);
        view.updateView("materialmasterid", rowIndex);
        view.updateView("qty", rowIndex);
        view.updateView("unit", rowIndex);
        view.updateView("baseqty", rowIndex);
        view.updateView("baseunit", rowIndex);
        view.updateView("auxqty", rowIndex);
        view.updateView("auxunit", rowIndex);
        view.updateView("price", rowIndex);
        view.updateView("priceandtax", rowIndex);
        view.updateView("amount", rowIndex);
        view.updateView("taxamount", rowIndex);
        view.updateView("discountamount", rowIndex);
        view.updateView("amountandtax", rowIndex);
        view.updateView("curamount", rowIndex);
        view.updateView("curtaxamount", rowIndex);
        view.updateView("curamountandtax", rowIndex);
        PurTplHelper.updateBillTotalAmount(view);
    }

    public static QFilter getUnitF7QFilter(Long masterMaterialId, DynamicObject baseUnit) {
        long srcMuId = baseUnit == null ? 0L : (Long)baseUnit.getPkValue();
        List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcMuId, (String)"1");
        return new QFilter("id", "in", (Object)unitIds);
    }

    public static void setEnableByBizStatus(IFormView view) {
        IDataModel model = view.getModel();
        String closeStatus = (String)model.getValue("closestatus");
        if (BizCloseStatusEnum.CLOSE.getValue().equals(closeStatus)) {
            view.setEnable(Boolean.FALSE, new String[]{"bar_unaudit", "bar_bizclose", "bar_bizchange"});
            view.setEnable(Boolean.TRUE, new String[]{"bar_bizunclose"});
        } else if (BizCloseStatusEnum.UNCLOSE.getValue().equals(closeStatus)) {
            view.setEnable(Boolean.FALSE, new String[]{"bar_bizunclose"});
            view.setEnable(Boolean.TRUE, new String[]{"contentpanel", "bar_del", "bar_save", "bar_submit", "bar_unaudit", "bar_bizoperation", "bar_bizclose", "bar_bizchange"});
        }
    }

    public static void setEnableByInputAmount(IFormView view) {
        IDataModel model = view.getModel();
        Boolean inputAmount = (Boolean)model.getValue("inputamount");
        Boolean isTax = (Boolean)model.getValue("istax");
        if (isTax.booleanValue() && inputAmount.booleanValue()) {
            view.setEnable(Boolean.TRUE, -1, new String[]{"amountandtax"});
            view.setEnable(Boolean.FALSE, -1, new String[]{"priceandtax", "price", "amount"});
        } else if (isTax.booleanValue() && !inputAmount.booleanValue()) {
            view.setEnable(Boolean.TRUE, -1, new String[]{"priceandtax"});
            view.setEnable(Boolean.FALSE, -1, new String[]{"amount", "price", "amountandtax"});
        } else if (!isTax.booleanValue() && inputAmount.booleanValue()) {
            view.setEnable(Boolean.TRUE, -1, new String[]{"amount"});
            view.setEnable(Boolean.FALSE, -1, new String[]{"price", "priceandtax", "amountandtax"});
        } else if (!isTax.booleanValue() && !inputAmount.booleanValue()) {
            view.setEnable(Boolean.TRUE, -1, new String[]{"price"});
            view.setEnable(Boolean.FALSE, -1, new String[]{"amountandtax", "amount", "priceandtax"});
        }
    }

    public static Map<String, Object> getDefaultByProviderSupplier(DynamicObject providerSupplier) {
        DynamicObject providerAddress = SupplierHelper.getDefaultAddress(providerSupplier);
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("provideraddressf7", providerAddress);
        map.put("provideraddress", SupplierHelper.getDetailAddress(providerAddress));
        map.put("providerlinkman", SupplierHelper.getDefaultLinkMan(providerSupplier));
        return map;
    }

    public static Long getOrgOwner(IDataModel model, IFormView view, int rowIndex) {
        DynamicObject entryReqOrg = (DynamicObject)model.getValue("entryreqorg", rowIndex);
        DynamicObject entryRecOrg = (DynamicObject)model.getValue("entryrecorg", rowIndex);
        Long ownerId = null;
        if (entryReqOrg != null && entryRecOrg != null) {
            Long reqOrgId = (Long)entryReqOrg.getPkValue();
            Long recOrgId = (Long)entryRecOrg.getPkValue();
            ownerId = OwnerHelper.getDefaultOwner((Long)reqOrgId, (Long)recOrgId);
        }
        return ownerId;
    }

    public static void initOwner(IDataModel model, IFormView view, Long orgId, Long supplierId, int rowIndex) {
        DynamicObject bizType = (DynamicObject)model.getValue("biztype");
        if (bizType != null && BizCategoryHelper.isVMI((Long)bizType.getPkValue())) {
            model.setValue("ownertype", (Object)OwnerTypeEnum.OWNERTYPE_SUPPLIER.getValue(), rowIndex);
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"ownertype", "owner"});
        }
        String ownerType = (String)model.getValue("ownertype", rowIndex);
        if (OwnerTypeEnum.OWNERTYPE_SUPPLIER.getValue().equals(ownerType)) {
            model.setValue("owner", (Object)supplierId, rowIndex);
        } else if (OwnerTypeEnum.OWNERTYPE_ORG.getValue().equals(ownerType)) {
            model.setValue("owner", (Object)PurTplHelper.getOrgOwner(model, view, rowIndex), rowIndex);
        }
    }

    public static void initBillInfo(IDataModel bill) {
        long userId = UserServiceHelper.getCurrentUserId();
        DynamicObject org = (DynamicObject)bill.getValue("org");
        if (org != null) {
            Map currencyAndExRateMap;
            Long orgId = (Long)org.getPkValue();
            DynamicObject operator = OperatorGroupHelper.getDefaultOperatorObject((Long)orgId, (String)OperatorGrpTypeEnum.PURCHASEGRP.getValue(), (Long)userId);
            DynamicObject dept = (DynamicObject)bill.getValue("dept");
            if (operator != null) {
                bill.setValue("operator", operator.getPkValue());
                Long operatorGroupId = operator.getLong("operatorgrpid");
                bill.setValue("operatorgroup", (Object)operatorGroupId);
                if (dept == null) {
                    bill.setValue("dept", (Object)OrgHelper.getDefaultDepartment((Long)UserServiceHelper.getCurrentUserId()));
                }
            }
            if ((currencyAndExRateMap = CurrencyHelper.getCurrencyAndExRateTable((Long)org.getLong("id"))) != null) {
                bill.setValue("currency", currencyAndExRateMap.get("baseCurrencyID"));
                bill.setValue("settlecurrency", currencyAndExRateMap.get("baseCurrencyID"));
                bill.setValue("exchangetype", (Object)ExchangeTypeEnum.DIRECT.getValue());
                bill.setValue("exchangerate", (Object)BigDecimalUtil.ONE);
                bill.setValue("exratetable", currencyAndExRateMap.get("exchangeRateTableID"));
            }
        }
        DynamicObject billType = (DynamicObject)bill.getValue("billtype");
        Long bizTypeId = null;
        if (billType != null) {
            bizTypeId = BizTypeHelper.getDefaultBizType((String)bill.getDataEntityType().getName(), (Long)((Long)billType.getPkValue()), (String)"pm_billtypeparameter");
            bill.setValue("biztype", (Object)bizTypeId);
        }
        DynamicObject supplier = (DynamicObject)bill.getValue("supplier");
        DynamicObject lineType = BizTypeHelper.getDefaultLineTypeObject(bizTypeId);
        Long supplierId = supplier == null ? null : (Long)supplier.getPkValue();
        int entryRowCount = bill.getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            bill.setValue("linetype", (Object)lineType, i);
            if (lineType != null && BizCategoryHelper.isVMI((Long)lineType.getPkValue())) {
                bill.setValue("ownertype", (Object)OwnerTypeEnum.OWNERTYPE_SUPPLIER.getValue(), i);
                bill.setValue("owner", (Object)supplierId, i);
                continue;
            }
            bill.setValue("ownertype", (Object)OwnerTypeEnum.OWNERTYPE_ORG.getValue(), i);
            DynamicObject entryReqOrg = (DynamicObject)bill.getValue("entryreqorg");
            DynamicObject entryRecOrg = (DynamicObject)bill.getValue("entryrecorg");
            if (entryReqOrg == null || entryRecOrg == null) continue;
            bill.setValue("owner", (Object)OwnerHelper.getDefaultOwner((Long)((Long)entryReqOrg.getPkValue()), (Long)((Long)entryRecOrg.getPkValue())), i);
        }
    }

    public static void completeBillInfo(DynamicObject bill) {
        DynamicObject settleCurrency;
        Map currencyAndExRateMap;
        Date bizdate;
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject dept = bill.getDynamicObject("dept");
        if (dept == null) {
            Long deptID = OrgHelper.getDefaultDepartment((Long)UserServiceHelper.getCurrentUserId());
            bill.set("dept", (Object)MetadataUtils.newDynamicObject((String)"bos_org", (Long)deptID));
        }
        DynamicObject billType = bill.getDynamicObject("billtype");
        DynamicObject bizType = bill.getDynamicObject("biztype");
        if (billType != null && bizType == null) {
            Long bizTypeId = BizTypeHelper.getDefaultBizType((String)bill.getDataEntityType().getName(), (Long)((Long)billType.getPkValue()), (String)"pm_billtypeparameter");
            bizType = MetadataUtils.newDynamicObject((String)"bd_biztype", (Long)bizTypeId);
            bill.set("biztype", (Object)bizType);
        }
        if ((bizdate = bill.getDate("biztime")) == null) {
            bill.set("biztime", (Object)TimeServiceHelper.today());
        }
        Date exratedate = bill.getDate("exratedate");
        Calendar instance = Calendar.getInstance();
        instance.set(11, 0);
        instance.set(12, 0);
        instance.set(13, 0);
        instance.set(14, 0);
        Date time = instance.getTime();
        if (exratedate.compareTo(time) == 0) {
            bill.set("exratedate", (Object)bizdate);
        }
        DynamicObject currency = bill.getDynamicObject("currency");
        DynamicObject exRateTable = bill.getDynamicObject("exratetable");
        if ((currency == null || exRateTable == null) && (currencyAndExRateMap = CurrencyHelper.getCurrencyAndExRateTable((Long)((Long)org.getPkValue()))) != null) {
            bill.set("currency", (Object)MetadataUtils.newDynamicObject((String)"bd_currency", (Long)((Long)currencyAndExRateMap.get("baseCurrencyID"))));
            bill.set("exratetable", (Object)MetadataUtils.newDynamicObject((String)"bd_exratetable", (Long)((Long)currencyAndExRateMap.get("exchangeRateTableID"))));
        }
        if ((settleCurrency = bill.getDynamicObject("settlecurrency")) == null) {
            bill.set("settlecurrency", (Object)bill.getDynamicObject("currency"));
            bill.set("exchangerate", (Object)BigDecimal.ONE);
        }
        Long settleCurrencyId = (Long)bill.getDynamicObject("settlecurrency").getPkValue();
        Long currencyId = (Long)bill.getDynamicObject("currency").getPkValue();
        Long exRateTableId = (Long)bill.getDynamicObject("exratetable").getPkValue();
        Date exRateDate = bill.getDate("exratedate");
        Map exChangeRateMap = CurrencyHelper.getExChangeRateMap((Long)settleCurrencyId, (Long)currencyId, (Long)exRateTableId, (Date)exRateDate);
        BigDecimal exChangeRate = (BigDecimal)exChangeRateMap.get("exchangerate");
        String exchangeType = (String)exChangeRateMap.get("exchangetype");
        bill.set("exchangetype", (Object)exchangeType);
        if (BigDecimalUtil.isBlank((BigDecimal)exChangeRate)) {
            bill.set("exchangerate", (Object)exChangeRate);
        }
        DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
        DynamicObject lineTypeId = BizTypeHelper.getDefaultLineTypeObject((Long)((Long)bizType.getPkValue()));
        for (DynamicObject billEntry : billEntrys) {
            Date deliverdate;
            DynamicObject taxRateId;
            Object discountType;
            DynamicObject material = billEntry.getDynamicObject("material");
            if (material == null || material.getDynamicObject("masterid") == null) continue;
            DynamicObject lineType = billEntry.getDynamicObject("linetype");
            if (lineType == null) {
                billEntry.set("linetype", (Object)lineTypeId);
            }
            DynamicObject materialMasterID = material.getDynamicObject("masterid");
            billEntry.set("materialmasterid", (Object)materialMasterID);
            boolean isDisposable = materialMasterID.getBoolean("isdisposable");
            if (StringUtils.isBlank((Object)billEntry.get("materialname")) || !isDisposable) {
                billEntry.set("materialname", (Object)materialMasterID.getLocaleString("name").toString());
            }
            if (billEntry.get("auxunit") == null) {
                billEntry.set("auxunit", (Object)material.getDynamicObject("masterid").getDynamicObject("auxptyunit"));
            }
            if (billEntry.get("baseunit") == null) {
                billEntry.set("baseunit", (Object)material.getDynamicObject("masterid").getDynamicObject("baseunit"));
            }
            BigDecimal qty = billEntry.getBigDecimal("qty");
            DynamicObject unit = billEntry.getDynamicObject("unit");
            DynamicObject baseUnit = billEntry.getDynamicObject("baseunit");
            if (unit != null && baseUnit != null) {
                if (unit.getPkValue().equals(baseUnit.getPkValue())) {
                    billEntry.set("baseqty", (Object)qty);
                } else {
                    billEntry.set("baseqty", (Object)BillQuantityHelper.getDesQtyConv((Long)((Long)material.getDynamicObject("masterid").getPkValue()), (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit));
                }
            }
            BigDecimal disCountRate = billEntry.getBigDecimal("discountrate");
            if (billEntry.getString("discounttype").equals(DiscountTypeEnum.DISRATE.getValue())) {
                if (disCountRate.compareTo(new BigDecimal(100)) > 0) {
                    billEntry.set("discountrate", (Object)new BigDecimal(100));
                } else if (disCountRate.compareTo(BigDecimal.ZERO) < 0) {
                    billEntry.set("discountrate", (Object)BigDecimal.ZERO);
                }
            }
            if ((discountType = billEntry.get("discounttype")).equals(DiscountTypeEnum.NULL.getValue())) {
                billEntry.set("discountrate", (Object)BigDecimal.ZERO);
            }
            if ((taxRateId = billEntry.getDynamicObject("taxrateid")) == null) {
                billEntry.set("taxrate", (Object)BigDecimal.ZERO);
            } else {
                BigDecimal taxRate = taxRateId.getBigDecimal("taxrate");
                billEntry.set("taxrate", (Object)taxRate);
            }
            boolean isPresent = billEntry.getBoolean("ispresent");
            boolean isTax = bill.getBoolean("istax");
            if (isPresent) {
                if (isTax) {
                    BigDecimal priceAndTax = billEntry.getBigDecimal("priceandtax");
                    if (priceAndTax.compareTo(BigDecimal.ZERO) > 0) {
                        billEntry.set("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue());
                        billEntry.set("discountrate", (Object)new BigDecimal("100"));
                    } else {
                        billEntry.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                        billEntry.set("discountrate", (Object)BigDecimal.ZERO);
                    }
                } else {
                    BigDecimal price = billEntry.getBigDecimal("price");
                    if (price.compareTo(BigDecimal.ZERO) > 0) {
                        billEntry.set("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue());
                        billEntry.set("discountrate", (Object)new BigDecimal("100"));
                    } else {
                        billEntry.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                        billEntry.set("discountrate", (Object)BigDecimal.ZERO);
                    }
                }
                billEntry.set("amount", (Object)BigDecimalUtil.ZERO);
                billEntry.set("curamount", (Object)BigDecimalUtil.ZERO);
                billEntry.set("taxamount", (Object)BigDecimalUtil.ZERO);
                billEntry.set("curtaxamount", (Object)BigDecimalUtil.ZERO);
                billEntry.set("amountandtax", (Object)BigDecimalUtil.ZERO);
                billEntry.set("curamountandtax", (Object)BigDecimalUtil.ZERO);
            }
            if ((deliverdate = (Date)billEntry.get("deliverdate")).compareTo(time) != 0) continue;
            billEntry.set("deliverdate", (Object)bill.getDate("biztime"));
        }
        Map<String, BigDecimal> totalResult = PurTplHelper.calBillAmount(bill);
        bill.set("totalamount", (Object)totalResult.get("totalamount"));
        bill.set("totaltaxamount", (Object)totalResult.get("totaltaxamount"));
        bill.set("totalallamount", (Object)totalResult.get("totalallamount"));
    }
}

