/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mspur.business;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mspur.common.enums.SupplierFunction;

public class SupplierHelper {
    public static final String BIZ_FUNCTION_KEY = "bizfunction";
    public static final String PURCHASE_HOLD = "purchasehold";
    public static final String INVOICE_HOLD = "invoicehold";
    public static final String PAY_HOLD = "payhold";
    public static final String DELIVER_SUPPLIER_KEY = "deliversupplierid";
    public static final String INVOICE_SUPPLIER_KEY = "invoicesupplierid";
    public static final String RECEIVING_SUPPLIER_KEY = "receivingsupplierid";
    public static final String SETTLE_CURRENCY_KEY = "settlementcyid";

    public static String getDefaultAddressString(DynamicObject supplier) {
        ILocaleString defaultAddress = SupplierHelper.getDefaultAddressLocaleString(supplier);
        if (defaultAddress != null) {
            return defaultAddress.toString();
        }
        return null;
    }

    public static ILocaleString getDefaultAddressLocaleString(DynamicObject supplier) {
        return SupplierHelper.getDetailAddress(SupplierHelper.getDefaultAddress(supplier));
    }

    public static Long getDefaultAddressId(DynamicObject supplier) {
        DynamicObject defaultAddress = SupplierHelper.getDefaultAddress(supplier, "id,default,invalid");
        if (defaultAddress == null) {
            return null;
        }
        return defaultAddress.getLong("id");
    }

    public static DynamicObject getDefaultAddress(DynamicObject supplier, String selectProperties) {
        QFilter invalid;
        QFilter supplierId;
        DynamicObject[] load;
        if (supplier != null && StringUtils.isNotBlank((Object)supplier.getPkValue()) && (load = BusinessDataServiceHelper.load((String)"bd_address", (String)selectProperties, (QFilter[])new QFilter[]{supplierId = new QFilter("supplierid", "=", (Object)supplier.getPkValue().toString()), invalid = new QFilter("invalid", "=", (Object)Boolean.FALSE)}, (String)"default desc", (int)1)) != null && load.length > 0) {
            return load[0];
        }
        return null;
    }

    public static DynamicObject getDefaultAddress(DynamicObject supplier) {
        return SupplierHelper.getDefaultAddress(supplier, "id,default,invalid,detailaddress");
    }

    public static DynamicObject getDefaultLinkMan(DynamicObject supplier) {
        Long defaultLinkManId = SupplierHelper.getDefaultLinkManId(supplier);
        if (defaultLinkManId == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)defaultLinkManId, (String)"bd_supplierlinkman");
    }

    public static Long getDefaultLinkManId(DynamicObject supplier) {
        if (supplier == null) {
            return null;
        }
        Long defaultLinkManId = null;
        DynamicObjectCollection linkmans = supplier.getDynamicObjectCollection("entry_linkman");
        for (DynamicObject linkman : linkmans) {
            boolean isDefault = linkman.getBoolean("isdefault_linkman");
            boolean invalid = linkman.getBoolean("invalid");
            if (isDefault && !invalid) {
                return (Long)linkman.getPkValue();
            }
            if (defaultLinkManId != null || invalid) continue;
            defaultLinkManId = (Long)linkman.getPkValue();
        }
        return defaultLinkManId;
    }

    public static Long getDefaultSettleTypeId(DynamicObject supplier) {
        DynamicObject settleType = SupplierHelper.getDefaultSettleType(supplier);
        if (settleType == null) {
            return null;
        }
        return (Long)settleType.getPkValue();
    }

    public static DynamicObject getDefaultSettleType(DynamicObject supplier) {
        DynamicObject settleType;
        if (supplier != null && (settleType = supplier.getDynamicObject("settlementtypeid")) != null) {
            return settleType;
        }
        QFilter isDefault = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter isEnable = new QFilter("enable", "=", (Object)"1");
        QFilter filter = isDefault.and(isEnable);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (String)"id,isdefault,enable", (QFilter[])filter.toArray());
    }

    public static DynamicObject getDefaultSettleCurrency(DynamicObject supplier) {
        if (supplier == null) {
            return null;
        }
        return supplier.getDynamicObject(SETTLE_CURRENCY_KEY);
    }

    private static DynamicObject getDefaultReceiveSupplier(DynamicObject supplier) {
        if (supplier == null) {
            return null;
        }
        return supplier.getDynamicObject(RECEIVING_SUPPLIER_KEY);
    }

    private static DynamicObject getDefaultInvoiceSupplier(DynamicObject supplier) {
        if (supplier == null) {
            return null;
        }
        return supplier.getDynamicObject(INVOICE_SUPPLIER_KEY);
    }

    private static DynamicObject getDefaultDeliverSupplier(DynamicObject supplier) {
        if (supplier == null) {
            return null;
        }
        return supplier.getDynamicObject(DELIVER_SUPPLIER_KEY);
    }

    public static ILocaleString getDetailAddress(DynamicObject address) {
        if (address == null) {
            return null;
        }
        return address.getLocaleString("detailaddress");
    }

    public static DynamicObject getOtherSupplier(DynamicObject supplier, String otherSupplierKey) {
        if (otherSupplierKey == null) {
            return null;
        }
        switch (otherSupplierKey) {
            case "deliversupplierid": {
                return SupplierHelper.getDefaultDeliverSupplier(supplier);
            }
            case "invoicesupplierid": {
                return SupplierHelper.getDefaultInvoiceSupplier(supplier);
            }
            case "receivingsupplierid": {
                return SupplierHelper.getDefaultReceiveSupplier(supplier);
            }
        }
        return null;
    }

    public static Long getOtherSupplierId(DynamicObject supplier, String otherSupplierKey) {
        DynamicObject otherSupplier = SupplierHelper.getOtherSupplier(supplier, otherSupplierKey);
        if (otherSupplier != null) {
            return (Long)otherSupplier.getPkValue();
        }
        return null;
    }

    public static QFilter getPurchaseFilter() {
        return QFilter.like((String)BIZ_FUNCTION_KEY, (String)SupplierFunction.PURCHASE.getValue());
    }

    public static QFilter getInvoiceFilter() {
        return QFilter.like((String)BIZ_FUNCTION_KEY, (String)SupplierFunction.INVOICE.getValue());
    }

    public static QFilter getReceiveFilter() {
        return QFilter.like((String)BIZ_FUNCTION_KEY, (String)SupplierFunction.RECEIVE.getValue());
    }

    public static QFilter getDeliverFilter() {
        return QFilter.like((String)BIZ_FUNCTION_KEY, (String)SupplierFunction.DELIVER.getValue());
    }

    public static boolean validBizFunction(DynamicObject supplier, SupplierFunction function) {
        if (supplier == null) {
            return false;
        }
        String bizFunction = SupplierHelper.getBizFunction(supplier);
        if (bizFunction == null) {
            return false;
        }
        return function != null && bizFunction.contains(function.getValue());
    }

    public static boolean isPurchaseHold(DynamicObject supplier) {
        return supplier != null && supplier.getBoolean(PURCHASE_HOLD);
    }

    public static void nullToDefault(DynamicObject dynamicObject, DynamicObject defaultValue, String ... supplierKeys) {
        if (supplierKeys == null) {
            return;
        }
        for (String supplierKey : supplierKeys) {
            if (supplierKey == null || dynamicObject.getDynamicObject(supplierKey) != null) continue;
            dynamicObject.set(supplierKey, (Object)defaultValue);
        }
    }

    private static String getBizFunction(DynamicObject supplier) {
        return supplier.getString(BIZ_FUNCTION_KEY);
    }
}

