/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mspur.formplugin;

import java.math.BigDecimal;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.mpscmm.msbd.business.helper.AmountPlanHelper;
import kd.mpscmm.msbd.common.context.CommonContext;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.mspur.business.PoTplHelper;
import kd.mpscmm.mspur.business.PurTplHelper;

public class PoTplEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("true".equals(this.getPageCache().get("stopChange"))) {
            return;
        }
        String fieldName = e.getProperty().getName();
        if (CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            Object newValue = e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            switch (fieldName) {
                case "material": {
                    this.changeMaterial(oldValue, newValue, rowIndex);
                    break;
                }
                case "qty": {
                    this.changeQty(fieldName, newValue, rowIndex);
                    break;
                }
                case "unit": {
                    PoTplHelper.calReceiveQtyUpDown(this.getModel(), rowIndex);
                    PoTplHelper.updateReceiveQtyUpDown(this.getView(), rowIndex);
                    break;
                }
                case "auxqty": {
                    PurTplHelper.calBillQuantity(fieldName, this.getModel(), rowIndex);
                    break;
                }
                case "price": {
                    this.changeBillAmount(rowIndex);
                    break;
                }
                case "priceandtax": {
                    this.changeBillAmount(rowIndex);
                    break;
                }
                case "taxrate": {
                    this.changeBillAmount(rowIndex);
                    break;
                }
                case "discounttype": 
                case "discountrate": 
                case "discountamount": {
                    this.changeBillAmount(rowIndex);
                    break;
                }
                case "amount": 
                case "amountandtax": {
                    this.changeBillAmount(rowIndex);
                    break;
                }
                case "payrate": {
                    this.changePayRate(newValue, rowIndex);
                    break;
                }
                case "payamount": {
                    this.changePayAmount(newValue, rowIndex);
                    break;
                }
                case "iscontrolqty": {
                    this.changeIsControlQty(newValue, rowIndex);
                    break;
                }
                case "iscontrolday": {
                    this.changeIsControlDay(newValue, rowIndex);
                    break;
                }
                case "receiverateup": {
                    this.changeReceiveRateUp(newValue, rowIndex);
                    break;
                }
                case "receiveratedown": {
                    this.changeReceiveRateDown(newValue, rowIndex);
                    break;
                }
                case "paycondition": {
                    this.changePayCondition(newValue);
                    break;
                }
                case "totalallamount": {
                    PoTplHelper.calAmountPlan(this.getView());
                    break;
                }
                case "settlecurrency": {
                    PoTplHelper.calAmountPlan(this.getView());
                    break;
                }
            }
        }
    }

    private void changeMaterial(Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        this.getPageCache().put("stopChange", "true");
        Boolean isControlQty = Boolean.FALSE;
        BigDecimal receiveRateUp = BigDecimalUtil.ZERO;
        BigDecimal receiveRateDown = BigDecimalUtil.ZERO;
        Boolean isControlDay = Boolean.FALSE;
        int receiveDayUp = 0;
        int receiveDayDown = 0;
        if (newValue instanceof DynamicObject) {
            DynamicObject material = (DynamicObject)newValue;
            isControlQty = material.getBoolean("iscontrolqty");
            if (isControlQty.booleanValue()) {
                receiveRateUp = material.getBigDecimal("receiverateup");
                receiveRateDown = material.getBigDecimal("receiveratedown");
            }
            if ((isControlDay = Boolean.valueOf(material.getBoolean("iscontrolday"))).booleanValue()) {
                receiveDayUp = material.getInt("receivedayup");
                receiveDayDown = material.getInt("receivedaydown");
                model.setValue("receivedayup", (Object)receiveDayUp, rowIndex);
                model.setValue("receivedaydown", (Object)receiveDayDown, rowIndex);
            }
        }
        model.setValue("iscontrolqty", (Object)isControlQty, rowIndex);
        model.setValue("receiverateup", (Object)receiveRateUp, rowIndex);
        model.setValue("receiveratedown", (Object)receiveRateDown, rowIndex);
        model.setValue("receiveqtyup", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("receiveqtydown", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("receivebaseqtyup", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("receivebaseqtydown", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("iscontrolday", (Object)isControlDay, rowIndex);
        model.setValue("receivedayup", (Object)receiveDayUp, rowIndex);
        model.setValue("receivedaydown", (Object)receiveDayDown, rowIndex);
        this.getPageCache().put("stopChange", "false");
    }

    private void changeIsControlQty(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof Boolean) {
            boolean isControlQty = (Boolean)newValue;
            BigDecimal qty = BigDecimalUtil.getNotNull((Object)model.getValue("qty", rowIndex));
            BigDecimal baseQty = BigDecimalUtil.getNotNull((Object)model.getValue("baseqty", rowIndex));
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            this.getPageCache().put("stopChange", "true");
            if (isControlQty) {
                BigDecimal receiveRateDown;
                BigDecimal receiveRateUp;
                DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
                if (material == null) {
                    receiveRateUp = BigDecimalUtil.ZERO;
                    receiveRateDown = BigDecimalUtil.ZERO;
                } else {
                    receiveRateUp = material.getBigDecimal("receiverateup");
                    receiveRateDown = material.getBigDecimal("receiveratedown");
                }
                BigDecimal receiveQtyUp = PoTplHelper.getReceiveQtyUp(qty, receiveRateUp, unit);
                BigDecimal receiveQtyDown = PoTplHelper.getReceiveQtyDown(qty, receiveRateDown, unit);
                BigDecimal receiveBaseQtyUp = PoTplHelper.getReceiveQtyUp(baseQty, receiveRateUp, baseUnit);
                BigDecimal receiveBaseQtyDown = PoTplHelper.getReceiveQtyDown(baseQty, receiveRateDown, baseUnit);
                model.setValue("receiverateup", (Object)receiveRateUp, rowIndex);
                model.setValue("receiveratedown", (Object)receiveRateDown, rowIndex);
                model.setValue("receiveqtyup", (Object)receiveQtyUp, rowIndex);
                model.setValue("receiveqtydown", (Object)receiveQtyDown, rowIndex);
                model.setValue("receivebaseqtyup", (Object)receiveBaseQtyUp, rowIndex);
                model.setValue("receivebaseqtydown", (Object)receiveBaseQtyDown, rowIndex);
            } else {
                model.setValue("receiverateup", (Object)BigDecimalUtil.ZERO, rowIndex);
                model.setValue("receiveratedown", (Object)BigDecimalUtil.ZERO, rowIndex);
                model.setValue("receiveqtyup", (Object)qty, rowIndex);
                model.setValue("receiveqtydown", (Object)qty, rowIndex);
                model.setValue("receivebaseqtyup", (Object)baseQty, rowIndex);
                model.setValue("receivebaseqtydown", (Object)baseQty, rowIndex);
            }
            this.getPageCache().put("stopChange", "false");
        }
    }

    private void changeIsControlDay(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof Boolean) {
            boolean isControlDay = (Boolean)newValue;
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            if (material == null) {
                return;
            }
            this.getPageCache().put("stopChange", "true");
            if (isControlDay) {
                BigDecimal receiveDayUp = material.getBigDecimal("receivedayup");
                BigDecimal receiveDayDown = material.getBigDecimal("receivedaydown");
                model.setValue("receivedayup", (Object)receiveDayUp, rowIndex);
                model.setValue("receivedaydown", (Object)receiveDayDown, rowIndex);
            } else {
                model.setValue("receivedayup", (Object)0, rowIndex);
                model.setValue("receivedaydown", (Object)0, rowIndex);
            }
            this.getPageCache().put("stopChange", "false");
        }
    }

    private void changeReceiveRateUp(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof BigDecimal) {
            BigDecimal receiveRateUp = (BigDecimal)newValue;
            BigDecimal qty = BigDecimalUtil.getNotNull((Object)model.getValue("qty", rowIndex));
            BigDecimal baseQty = BigDecimalUtil.getNotNull((Object)model.getValue("baseqty", rowIndex));
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            BigDecimal receiveQtyUp = PoTplHelper.getReceiveQtyUp(qty, receiveRateUp, unit);
            BigDecimal receiveBaseQtyUp = PoTplHelper.getReceiveQtyUp(baseQty, receiveRateUp, baseUnit);
            model.setValue("receiveqtyup", (Object)receiveQtyUp, rowIndex);
            model.setValue("receivebaseqtyup", (Object)receiveBaseQtyUp, rowIndex);
        }
    }

    private void changeReceiveRateDown(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof BigDecimal) {
            BigDecimal receiveRateDown = (BigDecimal)newValue;
            BigDecimal qty = BigDecimalUtil.getNotNull((Object)model.getValue("qty", rowIndex));
            BigDecimal baseQty = BigDecimalUtil.getNotNull((Object)model.getValue("baseqty", rowIndex));
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            BigDecimal receiveQtyDown = PoTplHelper.getReceiveQtyDown(qty, receiveRateDown, unit);
            BigDecimal receiveBaseQtyDown = PoTplHelper.getReceiveQtyDown(baseQty, receiveRateDown, baseUnit);
            model.setValue("receiveqtydown", (Object)receiveQtyDown, rowIndex);
            model.setValue("receivebaseqtydown", (Object)receiveBaseQtyDown, rowIndex);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
    }

    private void changeBillAmount(int rowIndex) {
        PoTplHelper.calAmountPlan(this.getView());
    }

    private void changeQty(String fieldName, Object newValue, int rowIndex) {
        PoTplHelper.calReceiveQtyUpDown(this.getModel(), rowIndex);
        PoTplHelper.updateReceiveQtyUpDown(this.getView(), rowIndex);
        PoTplHelper.calAmountPlan(this.getView());
    }

    private void changePayRate(Object newValue, int rowIndex) {
        PoTplHelper.calAmountPlan(this.getView());
    }

    private void changePayAmount(Object newValue, int rowIndex) {
        PoTplHelper.calAmountPlan(this.getView());
    }

    private void changePayCondition(Object newValue) {
        if (newValue == null) {
            return;
        }
        AmountPlanHelper.changeAmountConditionForView((CommonContext)PoTplHelper.getPayPlanCommonText(this.getView().getEntityId()), (IFormView)this.getView());
    }
}

