/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mspur.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.AmountPlanHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.business.helper.CurrencyHelper;
import kd.mpscmm.msbd.business.helper.OperatorGroupFilterHelper;
import kd.mpscmm.msbd.business.helper.OperatorGroupHelper;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.business.helper.OwnerHelper;
import kd.mpscmm.msbd.common.context.CommonContext;
import kd.mpscmm.msbd.common.enums.BillCreTypeEnum;
import kd.mpscmm.msbd.common.enums.ChangeTypeEnum;
import kd.mpscmm.msbd.common.enums.DiscountTypeEnum;
import kd.mpscmm.msbd.common.enums.EnableStatusEnum;
import kd.mpscmm.msbd.common.enums.ExchangeTypeEnum;
import kd.mpscmm.msbd.common.enums.OperatorGrpTypeEnum;
import kd.mpscmm.msbd.common.enums.OwnerTypeEnum;
import kd.mpscmm.msbd.common.enums.PayModeEnum;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.common.utils.AppCacheUtils;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.BillCreTypeUtils;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.mspur.business.BizCategoryHelper;
import kd.mpscmm.mspur.business.MaterialHelper;
import kd.mpscmm.mspur.business.PoTplHelper;
import kd.mpscmm.mspur.business.PurTplHelper;
import kd.mpscmm.mspur.business.SupplierHelper;

public class PurTplEditPlugin
extends AbstractBillPlugIn
implements EntryGridBindDataListener,
BeforeF7SelectListener,
AfterF7SelectListener {
    long userId = UserServiceHelper.getCurrentUserId();

    public void registerListener(EventObject e) {
        EntryGrid billEntry;
        BasedataEdit invoiceBizType;
        BasedataEdit priceList;
        BasedataEdit owner;
        BasedataEdit warehouse;
        BasedataEdit taxRateIDEdit;
        BasedataEdit unitEdit;
        BasedataEdit materialMasterEdit;
        BasedataEdit materialEdit;
        BasedataEdit entryBizTypeEdit;
        BasedataEdit invoiceSupplierEdit;
        BasedataEdit ReceiveSupplierEdit;
        BasedataEdit providerAddressF7;
        BasedataEdit supplierLinkmanEdit;
        BasedataEdit providerSupplierEdit;
        BasedataEdit addressF7;
        BasedataEdit lierLinkmanEdit;
        BasedataEdit supplierEdit;
        BasedataEdit bizTypeEdit;
        BasedataEdit deptEdit;
        BasedataEdit operatorEdit;
        IFormView view = this.getView();
        super.registerListener(e);
        BasedataEdit operatorGroupEdit = (BasedataEdit)view.getControl("operatorgroup");
        if (operatorGroupEdit != null) {
            operatorGroupEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((operatorEdit = (BasedataEdit)view.getControl("operator")) != null) {
            operatorEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((deptEdit = (BasedataEdit)view.getControl("dept")) != null) {
            deptEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizTypeEdit = (BasedataEdit)view.getControl("biztype")) != null) {
            bizTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplierEdit = (BasedataEdit)view.getControl("supplier")) != null) {
            supplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((lierLinkmanEdit = (BasedataEdit)view.getControl("linkman")) != null) {
            lierLinkmanEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((addressF7 = (BasedataEdit)view.getControl("addressf7")) != null) {
            addressF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((providerSupplierEdit = (BasedataEdit)view.getControl("providersupplier")) != null) {
            providerSupplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplierLinkmanEdit = (BasedataEdit)view.getControl("providerlinkman")) != null) {
            supplierLinkmanEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((providerAddressF7 = (BasedataEdit)view.getControl("provideraddressf7")) != null) {
            providerAddressF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((ReceiveSupplierEdit = (BasedataEdit)view.getControl("receivesupplier")) != null) {
            ReceiveSupplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((invoiceSupplierEdit = (BasedataEdit)view.getControl("invoicesupplier")) != null) {
            invoiceSupplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryBizTypeEdit = (BasedataEdit)view.getControl("linetype")) != null) {
            entryBizTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialEdit = (BasedataEdit)view.getControl("material")) != null) {
            materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            materialEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
        if ((materialMasterEdit = (BasedataEdit)view.getControl("materialmasterid")) != null) {
            materialMasterEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((unitEdit = (BasedataEdit)view.getControl("unit")) != null) {
            unitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((taxRateIDEdit = (BasedataEdit)view.getControl("taxrateid")) != null) {
            taxRateIDEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((warehouse = (BasedataEdit)this.getView().getControl("warehouse")) != null) {
            warehouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((owner = (BasedataEdit)this.getView().getControl("owner")) != null) {
            owner.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((priceList = (BasedataEdit)this.getControl("pricelist")) != null) {
            priceList.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((invoiceBizType = (BasedataEdit)this.getControl("invoicebiztype")) != null) {
            invoiceBizType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((billEntry = (EntryGrid)this.getControl("billentry")) != null) {
            billEntry.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        PurTplHelper.setEnableByBizStatus(this.getView());
        PurTplHelper.setEnableByInputAmount(this.getView());
        this.setDiscountRateScale(this.getModel().getValue("settlecurrency"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        AbstractOperate operate = (AbstractOperate)e.getSource();
        switch (key = operate.getOperateKey()) {
            case "discountamount": {
                DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
                if (settleCurrency == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u7ed3\u7b97\u5e01\u201d\u3002", (String)"PurTplEditPlugin_21", (String)"mpscmm-mspur", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                int rowCount = this.getModel().getEntryRowCount("billentry");
                Boolean isHasRow = Boolean.FALSE;
                for (int i = 0; i < rowCount; ++i) {
                    BigDecimal discountAmount = (BigDecimal)this.getModel().getValue("discountamount", i);
                    BigDecimal amountAndTax = (BigDecimal)this.getModel().getValue("amountandtax", i);
                    boolean isPresent = (Boolean)this.getModel().getValue("ispresent", i);
                    if (isPresent || amountAndTax.add(discountAmount).compareTo(BigDecimal.ZERO) <= 0) continue;
                    isHasRow = Boolean.TRUE;
                    break;
                }
                if (isHasRow.booleanValue()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4ef7\u7a0e\u5408\u8ba1+\u6298\u6263\u989d\u201d\u4e3a0\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u603b\u6298\u6263\u989d\u3002", (String)"PurTplEditPlugin_22", (String)"mpscmm-mspur", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey = e.getOperateKey();
        if ("bizclose".equals(operateKey) || "bizunclose".equals(operateKey)) {
            PurTplHelper.setEnableByBizStatus(this.getView());
        } else if ("discountamount".equals(operateKey)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("mspur_discountamount");
            HashMap<String, Object> customParams = new HashMap<String, Object>(8);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
            customParams.put("currency", settleCurrency.getPkValue());
            formShowParameter.setCustomParams(customParams);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mspur_discountamount"));
            this.getView().showForm(formShowParameter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        PurTplHelper.initBillInfo(this.getModel());
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        this.setDiscountRateScale(this.getModel().getValue("settlecurrency"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("true".equals(this.getPageCache().get("stopChange"))) {
            return;
        }
        String fieldName = e.getProperty().getName();
        if (CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            Object newValue = e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            switch (fieldName) {
                case "operatorgroup": {
                    this.changeOperatorGroup(newValue);
                    break;
                }
                case "operator": {
                    this.changeOperator(newValue);
                    break;
                }
                case "billtype": {
                    this.changeBillType(newValue);
                    break;
                }
                case "biztype": {
                    this.changeBizType(oldValue, newValue);
                    break;
                }
                case "supplier": {
                    this.changeSupplier(newValue);
                    break;
                }
                case "addressf7": {
                    this.changeAddressF7(newValue, "address");
                    break;
                }
                case "providersupplier": {
                    this.changeProviderSupplier(newValue);
                    break;
                }
                case "provideraddressf7": {
                    this.changeAddressF7(newValue, "provideraddress");
                    break;
                }
                case "exchangerate": {
                    this.changeBillAmount();
                    break;
                }
                case "linetype": {
                    this.changeLineType(oldValue, newValue, rowIndex);
                    break;
                }
                case "materialgroup": {
                    this.changeMaterialGroup(oldValue, newValue, rowIndex);
                    break;
                }
                case "material": {
                    this.changeMaterial(oldValue, newValue, rowIndex);
                    break;
                }
                case "materialmasterid": {
                    this.changeMaterialMaster(oldValue, newValue, rowIndex);
                    break;
                }
                case "qty": {
                    this.changeQty(fieldName, newValue, rowIndex);
                    break;
                }
                case "unit": {
                    this.changeUnit(fieldName, newValue, rowIndex);
                    break;
                }
                case "auxqty": {
                    PurTplHelper.calBillQuantity(fieldName, this.getModel(), rowIndex);
                    break;
                }
                case "istax": {
                    this.changeInputAmount();
                    break;
                }
                case "price": {
                    this.changeBillAmount(rowIndex);
                    break;
                }
                case "priceandtax": {
                    this.changeBillAmount(rowIndex);
                    break;
                }
                case "taxrateid": {
                    this.changeTaxRateID(newValue, rowIndex);
                    break;
                }
                case "taxrate": {
                    this.changeBillAmount(rowIndex);
                    break;
                }
                case "discounttype": 
                case "discountrate": {
                    this.changeDiscountType(fieldName, oldValue, newValue, rowIndex);
                    this.changeBillAmount(rowIndex);
                    break;
                }
                case "discountamount": {
                    if (!this.changeDiscountAmountInfo(oldValue, rowIndex)) break;
                    this.changeBillAmount(rowIndex, Boolean.TRUE);
                    break;
                }
                case "amount": 
                case "amountandtax": {
                    this.changeBillAmount(rowIndex);
                    break;
                }
                case "ispresent": {
                    this.changeIsPresent(newValue, rowIndex);
                    break;
                }
                case "entryrecorg": {
                    this.changeEntryRecOrg(rowIndex);
                }
                case "entryreqorg": {
                    this.changeEntryReqOrg(rowIndex);
                    break;
                }
                case "entrysettleorg": {
                    this.changeEntrySettleOrg(newValue, rowIndex);
                    break;
                }
                case "inputamount": {
                    this.changeInputAmount();
                    break;
                }
                case "entrychangetype": {
                    if (!ChangeTypeEnum.isCancel((String)((String)newValue)) && !ChangeTypeEnum.isCancel((String)((String)oldValue))) break;
                    this.updateHeadAmount();
                    break;
                }
                case "settlecurrency": {
                    this.changeSettleCurrency(newValue);
                    break;
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        String fieldKey = e.getProperty().getName();
        DynamicObject org = (DynamicObject)model.getValue("org");
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        if (!"org".equals(fieldKey)) {
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurTplEditPlugin_1", (String)"mpscmm-mspur", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (billType == null && !"billtype".equals(fieldKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"PurTplEditPlugin_2", (String)"mpscmm-mspur", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
        Long orgId = (Long)org.getPkValue();
        Long userId = UserServiceHelper.getCurrentUserId();
        DynamicObject operator = (DynamicObject)model.getValue("operator");
        DynamicObject bizType = (DynamicObject)model.getValue("biztype");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        switch (fieldKey) {
            case "biztype": {
                List bizTypeIds;
                if (billType == null || (bizTypeIds = BizTypeHelper.getAllBizTypes((String)this.getView().getEntityId(), (Long)((Long)billType.getPkValue()), (String)"pm_billtypeparameter")) == null) break;
                QFilter q1 = new QFilter("id", "in", (Object)bizTypeIds);
                showParameter.getListFilterParameter().getQFilters().add(q1);
                break;
            }
            case "operator": {
                QFilter invalidFilter = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                if (OperatorGroupHelper.isOperatorGroupIsolate((Long)orgId, (String)this.getModel().getDataEntityType().getBizAppNumber())) {
                    QFilter grpFilter = OperatorGroupFilterHelper.getOperatorGroupByUserForAll((long)UserServiceHelper.getCurrentUserId(), (DynamicObject)org, (String)OperatorGrpTypeEnum.PURCHASEGRP.getValue());
                    showParameter.getListFilterParameter().getQFilters().add(grpFilter.and(invalidFilter));
                    break;
                }
                List operatorGroups = OperatorGroupHelper.getAllOperatorGroupByOrg((Long)orgId, (String)OperatorGrpTypeEnum.PURCHASEGRP.getValue());
                QFilter grpFilter = new QFilter("operatorgrpid", "in", (Object)operatorGroups);
                showParameter.getListFilterParameter().getQFilters().add(grpFilter.and(invalidFilter));
                break;
            }
            case "operatorgroup": {
                if (operator == null) {
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "=", (Object)0));
                    break;
                }
                QFilter q1 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.PURCHASEGRP.getValue());
                QFilter q2 = new QFilter("entryentity.id", "=", operator.getPkValue());
                showParameter.getListFilterParameter().getQFilters().add(q1.and(q2));
                break;
            }
            case "dept": {
                DynamicObject user;
                List deptIDs = OrgHelper.getAllToOrg((String)"15", (String)"01", (Long)orgId, (boolean)true);
                if (operator != null && (user = operator.getDynamicObject("operatorid")) != null) {
                    Long userID = (Long)user.getPkValue();
                    Long deptID = UserServiceHelper.getUserMainOrgId((long)userID);
                    deptIDs.add(deptID);
                }
                QFilter q1 = new QFilter("id", "in", (Object)deptIDs);
                showParameter.getListFilterParameter().getQFilters().add(q1);
                break;
            }
            case "supplier": {
                QFilter supplierFilter;
                if (bizType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"PurTplEditPlugin_3", (String)"mpscmm-mspur", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter holdFilter = new QFilter("purchasehold", "=", (Object)Boolean.FALSE);
                Long bizTypeID = (Long)bizType.getPkValue();
                if (BizCategoryHelper.isVMI(bizTypeID)) {
                    QFilter qFilter = new QFilter("enablevmi", "=", (Object)"1");
                    showParameter.getListFilterParameter().getQFilters().add(qFilter.and(holdFilter));
                }
                if ((supplierFilter = PoTplHelper.getSupplierFilter(fieldKey)) == null) break;
                showParameter.getListFilterParameter().getQFilters().add(supplierFilter.and(holdFilter));
                break;
            }
            case "providersupplier": 
            case "invoicesupplier": 
            case "receivesupplier": {
                QFilter supplierFilter;
                if (bizType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"PurTplEditPlugin_3", (String)"mpscmm-mspur", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                DynamicObject supplier = (DynamicObject)model.getValue("supplier");
                if (supplier == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u4f9b\u5e94\u5546\u3002", (String)"PurTplEditPlugin_4", (String)"mpscmm-mspur", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                Long bizTypeID = (Long)bizType.getPkValue();
                if (BizCategoryHelper.isVMI(bizTypeID)) {
                    QFilter qFilter = new QFilter("enablevmi", "=", (Object)"1");
                    showParameter.getListFilterParameter().getQFilters().add(qFilter);
                }
                if ((supplierFilter = PoTplHelper.getSupplierFilter(fieldKey)) == null) break;
                showParameter.getListFilterParameter().getQFilters().add(supplierFilter);
                break;
            }
            case "linkman": {
                DynamicObject supplier = (DynamicObject)model.getValue("supplier");
                if (supplier == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u4f9b\u5e94\u5546\u3002", (String)"PurTplEditPlugin_4", (String)"mpscmm-mspur", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                List supperlinkManIds = supplier.getDynamicObjectCollection("entry_linkman").stream().filter(dym -> !dym.getBoolean("invalid")).map(dym -> dym.getLong("id")).collect(Collectors.toList());
                QFilter suplmFilter = new QFilter("supplierid", "=", supplier.getPkValue());
                QFilter lmids = new QFilter("id", "in", supperlinkManIds);
                showParameter.getListFilterParameter().getQFilters().add(suplmFilter.and(lmids));
                break;
            }
            case "providerlinkman": {
                DynamicObject providerSupplier = (DynamicObject)model.getValue("providersupplier");
                if (providerSupplier == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f9b\u8d27\u4f9b\u5e94\u5546\u3002", (String)"PurTplEditPlugin_5", (String)"mpscmm-mspur", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                List supperlinkManIds = providerSupplier.getDynamicObjectCollection("entry_linkman").stream().filter(dym -> !dym.getBoolean("invalid")).map(dym -> dym.getLong("id")).collect(Collectors.toList());
                QFilter suplmFilter = new QFilter("supplierid", "=", providerSupplier.getPkValue());
                QFilter lmids = new QFilter("id", "in", supperlinkManIds);
                showParameter.getListFilterParameter().getQFilters().add(suplmFilter.and(lmids));
                break;
            }
            case "addressf7": {
                DynamicObject supplier = (DynamicObject)model.getValue("supplier");
                if (supplier == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u4f9b\u5e94\u5546\u3002", (String)"PurTplEditPlugin_4", (String)"mpscmm-mspur", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter supplierid = new QFilter("supplierid", "=", (Object)supplier.getPkValue().toString());
                QFilter invalid = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                showParameter.getListFilterParameter().getQFilters().add(supplierid.and(invalid));
                break;
            }
            case "provideraddressf7": {
                DynamicObject providerSupplier = (DynamicObject)model.getValue("providersupplier");
                if (providerSupplier == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f9b\u8d27\u4f9b\u5e94\u5546\u3002", (String)"PurTplEditPlugin_5", (String)"mpscmm-mspur", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter supplierid = new QFilter("supplierid", "=", (Object)providerSupplier.getPkValue().toString());
                QFilter invalid = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                showParameter.getListFilterParameter().getQFilters().add(supplierid.and(invalid));
                break;
            }
            case "linetype": {
                if (bizType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"PurTplEditPlugin_3", (String)"mpscmm-mspur", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                List allLineTypes = BizTypeHelper.getAllLineTypes((Long)((Long)bizType.getPkValue()));
                if (allLineTypes == null) break;
                QFilter filter = new QFilter("id", "in", (Object)allLineTypes);
                showParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "material": {
                Long lineTypeId;
                Long bizTypeId;
                DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype", rowIndex);
                if (lineType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u7c7b\u578b\u3002", (String)"PurTplEditPlugin_6", (String)"mpscmm-mspur", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                Long billTypeId = billType == null ? null : (Long)billType.getPkValue();
                List<QFilter> qFilterByLineType = MaterialHelper.getQFilterByLineType(billTypeId, bizTypeId = bizType == null ? null : (Long)bizType.getPkValue(), lineTypeId = (Long)lineType.getPkValue(), true);
                if (qFilterByLineType == null) break;
                showParameter.getListFilterParameter().getQFilters().addAll(qFilterByLineType);
                break;
            }
            case "materialmasterid": {
                Long lineTypeId;
                Long bizTypeId;
                DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype", rowIndex);
                if (lineType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u7c7b\u578b\u3002", (String)"PurTplEditPlugin_6", (String)"mpscmm-mspur", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                Long billTypeId = billType == null ? null : (Long)billType.getPkValue();
                List<QFilter> qFilterByLineType = MaterialHelper.getQFilterByLineType(billTypeId, bizTypeId = bizType == null ? null : (Long)bizType.getPkValue(), lineTypeId = (Long)lineType.getPkValue(), false);
                if (qFilterByLineType != null) {
                    showParameter.getListFilterParameter().getQFilters().addAll(qFilterByLineType);
                }
                QFilter useRangeFilter = QFilter.sqlExpress((String)"id", (String)"in", (String)"select fmasterid from t_bd_materialpurinfo where fenable = '1' and fstatus = 'C'");
                showParameter.getListFilterParameter().getQFilters().add(useRangeFilter);
                break;
            }
            case "unit": {
                DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
                DynamicObject materialGroup = (DynamicObject)model.getValue("materialgroup", rowIndex);
                if (material == null && materialGroup == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"PurTplEditPlugin_7", (String)"mpscmm-mspur", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                if (material == null) break;
                showParameter.getListFilterParameter().getQFilters().add(PurTplHelper.getUnitF7QFilter((Long)material.getDynamicObject("masterid").getPkValue(), (DynamicObject)model.getValue("baseunit", rowIndex)));
                break;
            }
            case "taxrateid": {
                Date bizTime = (Date)model.getValue("biztime");
                QFilter activeQfilter = new QFilter("activedate", "<=", (Object)bizTime);
                QFilter expQfilter = new QFilter("expdate", ">", (Object)bizTime);
                expQfilter = QFilter.isNull((String)"expdate").or(expQfilter);
                QFilter qFilter = expQfilter.and(activeQfilter);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "warehouse": {
                DynamicObject entryRecOrg = (DynamicObject)model.getValue("entryrecorg", rowIndex);
                if (entryRecOrg != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6536\u8d27\u7ec4\u7ec7\u3002", (String)"PurTplEditPlugin_8", (String)"mpscmm-mspur", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "owner": {
                String ownerType = (String)model.getValue("ownertype", rowIndex);
                DynamicObject entryRecOrg = (DynamicObject)model.getValue("entryrecorg", rowIndex);
                showParameter.getListFilterParameter().getQFilters().add(OwnerHelper.getOwnerF7QFilter((String)ownerType, (DynamicObject)entryRecOrg));
                break;
            }
            case "pricelist": {
                DynamicObject supplier = (DynamicObject)model.getValue("supplier");
                if (supplier == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u4f9b\u5e94\u5546\u3002", (String)"PurTplEditPlugin_4", (String)"mpscmm-mspur", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter q1 = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
                QFilter q2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
                QFilter q3 = new QFilter("org", "=", org.getPkValue());
                Long[] supplierIds = new Long[]{(Long)supplier.getPkValue(), 0L};
                QFilter q4 = new QFilter("supplierid", "in", (Object)supplierIds);
                Date bizTime = (Date)model.getValue("biztime");
                QFilter q5 = new QFilter("priceentryentity.priceeffectdate", "<=", (Object)bizTime);
                QFilter q6 = new QFilter("priceentryentity.priceexpirydate", ">=", (Object)bizTime);
                showParameter.getListFilterParameter().getQFilters().add(q1.and(q2).and(q3).and(q4).and(q5).and(q6));
                break;
            }
            case "invoicebiztype": {
                String appNmuber = this.getModel().getDataEntityType().getAppId();
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNmuber);
                if (appInfo == null) break;
                String bizCloudNumber = appInfo.getCloudNum();
                QFilter appIdQFilter = new QFilter("mulbiz.fbasedataid.number", "=", (Object)bizCloudNumber);
                QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
                showParameter.getListFilterParameter().getQFilters().add(appIdQFilter.and(enableQFilter));
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        DynamicObject org = (DynamicObject)model.getValue("org");
        DynamicObject supplier = (DynamicObject)model.getValue("supplier");
        Long supplierId = supplier == null ? null : (Long)supplier.getPkValue();
        DynamicObject bizType = (DynamicObject)model.getValue("biztype");
        if (rowDataEntities != null && rowDataEntities.length >= 1 && org != null && bizType != null) {
            switch (entryName) {
                case "billentry": {
                    Long bizTypeId = (Long)bizType.getPkValue();
                    Long lineTypeId = BizTypeHelper.getDefaultLineType((Long)bizTypeId);
                    for (RowDataEntity rowDataEntity : rowDataEntities) {
                        int rowIndex = rowDataEntity.getRowIndex();
                        if (model.getValue("linetype", rowIndex) == null) {
                            model.setValue("linetype", (Object)lineTypeId, rowIndex);
                        }
                        PoTplHelper.initOwner(model, view, (Long)org.getPkValue(), supplierId, rowIndex);
                    }
                    this.updateHeadAmount();
                }
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            this.updateHeadAmount();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        switch (callBackId) {
            case "callback_biztype": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    DynamicObject biztype;
                    Long bizTYpeID;
                    boolean isCredit;
                    model.setValue("supplier", null);
                    model.setValue("linkman", null);
                    model.setValue("address", null);
                    model.setValue("providersupplier", null);
                    model.setValue("providerlinkman", null);
                    model.setValue("provideraddress", null);
                    model.setValue("invoicesupplier", null);
                    model.setValue("receivesupplier", null);
                    model.setValue("settletype", null);
                    DynamicObject currency = (DynamicObject)model.getValue("currency");
                    if (currency != null) {
                        model.setValue("settlecurrency", currency.getPkValue());
                    }
                    if (isCredit = BizCategoryHelper.isCredit(bizTYpeID = (biztype = (DynamicObject)this.getModel().getValue("biztype")) == null ? null : (Long)biztype.getPkValue())) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{"paymode"});
                        model.setValue("paymode", (Object)PayModeEnum.CREDIT.getValue());
                    } else {
                        this.getView().setEnable(Boolean.TRUE, new String[]{"paymode"});
                    }
                    model.deleteEntryData("billentry");
                    model.createNewEntryRow("billentry");
                    break;
                }
                String bizTypeId = view.getPageCache().get("cache_biztype");
                this.getPageCache().put("stopChange", "true");
                model.setValue("biztype", bizTypeId == null ? null : Long.valueOf(Long.parseLong(bizTypeId)));
                this.getPageCache().put("stopChange", "false");
                break;
            }
            case "callback_linetype": {
                Map params = (Map)SerializationUtils.fromJsonString((String)e.getCustomVaule(), Map.class);
                if (params == null || params.isEmpty()) break;
                int rowIndex = Integer.parseInt((String)params.get("linetype_rowindex"));
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    model.setValue("material", null, rowIndex);
                    model.setValue("materialname", null, rowIndex);
                    model.setValue("expenseitem", null, rowIndex);
                    break;
                }
                String lineTypeId = (String)params.get("linetype_old");
                this.getPageCache().put("stopChange", "true");
                model.setValue("linetype", (Object)(lineTypeId == null ? null : Long.valueOf(Long.parseLong(lineTypeId))), rowIndex);
                this.getPageCache().put("stopChange", "false");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        block3 : switch (actionId) {
            case "mspur_discountamount": {
                BigDecimal rowDistAmount;
                int i;
                boolean isPresent;
                BigDecimal amountAndTax;
                BigDecimal discountAmount;
                int i2;
                Map discountMap;
                if (returnData == null || (discountMap = (Map)returnData) == null || discountMap.isEmpty() || discountMap.get("discountamount") == null) break;
                BigDecimal totalDiscountAmount = new BigDecimal(discountMap.get("discountamount").toString());
                BigDecimal remainDiscountAmount = new BigDecimal(discountMap.get("discountamount").toString());
                DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
                int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt("amtprecision");
                BigDecimal allAmountAndTaxAndDiscount = BigDecimal.ZERO;
                int rowCount = this.getModel().getEntryRowCount("billentry");
                for (i2 = 0; i2 < rowCount; ++i2) {
                    discountAmount = (BigDecimal)this.getModel().getValue("discountamount", i2);
                    amountAndTax = (BigDecimal)this.getModel().getValue("amountandtax", i2);
                    isPresent = (Boolean)this.getModel().getValue("ispresent", i2);
                    if (isPresent) continue;
                    allAmountAndTaxAndDiscount = allAmountAndTaxAndDiscount.add(discountAmount).add(amountAndTax);
                }
                if (totalDiscountAmount.compareTo(BigDecimal.ZERO) <= 0 || totalDiscountAmount.compareTo(allAmountAndTaxAndDiscount) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6574\u5355\u201c\u4ef7\u683c\u5408\u8ba1+\u6298\u6263\u989d\u201d\u5927\u4e8e0\u65f6\uff0c\u603b\u6298\u6263\u989d\u5fc5\u987b\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u7b49\u4e8e\u6574\u5355\u201c\u4ef7\u683c\u5408\u8ba1+\u6298\u6263\u989d\u201d\u3002", (String)"PurTplEditPlugin_23", (String)"mpscmm-mspur", (Object[])new Object[0]));
                    return;
                }
                for (i2 = 0; i2 < rowCount; ++i2) {
                    discountAmount = (BigDecimal)this.getModel().getValue("discountamount", i2);
                    amountAndTax = (BigDecimal)this.getModel().getValue("amountandtax", i2);
                    isPresent = (Boolean)this.getModel().getValue("ispresent", i2);
                    if (isPresent || discountAmount.add(amountAndTax).compareTo(BigDecimal.ZERO) <= 0) continue;
                    this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), i2);
                }
                BigDecimal allAmountAndTax = BigDecimal.ZERO;
                ArrayList<Integer> allDistRows = new ArrayList<Integer>(16);
                for (i = 0; i < rowCount; ++i) {
                    BigDecimal amountAndTax2 = (BigDecimal)this.getModel().getValue("amountandtax", i);
                    boolean isPresent2 = (Boolean)this.getModel().getValue("ispresent", i);
                    if (isPresent2 || amountAndTax2.compareTo(BigDecimal.ZERO) <= 0) continue;
                    allAmountAndTax = allAmountAndTax.add(amountAndTax2);
                    allDistRows.add(i);
                }
                if (allAmountAndTax.compareTo(BigDecimal.ZERO) <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4ef7\u7a0e\u5408\u8ba1+\u6298\u6263\u989d\u201d\u4e3a0\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u603b\u6298\u6263\u989d\u3002", (String)"PurTplEditPlugin_22", (String)"mpscmm-mspur", (Object[])new Object[0]));
                    return;
                }
                for (i = 0; i < allDistRows.size(); ++i) {
                    int rowIndex = (Integer)allDistRows.get(i);
                    BigDecimal amountAndTax3 = (BigDecimal)this.getModel().getValue("amountandtax", rowIndex);
                    rowDistAmount = BigDecimal.ZERO;
                    rowDistAmount = i == allDistRows.size() - 1 ? remainDiscountAmount : totalDiscountAmount.multiply(amountAndTax3).divide(allAmountAndTax, settleAmtPrecision, 4);
                    if (rowDistAmount.compareTo(amountAndTax3) > 0) {
                        rowDistAmount = amountAndTax3;
                    }
                    remainDiscountAmount = remainDiscountAmount.subtract(rowDistAmount);
                    this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.FIXEDDIS.getValue(), rowIndex);
                    this.getModel().setValue("discountamount", (Object)rowDistAmount, rowIndex);
                }
                if (remainDiscountAmount.compareTo(BigDecimal.ZERO) <= 0 || allDistRows.isEmpty()) break;
                for (i = allDistRows.size() - 1; i >= 0; --i) {
                    Integer rowIndex = (Integer)allDistRows.get(i);
                    if (remainDiscountAmount.compareTo(BigDecimal.ZERO) == 0) break block3;
                    BigDecimal amountAndTax4 = (BigDecimal)this.getModel().getValue("amountandtax", rowIndex.intValue());
                    rowDistAmount = (BigDecimal)this.getModel().getValue("discountamount", rowIndex.intValue());
                    if (amountAndTax4.compareTo(BigDecimal.ZERO) == 0) continue;
                    if (remainDiscountAmount.compareTo(amountAndTax4) < 0) {
                        remainDiscountAmount = BigDecimal.ZERO;
                        this.getModel().setValue("discountamount", (Object)rowDistAmount.add(remainDiscountAmount), rowIndex.intValue());
                        continue;
                    }
                    remainDiscountAmount = remainDiscountAmount.subtract(amountAndTax4);
                    this.getModel().setValue("discountamount", (Object)rowDistAmount.add(amountAndTax4), rowIndex.intValue());
                }
                break;
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if ("material".equals(key)) {
            Long lineTypeID;
            int currentRowIndex = e.getCurrentRowIndex();
            ListSelectedRowCollection listSelectedRowCollection = e.getListSelectedRowCollection();
            DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype", currentRowIndex);
            Long l = lineTypeID = lineType == null ? null : (Long)lineType.getPkValue();
            if (listSelectedRowCollection.size() > 1) {
                this.getPageCache().put("stopChange", "true");
                for (int i = 1; i < listSelectedRowCollection.size(); ++i) {
                    this.getModel().setValue("linetype", (Object)lineTypeID, i + currentRowIndex);
                }
                this.getPageCache().put("stopChange", "false");
            }
        }
    }

    private void changeOperatorGroup(Object newValue) {
        if (newValue == null) {
            this.getPageCache().put("stopChange", "true");
            this.getModel().setValue("operator", null);
            this.getPageCache().put("stopChange", "false");
            this.getModel().setValue("dept", null);
        }
    }

    private void changeOperator(Object newValue) {
        Long deptID = null;
        this.getPageCache().put("stopChange", "true");
        if (newValue instanceof DynamicObject) {
            Long userID;
            DynamicObject operator = (DynamicObject)newValue;
            this.getModel().setValue("operatorgroup", operator.get("operatorgrpid"));
            Long l = userID = operator.get("operatorid") != null ? (Long)((DynamicObject)operator.get("operatorid")).getPkValue() : null;
            if (userID != null) {
                deptID = UserServiceHelper.getUserMainOrgId((long)userID);
            }
        } else {
            this.getModel().setValue("operatorgroup", null);
        }
        this.getPageCache().put("stopChange", "false");
        this.getModel().setValue("dept", deptID);
    }

    private void changeBillType(Object newValue) {
        if (newValue instanceof DynamicObject) {
            DynamicObject billType = (DynamicObject)newValue;
            String formId = this.getView().getEntityId();
            Long defaultBizType = BizTypeHelper.getDefaultBizType((String)formId, (Long)((Long)billType.getPkValue()), (String)"pm_billtypeparameter");
            this.getModel().setValue("biztype", (Object)defaultBizType);
        }
    }

    private void changeBizType(Object oldValue, Object newValue) {
        if (oldValue instanceof DynamicObject && newValue == null) {
            DynamicObject bizType_old = (DynamicObject)oldValue;
            this.getPageCache().put("stopChange", "true");
            this.getModel().setValue("biztype", bizType_old.getPkValue());
            this.getPageCache().put("stopChange", "false");
        } else if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject) {
            DynamicObject bizType_old = (DynamicObject)oldValue;
            String msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u4f9b\u5e94\u5546\u53ca\u7269\u6599\u660e\u7ec6\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"PurTplEditPlugin_9", (String)"mpscmm-mspur", (Object[])new Object[0]);
            MessageBoxOptions options = MessageBoxOptions.YesNo;
            ConfirmCallBackListener callBack = new ConfirmCallBackListener("callback_biztype", (IFormPlugin)this);
            this.getView().showConfirm(msg, options, ConfirmTypes.Default, callBack);
            this.getView().getPageCache().put("cache_biztype", bizType_old.getPkValue().toString());
        }
    }

    private void changeSupplier(Object newValue) {
        String appId;
        DynamicObject invoiceType;
        DynamicObject supplier = (DynamicObject)newValue;
        IDataModel model = this.getModel();
        Object invoiceBizType = model.getValue("invoicebiztype");
        if (invoiceBizType == null && (invoiceType = PoTplHelper.getInvoiceType(supplier, appId = this.getView().getFormShowParameter().getAppId())) != null) {
            model.setValue("invoicebiztype", (Object)invoiceType);
        }
        model.setValue("pricelist", null);
        model.setValue("providersupplier", (Object)SupplierHelper.getOtherSupplierId(supplier, "deliversupplierid"));
        model.setValue("invoicesupplier", (Object)SupplierHelper.getOtherSupplierId(supplier, "invoicesupplierid"));
        model.setValue("receivesupplier", (Object)SupplierHelper.getOtherSupplierId(supplier, "receivingsupplierid"));
        model.setValue("settletype", (Object)SupplierHelper.getDefaultSettleTypeId(supplier));
        model.setValue("linkman", (Object)SupplierHelper.getDefaultLinkManId(supplier));
        model.setValue("address", (Object)SupplierHelper.getDefaultAddressLocaleString(supplier));
        model.setValue("addressf7", (Object)SupplierHelper.getDefaultAddressId(supplier));
        DynamicObject settleCurrency = SupplierHelper.getDefaultSettleCurrency(supplier);
        if (settleCurrency != null) {
            model.setValue("settlecurrency", settleCurrency.getPkValue());
        } else {
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            model.setValue("settlecurrency", currency == null ? null : currency.getPkValue());
        }
        if (supplier != null) {
            DynamicObject payCondtion = supplier.getDynamicObject("paycond");
            if (payCondtion == null) {
                model.setValue("paycondition", null);
            } else {
                model.setValue("paycondition", payCondtion.getPkValue());
                payCondtion = BusinessDataServiceHelper.loadSingle((Object)payCondtion.getPkValue(), (String)"bd_paycondition");
            }
            this.changePayCondition(payCondtion);
        }
    }

    private void changePayCondition(Object newValue) {
        if (newValue == null) {
            return;
        }
        AmountPlanHelper.changeAmountConditionForView((CommonContext)PoTplHelper.getPayPlanCommonText(this.getView().getEntityId()), (IFormView)this.getView());
    }

    private void changeProviderSupplier(Object newValue) {
        IDataModel bill = this.getModel();
        DynamicObject providerSupplier = (DynamicObject)newValue;
        Map<String, Object> defaultValues = PurTplHelper.getDefaultByProviderSupplier(providerSupplier);
        for (Map.Entry<String, Object> entry : defaultValues.entrySet()) {
            bill.setValue(entry.getKey(), entry.getValue());
        }
    }

    private void changeAddressF7(Object newValue, String updateKey) {
        if (newValue instanceof DynamicObject) {
            IDataModel bill = this.getModel();
            ILocaleString address = SupplierHelper.getDetailAddress((DynamicObject)newValue);
            if (address != null) {
                bill.setValue(updateKey, (Object)address);
            }
        }
    }

    private void changeLineType(Object oldValue, Object newValue, int rowIndex) {
        if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject) {
            DynamicObject lineType_old = (DynamicObject)oldValue;
            String msg = ResManager.loadKDString((String)"\u884c\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u7269\u6599\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"PurTplEditPlugin_10", (String)"mpscmm-mspur", (Object[])new Object[0]);
            ConfirmCallBackListener callBack = new ConfirmCallBackListener("callback_linetype", "");
            HashMap<String, String> callBackParams = new HashMap<String, String>(8);
            callBackParams.put("linetype_old", lineType_old.getPkValue().toString());
            callBackParams.put("linetype_rowindex", String.valueOf(rowIndex));
            this.getView().showConfirm(msg, null, MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack, null, SerializationUtils.toJsonString(callBackParams));
        } else if (oldValue instanceof DynamicObject && newValue == null) {
            Long lineType_old_id = (Long)((DynamicObject)oldValue).getPkValue();
            this.getPageCache().put("stopChange", "true");
            this.getModel().setValue("linetype", (Object)lineType_old_id, rowIndex);
            this.getPageCache().put("stopChange", "false");
        }
    }

    protected void changeMaterial(Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        this.getPageCache().put("stopChange", "true");
        model.setValue("materialname", null, rowIndex);
        model.setValue("materialmasterid", null, rowIndex);
        model.setValue("auxpty", null, rowIndex);
        model.setValue("unit", null, rowIndex);
        model.setValue("auxunit", null, rowIndex);
        model.setValue("baseunit", null, rowIndex);
        model.setValue("qty", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("auxqty", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("baseqty", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("price", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("priceandtax", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("taxrateid", null, rowIndex);
        model.setValue("taxrate", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
        model.setValue("discountrate", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("discountamount", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("ispresent", null, rowIndex);
        BigDecimal oldAmount = (BigDecimal)model.getValue("amount", rowIndex);
        BigDecimal oldTaxAmount = (BigDecimal)model.getValue("taxamount", rowIndex);
        BigDecimal oldAmountAndTax = (BigDecimal)model.getValue("amountandtax", rowIndex);
        model.setValue("amount", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("taxamount", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("amountandtax", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("curamount", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("curtaxamount", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("curamountandtax", (Object)BigDecimalUtil.ZERO, rowIndex);
        if (newValue instanceof DynamicObject) {
            DynamicObject supplier;
            DynamicObject defaultTaxRate;
            DynamicObject material = (DynamicObject)newValue;
            DynamicObject master = material.getDynamicObject("masterid");
            if (master != null) {
                model.setValue("materialmasterid", master.getPkValue(), rowIndex);
                model.setValue("materialname", (Object)master.getLocaleString("name"), rowIndex);
                if (master.getBoolean("isdisposable")) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"materialname"});
                } else {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"materialname"});
                }
                if (master.getDynamicObject("auxptyunit") != null) {
                    model.setValue("auxunit", master.getDynamicObject("auxptyunit").getPkValue(), rowIndex);
                }
                if (master.getDynamicObject("baseunit") != null) {
                    model.setValue("baseunit", master.getDynamicObject("baseunit").getPkValue(), rowIndex);
                }
            }
            if (material.getDynamicObject("purchaseunit") != null) {
                model.setValue("unit", material.getDynamicObject("purchaseunit").getPkValue(), rowIndex);
            }
            if ((defaultTaxRate = MaterialHelper.getDefaultTaxRate(supplier = (DynamicObject)model.getValue("supplier"), material)) != null) {
                model.setValue("taxrateid", defaultTaxRate.getPkValue(), rowIndex);
                model.setValue("taxrate", (Object)defaultTaxRate.getBigDecimal("taxrate"), rowIndex);
            }
        }
        this.getPageCache().put("stopChange", "false");
        if (!ChangeTypeEnum.CANCEL.getValue().equals(model.getValue("entrychangetype", rowIndex))) {
            BigDecimal totalAmount = BigDecimalUtil.getNotNull((Object)model.getValue("totalamount"));
            BigDecimal totalTaxAmount = BigDecimalUtil.getNotNull((Object)model.getValue("totaltaxamount"));
            BigDecimal totalAllAmount = BigDecimalUtil.getNotNull((Object)model.getValue("totalallamount"));
            if (oldAmount != null) {
                totalAmount = totalAmount.subtract(oldAmount);
            }
            if (oldTaxAmount != null) {
                totalTaxAmount = totalTaxAmount.subtract(oldTaxAmount);
            }
            if (oldAmountAndTax != null) {
                totalAllAmount = totalAllAmount.subtract(oldAmountAndTax);
            }
            model.setValue("totalamount", (Object)totalAmount);
            model.setValue("totaltaxamount", (Object)totalTaxAmount);
            model.setValue("totalallamount", (Object)totalAllAmount);
        }
    }

    private void changeMaterialMaster(Object oldValue, Object newValue, int rowIndex) {
        if (newValue instanceof DynamicObject) {
            QFilter qf2;
            IDataModel model = this.getModel();
            DynamicObject materialMaster = (DynamicObject)newValue;
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject materialGroup = materialMaster.getDynamicObject("group");
            Long orgId = org == null ? null : Long.valueOf(org.getLong("id"));
            Long materialMasterId = materialMaster.getLong("id");
            Long materialGroupId = materialGroup == null ? null : Long.valueOf(materialGroup.getLong("id"));
            QFilter qf1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialpurchaseinfo", (Long)orgId);
            DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialpurchaseinfo", (QFilter[])new QFilter[]{qf1, qf2 = new QFilter("masterid", "=", (Object)materialMasterId)});
            if (material != null) {
                model.setValue("material", material.getPkValue(), rowIndex);
                this.getPageCache().put("stopChange", "true");
                model.setValue("materialgroup", (Object)materialGroupId, rowIndex);
                this.getPageCache().put("stopChange", "false");
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u7269\u6599\u6ca1\u6709\u91c7\u8d2d\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PurTplEditPlugin_11", (String)"mpscmm-mspur", (Object[])new Object[0]));
                this.getPageCache().put("stopChange", "true");
                model.setValue("materialmasterid", oldValue, rowIndex);
                this.getPageCache().put("stopChange", "false");
            }
        }
    }

    private void changeMaterialGroup(Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        model.setValue("material", null, rowIndex);
        model.setValue("materialmasterid", null, rowIndex);
        if (newValue instanceof DynamicObject) {
            DynamicObject newValueObj = (DynamicObject)newValue;
            this.getPageCache().put("stopChange", "true");
            model.setValue("materialgroup", newValueObj.getPkValue(), rowIndex);
            model.setValue("materialname", newValueObj.get("name"), rowIndex);
            this.getPageCache().put("stopChange", "false");
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"materialname"});
        }
    }

    private void changeUnit(String fieldName, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
        DynamicObject materialGroup = (DynamicObject)model.getValue("materialgroup", rowIndex);
        if (materialGroup != null && material == null) {
            this.getPageCache().put("stopChange", "true");
            if (newValue instanceof DynamicObject) {
                model.setValue("baseunit", ((DynamicObject)newValue).getPkValue(), rowIndex);
            } else {
                model.setValue("baseunit", null, rowIndex);
            }
            this.getPageCache().put("stopChange", "false");
        }
        PurTplHelper.calBillQuantity(fieldName, model, rowIndex);
    }

    protected void changeQty(String fieldName, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
        DynamicObject materialGroup = (DynamicObject)model.getValue("materialgroup", rowIndex);
        if (materialGroup != null && material == null) {
            this.getPageCache().put("stopChange", "true");
            model.setValue("baseqty", newValue, rowIndex);
            this.getPageCache().put("stopChange", "false");
        }
        PurTplHelper.calBillQuantity(fieldName, model, rowIndex);
        this.changeBillAmount(rowIndex);
    }

    private void changeTaxRateID(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof DynamicObject) {
            DynamicObject taxRateID = (DynamicObject)newValue;
            model.setValue("taxrate", (Object)taxRateID.getBigDecimal("taxrate"), rowIndex);
        } else {
            model.setValue("taxrate", (Object)BigDecimalUtil.ZERO, rowIndex);
        }
    }

    private void changeDiscountType(String fieldName, Object oldValue, Object newValue, int rowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String discountType = (String)model.getValue("discounttype", rowIndex);
        BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
        boolean isRollbackField = false;
        if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountrate"});
            if (BigDecimalUtil.largeThan((BigDecimal)discountRate, (BigDecimal)BigDecimalUtil.HUNDRED) || BigDecimalUtil.lessThan((BigDecimal)discountRate, (BigDecimal)BigDecimalUtil.ZERO)) {
                isRollbackField = true;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u7387(%)\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u8303\u56f4\u4e3a\uff1a0\u2264\u5355\u4f4d\u6298\u6263(\u7387)\u2264100\u3002", (String)"PurTplEditPlugin_12", (String)"mpscmm-mspur", (Object[])new Object[0]));
            }
        } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType)) {
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountrate"});
            boolean isTax = (Boolean)model.getValue("istax");
            BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
            BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
            if (isTax && BigDecimalUtil.largeThan((BigDecimal)discountRate, (BigDecimal)priceAndTax)) {
                isRollbackField = true;
                if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PurTplEditPlugin_13", (String)"mpscmm-mspur", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PurTplEditPlugin_19", (String)"mpscmm-mspur", (Object[])new Object[0]));
                }
            } else if (!isTax && BigDecimalUtil.largeThan((BigDecimal)discountRate, (BigDecimal)price)) {
                isRollbackField = true;
                if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"PurTplEditPlugin_14", (String)"mpscmm-mspur", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"PurTplEditPlugin_20", (String)"mpscmm-mspur", (Object[])new Object[0]));
                }
            }
        } else if (DiscountTypeEnum.NULL.getValue().equals(discountType)) {
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"discountrate"});
            this.getPageCache().put("stopChange", "true");
            model.setValue("discountrate", (Object)BigDecimalUtil.ZERO, rowIndex);
            this.getPageCache().put("stopChange", "false");
        }
        if (isRollbackField) {
            this.getPageCache().put("stopChange", "true");
            model.setValue(fieldName, oldValue, rowIndex);
            this.getPageCache().put("stopChange", "false");
        }
    }

    private boolean changeDiscountAmountInfo(Object oldValue, int rowIndex) {
        String discountType = (String)this.getModel().getValue("discounttype", rowIndex);
        if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType)) {
            BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex);
            DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
            int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt("amtprecision");
            BigDecimal discountAmount = (BigDecimal)this.getModel().getValue("discountamount", rowIndex);
            discountAmount = discountAmount.setScale(settleAmtPrecision, 4);
            BigDecimal amountAndTax = BigDecimal.ZERO;
            boolean isTax = (Boolean)this.getModel().getValue("istax");
            if (isTax) {
                BigDecimal priceAndTax = (BigDecimal)this.getModel().getValue("priceandtax", rowIndex);
                if (qty != null && priceAndTax != null) {
                    amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, 4);
                }
            } else {
                BigDecimal price = (BigDecimal)this.getModel().getValue("price", rowIndex);
                if (qty != null && price != null) {
                    BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex);
                    if (taxRate == null) {
                        taxRate = BigDecimal.ZERO;
                    }
                    amountAndTax = qty.multiply(price).multiply(BigDecimal.ONE.add(taxRate.divide(new BigDecimal("100")))).setScale(settleAmtPrecision, 4);
                }
            }
            if (discountAmount.compareTo(amountAndTax) > 0) {
                this.getPageCache().put("stopChange", "true");
                this.getModel().setValue("discountamount", oldValue, rowIndex);
                this.getPageCache().put("stopChange", "false");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u989d\u201d\u65f6\uff0c\u6298\u6263\u989d\u4e0d\u80fd\u5927\u4e8e\u201c\u6570\u91cf\u201d\u4e58\u4ee5\u201c\u542b\u7a0e\u5355\u4ef7\u201d\u3002", (String)"PurTplEditPlugin_18", (String)"mpscmm-mspur", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        return false;
    }

    private void changeEntryReqOrg(int rowIndex) {
        DynamicObject org;
        IDataModel model = this.getModel();
        String ownerType = (String)model.getValue("ownertype", rowIndex);
        if (OwnerTypeEnum.OWNERTYPE_ORG.getValue().equals(ownerType) && (org = (DynamicObject)model.getValue("org")) != null) {
            Long orgOwner = PurTplHelper.getOrgOwner(this.getModel(), this.getView(), rowIndex);
            model.setValue("owner", (Object)orgOwner, rowIndex);
        }
    }

    private void changeEntryRecOrg(int rowIndex) {
        DynamicObject org;
        IDataModel model = this.getModel();
        model.setValue("warehouse", null, rowIndex);
        String ownerType = (String)model.getValue("ownertype", rowIndex);
        if (OwnerTypeEnum.OWNERTYPE_ORG.getValue().equals(ownerType) && (org = (DynamicObject)model.getValue("org")) != null) {
            Long orgOwner = PurTplHelper.getOrgOwner(this.getModel(), this.getView(), rowIndex);
            model.setValue("owner", (Object)orgOwner, rowIndex);
        }
    }

    private void changeEntrySettleOrg(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof DynamicObject) {
            DynamicObject entrySettleOrg = (DynamicObject)newValue;
            Long entrySettleOrgId = (Long)entrySettleOrg.getPkValue();
            String payOrgValue = this.getPageCache().get(entrySettleOrgId + "entrypayorg");
            if (StringUtils.isNotBlank((Object)payOrgValue)) {
                model.setValue("entrypayorg", (Object)payOrgValue, rowIndex);
            } else {
                Long entryPayOrg = OrgHelper.getToOrg((String)"10", (String)"08", (Long)entrySettleOrgId, (boolean)true);
                if (entryPayOrg != null) {
                    model.setValue("entrypayorg", (Object)entryPayOrg, rowIndex);
                    this.getPageCache().put(entrySettleOrgId + "entrypayorg", entryPayOrg.toString());
                }
            }
        } else {
            model.setValue("entrypayorg", null, rowIndex);
        }
    }

    private void changeIsPresent(Object newValue, int rowIndex) {
        boolean isPresent;
        if (newValue instanceof Boolean && (isPresent = ((Boolean)newValue).booleanValue())) {
            IDataModel model = this.getModel();
            BigDecimal oldTotalAmount = BigDecimalUtil.getNotNull((Object)model.getValue("totalamount"));
            BigDecimal oldTotalTaxAmount = BigDecimalUtil.getNotNull((Object)model.getValue("totaltaxamount"));
            BigDecimal oldTotalAmountAndTax = BigDecimalUtil.getNotNull((Object)model.getValue("totalallamount"));
            BigDecimal amount = BigDecimalUtil.getNotNull((Object)model.getValue("amount", rowIndex));
            BigDecimal taxAmount = BigDecimalUtil.getNotNull((Object)model.getValue("taxamount", rowIndex));
            BigDecimal amountAndTax = BigDecimalUtil.getNotNull((Object)model.getValue("amountandtax", rowIndex));
            this.getPageCache().put("stopChange", "true");
            model.setValue("taxrate", (Object)BigDecimalUtil.ZERO, rowIndex);
            model.setValue("taxrateid", null, rowIndex);
            model.setValue("discountrate", (Object)BigDecimalUtil.ZERO, rowIndex);
            model.setValue("price", (Object)BigDecimalUtil.ZERO, rowIndex);
            model.setValue("priceandtax", (Object)BigDecimalUtil.ZERO, rowIndex);
            model.setValue("amount", (Object)BigDecimalUtil.ZERO, rowIndex);
            model.setValue("taxamount", (Object)BigDecimalUtil.ZERO, rowIndex);
            model.setValue("discountamount", (Object)BigDecimalUtil.ZERO, rowIndex);
            model.setValue("amountandtax", (Object)BigDecimalUtil.ZERO, rowIndex);
            model.setValue("curamount", (Object)BigDecimalUtil.ZERO, rowIndex);
            model.setValue("curtaxamount", (Object)BigDecimalUtil.ZERO, rowIndex);
            model.setValue("curamountandtax", (Object)BigDecimalUtil.ZERO, rowIndex);
            model.setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
            model.setValue("totalamount", (Object)oldTotalAmount.subtract(amount));
            model.setValue("totaltaxamount", (Object)oldTotalTaxAmount.subtract(taxAmount));
            model.setValue("totalallamount", (Object)oldTotalAmountAndTax.subtract(amountAndTax));
            this.getPageCache().put("stopChange", "false");
        }
    }

    private void changeInputAmount() {
        PurTplHelper.setEnableByInputAmount(this.getView());
    }

    private void changeSettleCurrency(Object newValue) {
        PurTplHelper.calBillAllAmount(this.getView(), this.getModel().getDataEntity(true));
        this.setDiscountRateScale(newValue);
    }

    protected void changeBillAmount(int rowIndex) {
        this.changeBillAmount(rowIndex, Boolean.FALSE);
    }

    protected void changeBillAmount(int rowIndex, Boolean isCalDiscountRate) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        PurTplHelper.calBillAmount(model, view, rowIndex, true, isCalDiscountRate);
        PurTplHelper.updateBillAmount(view, rowIndex);
    }

    protected boolean isImport() {
        return false;
    }

    private void changeBillAmount() {
        IFormView view = this.getView();
        DynamicObject bill = this.getModel().getDataEntity(true);
        Boolean isTax = (Boolean)bill.get("istax");
        BigDecimal exChangeRate = bill.getBigDecimal("exchangerate");
        boolean isIndirectRate = ExchangeTypeEnum.isIndirectRate((Object)bill.getString("exchangetype"));
        DynamicObject currency = bill.getDynamicObject("currency");
        int currencyAmtPrecision = currency == null ? 10 : currency.getInt("amtprecision");
        int i = 0;
        for (DynamicObject entry : bill.getDynamicObjectCollection("billentry")) {
            BigDecimal amountAndTax = entry.getBigDecimal("amountandtax");
            BigDecimal taxAmount = entry.getBigDecimal("taxamount");
            BigDecimal amount = entry.getBigDecimal("amount");
            BigDecimal curAmount = BigDecimalUtil.ZERO;
            BigDecimal curAmountAndTax = BigDecimalUtil.ZERO;
            BigDecimal curTaxAmount = BigDecimal.ZERO;
            if (BigDecimalUtil.isZero((BigDecimal)exChangeRate)) continue;
            curTaxAmount = CurrencyHelper.convert((BigDecimal)taxAmount, (BigDecimal)exChangeRate, (boolean)isIndirectRate, (int)currencyAmtPrecision, (RoundingMode)RoundingMode.HALF_UP);
            if (isTax.booleanValue()) {
                curAmountAndTax = CurrencyHelper.convert((BigDecimal)amountAndTax, (BigDecimal)exChangeRate, (boolean)isIndirectRate, (int)currencyAmtPrecision, (RoundingMode)RoundingMode.HALF_UP);
                curAmount = curAmountAndTax.subtract(curTaxAmount);
            } else {
                curAmount = CurrencyHelper.convert((BigDecimal)amount, (BigDecimal)exChangeRate, (boolean)isIndirectRate, (int)currencyAmtPrecision, (RoundingMode)RoundingMode.HALF_UP);
                curAmountAndTax = curAmount.add(curTaxAmount);
            }
            entry.set("curamountandtax", (Object)curAmountAndTax);
            entry.set("curtaxamount", (Object)curTaxAmount);
            entry.set("curamount", (Object)curAmount);
            view.updateView("curamount", i);
            view.updateView("curtaxamount", i);
            view.updateView("curamountandtax", i);
            ++i;
        }
    }

    private void updateHeadAmount() {
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity(true);
        BigDecimal totalAmount = BigDecimalUtil.ZERO;
        BigDecimal totalTaxAmount = BigDecimalUtil.ZERO;
        BigDecimal totalAllAmount = BigDecimalUtil.ZERO;
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        if (entry != null) {
            for (DynamicObject row : entry) {
                if (ChangeTypeEnum.isCancel((String)row.getString("entrychangetype"))) continue;
                totalAmount = totalAmount.add(BigDecimalUtil.getNotNull((Object)row.getBigDecimal("amount")));
                totalTaxAmount = totalTaxAmount.add(BigDecimalUtil.getNotNull((Object)row.getBigDecimal("taxamount")));
                totalAllAmount = totalAllAmount.add(BigDecimalUtil.getNotNull((Object)row.getBigDecimal("amountandtax")));
            }
        }
        model.setValue("totalamount", (Object)totalAmount);
        model.setValue("totaltaxamount", (Object)totalTaxAmount);
        model.setValue("totalallamount", (Object)totalAllAmount);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map orgMap;
        DynamicObject org;
        String entity = this.getModel().getDataEntityType().getName();
        Object billCreType = e.getSourceData().get("billcretype");
        if (billCreType == null || BillCreTypeEnum.getName((String)((String)billCreType)) == null) {
            String billCreTypeValue = BillCreTypeUtils.getBillCreType((Object)e.getSourceData());
            this.getModel().setValue("billcretype", (Object)billCreTypeValue);
        } else {
            this.getModel().setValue("billcretype", billCreType);
        }
        List hasPermissionOrg = (List)AppCacheUtils.get((String)("hasPermissionOrg_" + this.userId), List.class);
        if (hasPermissionOrg == null) {
            hasPermissionOrg = OrgHelper.getHasPermissionOrgs((String)entity, (String)"02", (Long)this.userId);
            AppCacheUtils.put((String)("hasPermissionOrg_" + this.userId), (Object)hasPermissionOrg);
        }
        if ((org = BillCreTypeUtils.getBaseData((Map)(orgMap = BillCreTypeUtils.format4ImportAndApi(e.getSourceData().get("org"))), (String)"bos_org", null, null)) == null) {
            return;
        }
        Long orgID = (Long)org.getPkValue();
        if (hasPermissionOrg == null || !hasPermissionOrg.contains(orgID)) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"PurTplEditPlugin_15", (String)"mpscmm-mspur", (Object[])new Object[0]), orgMap.get(orgMap.get("importprop"))));
            e.setFireAfterImportData(false);
        }
        Map operatorGroupMap = BillCreTypeUtils.format4ImportAndApi(e.getSourceData().get("operatorgroup"));
        Map operatorMap = BillCreTypeUtils.format4ImportAndApi(e.getSourceData().get("operator"));
        QFilter operatorgroupOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgID);
        QFilter operatorgroupTypeFilter = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.PURCHASEGRP.getValue());
        if (operatorGroupMap != null && operatorGroupMap.get(operatorGroupMap.get("importprop")) != null) {
            DynamicObject operatorGroup = BillCreTypeUtils.getBaseData((Map)operatorGroupMap, (String)"bd_operatorgroup", (String)"id,number,name,operatornumber,operatorname", (QFilter[])new QFilter[]{operatorgroupOrgFilter, operatorgroupTypeFilter});
            if (operatorGroup == null) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u201c%1$s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"PurTplEditPlugin_16", (String)"mpscmm-mspur", (Object[])new Object[0]), operatorGroupMap.get(operatorGroupMap.get("importprop"))));
            } else if (operatorMap != null && operatorMap.get(operatorMap.get("importprop")) != null) {
                DynamicObjectCollection entryentity = operatorGroup.getDynamicObjectCollection("entryentity");
                boolean flag = true;
                for (DynamicObject operator : entryentity) {
                    if (!operatorMap.get(operatorMap.get("importprop")).equals(operator.getString((String)operatorMap.get("importprop")))) continue;
                    HashMap<String, Object> newOperator = new HashMap<String, Object>();
                    newOperator.put("id", operator.getPkValue());
                    e.getSourceData().put("operator", newOperator);
                    flag = false;
                    break;
                }
                if (flag) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5458\u201c%1$s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"PurTplEditPlugin_17", (String)"mpscmm-mspur", (Object[])new Object[0]), operatorMap.get(operatorMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                }
            }
        } else if (operatorMap != null && operatorMap.get(operatorMap.get("importprop")) != null) {
            Map operators = BillCreTypeUtils.getBaseDatas((Map)operatorMap, (String)"bd_operator", (String)"id,operatornumber,operatorname,operatorid,operatorgrpid", (QFilter[])new QFilter[]{new QFilter("operatorgrpid", "in", (Object)OperatorGroupHelper.getAllOperatorGroupByOrg((Long)orgID, (String)OperatorGrpTypeEnum.PURCHASEGRP.getValue()))});
            boolean flag = true;
            for (DynamicObject operator : operators.values()) {
                if (!operatorMap.get(operatorMap.get("importprop")).equals(operator.getString((String)operatorMap.get("importprop")))) continue;
                HashMap<String, Object> newOperator = new HashMap<String, Object>();
                newOperator.put("id", operator.getPkValue());
                e.getSourceData().put("operator", newOperator);
                HashMap<String, Long> newOperatorGroup = new HashMap<String, Long>();
                newOperatorGroup.put("id", operator.getLong("operatorgrpid"));
                e.getSourceData().put("operatorgroup", newOperatorGroup);
                flag = false;
                break;
            }
            if (flag) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5458\u201c%1$s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"PurTplEditPlugin_17", (String)"mpscmm-mspur", (Object[])new Object[0]), operatorMap.get(operatorMap.get("importprop"))));
                e.setFireAfterImportData(false);
            }
        }
    }

    private void setDiscountRateScale(Object newValue) {
        int priceRecision = 4;
        if (newValue instanceof DynamicObject) {
            DynamicObject settleCurrency = (DynamicObject)newValue;
            priceRecision = settleCurrency.getInt("priceprecision");
        }
        ClientViewProxy clientViewProxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod("billentry", "setColEditorProp", new Object[]{"discountrate", "sc", priceRecision});
    }
}

