/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mspur.opplugin;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.mpscmm.mspur.business.PoTplHelper;
import kd.mpscmm.mspur.business.SupplierHelper;

public class PoTplOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("isvirtualbill");
        keys.add("providersupplier");
        keys.add("invoicesupplier");
        keys.add("receivesupplier");
        keys.add("providerlinkman");
        keys.add("provideraddressf7");
        keys.add("provideraddress");
        keys.add("invoicebiztype");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] bills = e.getDataEntities();
        if ("submit".equals(operationKey)) {
            this.addDefaultSuppliers(bills);
        }
    }

    private void addDefaultSuppliers(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            DynamicObject providerSupplier;
            String appId;
            DynamicObject invoiceType;
            DynamicObject supplier = bill.getDynamicObject("supplier");
            if (supplier == null) {
                return;
            }
            if (bill.get("invoicebiztype") == null && (invoiceType = PoTplHelper.getInvoiceType(supplier, appId = this.billEntityType.getAppId())) != null) {
                bill.set("invoicebiztype", (Object)invoiceType);
            }
            if ((providerSupplier = bill.getDynamicObject("providersupplier")) == null) {
                SupplierHelper.nullToDefault(bill, supplier, "providersupplier");
                Map<String, Object> defaultValues = PoTplHelper.getDefaultByProviderSupplier(supplier);
                for (Map.Entry<String, Object> entry : defaultValues.entrySet()) {
                    bill.set(entry.getKey(), entry.getValue());
                }
            }
            SupplierHelper.nullToDefault(bill, supplier, "invoicesupplier", "receivesupplier");
        }
    }
}

