/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mspur.opplugin;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.common.enums.BillCreTypeEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.mspur.business.PurTplHelper;

public class PurTplOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List keys = e.getFieldKeys();
        keys.add("org");
        keys.add("dept");
        keys.add("operatorgroup");
        keys.add("operator");
        keys.add("supplier");
        keys.add("biztime");
        keys.add("billtype");
        keys.add("biztype");
        keys.add("biztime");
        keys.add("currency");
        keys.add("exratetable");
        keys.add("exratedate");
        keys.add("settlecurrency");
        keys.add("exchangerate");
        keys.add("exchangetype");
        keys.add("lastupdateuser");
        keys.add("lastupdatetime");
        keys.add("linetype");
        keys.add("materialgroup");
        keys.add("materialmasterid");
        keys.add("material");
        keys.add("materialname");
        keys.add("auxunit");
        keys.add("baseunit");
        keys.add("unit");
        keys.add("qty");
        keys.add("baseqty");
        keys.add("discountrate");
        keys.add("taxrate");
        keys.add("ispresent");
        keys.add("istax");
        keys.add("priceandtax");
        keys.add("price");
        keys.add("amount");
        keys.add("curamount");
        keys.add("taxamount");
        keys.add("curtaxamount");
        keys.add("amountandtax");
        keys.add("curamountandtax");
        keys.add("totalamount");
        keys.add("totaltaxamount");
        keys.add("totalallamount");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operateKey = e.getOperationKey();
        DynamicObject[] bills = e.getDataEntities();
        if ("save".equals(operateKey)) {
            for (DynamicObject bill : bills) {
                String billCreType = bill.getString("billcretype");
                if (billCreType == null || CommonUtils.isNull((Object)billCreType) || BillCreTypeEnum.ADDNEW.getValue().equals(billCreType)) continue;
                PurTplHelper.completeBillInfo(bill);
            }
        }
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            Long userId = RequestContext.get().getCurrUserId();
            DynamicObject bosUser = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
            for (DynamicObject bill : bills) {
                bill.set("lastupdateuser", (Object)bosUser);
                bill.set("lastupdatetime", (Object)new Date(System.currentTimeMillis()));
                DynamicObject billType = bill.getDynamicObject("billtype");
                DynamicObject bizType = bill.getDynamicObject("biztype");
                if (billType == null || bizType != null) continue;
                bizType = BizTypeHelper.getDefaultBizTypeObject((String)bill.getDataEntityType().getName(), (Long)((Long)billType.getPkValue()), (String)"pm_billtypeparameter");
                DynamicObject lineType = BizTypeHelper.getDefaultLineTypeObject((Long)((Long)bizType.getPkValue()));
                bill.set("biztype", (Object)bizType);
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
                if (entrys == null) continue;
                entrys.forEach(dym -> {
                    if (dym.getDynamicObject("linetype") == null) {
                        dym.set("linetype", (Object)lineType);
                    }
                });
            }
        }
    }
}

