/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mspur.validator;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class AmountDirectionValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("qty");
        preparePropertys.add("taxamount");
        preparePropertys.add("discountamount");
        preparePropertys.add("amount");
        preparePropertys.add("amountandtax");
        return preparePropertys;
    }

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (entrys == null || entrys.size() <= 0) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                BigDecimal qty = entry.getBigDecimal("qty");
                BigDecimal taxAmount = entry.getBigDecimal("taxamount");
                BigDecimal discountAmount = entry.getBigDecimal("discountamount");
                BigDecimal amount = entry.getBigDecimal("amount");
                BigDecimal amountAndTax = entry.getBigDecimal("amountandtax");
                if (qty == null || taxAmount == null || discountAmount == null || amount == null || amountAndTax == null || qty.compareTo(BigDecimal.ZERO) >= 0 && taxAmount.compareTo(BigDecimal.ZERO) >= 0 && discountAmount.compareTo(BigDecimal.ZERO) >= 0 && amount.compareTo(BigDecimal.ZERO) >= 0 && amountAndTax.compareTo(BigDecimal.ZERO) >= 0 || qty.compareTo(BigDecimal.ZERO) <= 0 && taxAmount.compareTo(BigDecimal.ZERO) <= 0 && discountAmount.compareTo(BigDecimal.ZERO) <= 0 && amount.compareTo(BigDecimal.ZERO) <= 0 && amountAndTax.compareTo(BigDecimal.ZERO) <= 0) continue;
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u7b2c%1$s\u884c\uff0c\u6570\u91cf\u3001\u91d1\u989d\u3001\u7a0e\u989d\u3001\u6298\u6263\u989d\u3001\u4ef7\u7a0e\u5408\u8ba1\u7684\u65b9\u5411\u9700\u4e00\u81f4\u3002", (String)"AmountDirectionValidator_0", (String)"mpscmm-mspur", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
            }
        }
    }
}

