/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mspur.validator;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.common.enums.DiscountTypeEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class DiscountTypeValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("istax");
        preparePropertys.add("discountrate");
        preparePropertys.add("discounttype");
        preparePropertys.add("priceandtax");
        preparePropertys.add("price");
        return preparePropertys;
    }

    public void validate() {
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject entity = extend.getDataEntity();
            Boolean istax = (Boolean)entity.get("istax");
            DynamicObjectCollection entry = entity.getDynamicObjectCollection("billentry");
            if (entry.size() <= 0) continue;
            int i = 0;
            for (DynamicObject row : entry) {
                BigDecimal price;
                String tip;
                ++i;
                BigDecimal disCountRate = row.getBigDecimal("discountrate");
                String disCountType = row.getString("discounttype");
                if (disCountType == null) continue;
                if (istax.booleanValue()) {
                    BigDecimal priceAndTax;
                    if (!row.getString("discounttype").equals(DiscountTypeEnum.UNITDIS.getValue()) || disCountRate.compareTo(priceAndTax = row.getBigDecimal("priceandtax")) <= 0) continue;
                    tip = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u201c\u5355\u4f4d\u6298\u6263\uff08\u7387\uff09\u201d\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"DiscountTypeValidator_0", (String)"mpscmm-mspur", (Object[])new Object[0]), i);
                    this.addMessage(extend, tip, ErrorLevel.Error);
                    continue;
                }
                if (!row.getString("discounttype").equals(DiscountTypeEnum.UNITDIS.getValue()) || disCountRate.compareTo(price = row.getBigDecimal("price")) <= 0) continue;
                tip = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u201c\u5355\u4f4d\u6298\u6263\uff08\u7387\uff09\u201d\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"DiscountTypeValidator_1", (String)"mpscmm-mspur", (Object[])new Object[0]), i);
                this.addMessage(extend, tip, ErrorLevel.Error);
            }
        }
    }
}

