/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mspur.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.mpscmm.msbd.business.helper.SysParamHelper;
import kd.mpscmm.msbd.common.enums.ChangeTypeEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;

public class PoAmountPlanValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> keys = new HashSet<String>(16);
        keys.add("org");
        keys.add("totalallamount");
        keys.add("payamount");
        keys.add("payentrychangetype");
        return keys;
    }

    public void validate() {
        String appNumber = this.getValidateContext().getBillEntityType().getAppId();
        if (appNumber == null) {
            return;
        }
        Map parameterMap = SysParamHelper.batchGetSysParam((String)AppMetadataCache.getAppInfo((String)appNumber).getId(), (String)"02", new ArrayList<Long>(this.getOrgIds()), (String)"famountplancheck");
        if (parameterMap.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            if (!this.isValid(parameterMap, bill) || !this.isTotalPayAmountError(bill)) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7684\u4ed8\u6b3e\u91d1\u989d\u5408\u8ba1\u4e0e\u5355\u636e\u7684\u603b\u4ef7\u7a0e\u5408\u8ba1\u4e00\u81f4\u624d\u80fd\u901a\u8fc7\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"PoAmountPlanValidator_0", (String)"mpscmm-mspur", (Object[])new Object[0]));
        }
    }

    private boolean isValid(Map<String, Object> parameterMap, DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        if (org == null) {
            return false;
        }
        Object isValid = parameterMap.get(org.getPkValue().toString());
        if (isValid instanceof Boolean) {
            return (Boolean)isValid;
        }
        return false;
    }

    private boolean isTotalPayAmountError(DynamicObject bill) {
        DynamicObjectCollection payEntry = bill.getDynamicObjectCollection("billentry_pay");
        if (payEntry == null || payEntry.isEmpty()) {
            return false;
        }
        BigDecimal totalAllAmount = BigDecimalUtil.getNotNull((Object)bill.getBigDecimal("totalallamount"));
        BigDecimal payAmountSum = BigDecimalUtil.ZERO;
        boolean isAllCancel = true;
        for (DynamicObject row : payEntry) {
            if (ChangeTypeEnum.isCancel((String)row.getString("payentrychangetype"))) continue;
            isAllCancel = false;
            payAmountSum = payAmountSum.add(BigDecimalUtil.getNotNull((Object)row.getBigDecimal("payamount")));
        }
        if (isAllCancel) {
            return false;
        }
        return BigDecimalUtil.notEquals((BigDecimal)totalAllAmount, (BigDecimal)payAmountSum);
    }

    private Set<Long> getOrgIds() {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject org = data.getDataEntity().getDynamicObject("org");
            if (org == null) continue;
            orgIds.add((Long)org.getPkValue());
        }
        return orgIds;
    }
}

