/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mspur.validator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class PurOrderBillExpenseItemValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("linetype");
        preparePropertys.add("expenseitem");
        return preparePropertys;
    }

    public void validate() {
        List<Long> lineTypeids = this.getExpenseItemLineTypeIds();
        BusinessDataServiceHelper.loadFromCache((String)"bd_linetype", (QFilter[])new QFilter[0]);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (entrys == null || entrys.size() <= 0) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                DynamicObject lineType = (DynamicObject)entry.get("linetype");
                if (lineType == null) continue;
                Long lineTypePkValue = (Long)lineType.getPkValue();
                DynamicObject expenseitem = entry.getDynamicObject("expenseitem");
                if (!lineTypeids.contains(lineTypePkValue) || expenseitem != null) continue;
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u660e\u7ec6\u4e3a\u8d39\u7528\u7269\u6599\uff0c\u8bf7\u5f55\u5165\u8d39\u7528\u9879\u76ee\u3002", (String)"PurOrderBillExpenseItemValidator_0", (String)"mpscmm-mspur", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
            }
        }
    }

    public List<Long> getExpenseItemLineTypeIds() {
        ArrayList<Long> lineTypeIds = new ArrayList<Long>();
        QFilter expenseItemQfilter = new QFilter("serviceattribute.entity.number", "=", (Object)"er_expenseitemedit");
        Map linetypeFromDB = BusinessDataServiceHelper.loadFromCache((String)"bd_linetype", (QFilter[])new QFilter[]{expenseItemQfilter});
        if (linetypeFromDB != null) {
            linetypeFromDB.keySet().forEach(id -> lineTypeIds.add((Long)id));
        }
        return lineTypeIds;
    }
}

