/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mspur.validator;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.common.enums.EnableStatusEnum;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class SouceControlValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("org");
        preparePropertys.add("supplier");
        preparePropertys.add("biztime");
        preparePropertys.add("material");
        return preparePropertys;
    }

    public void validate() {
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            DynamicObject supplier = bill.getDynamicObject("supplier");
            Date bizTime = bill.getDate("biztime");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (org == null || supplier == null || bizTime == null || entrys == null || entrys.isEmpty()) continue;
            Long orgId = (Long)org.getPkValue();
            Long supplierId = (Long)supplier.getPkValue();
            ArrayList<Long> materialIds = new ArrayList<Long>(entrys.size());
            ArrayList<Long> materialGroupIds = new ArrayList<Long>(entrys.size());
            for (DynamicObject entry : entrys) {
                DynamicObject group;
                DynamicObject material = entry.getDynamicObject("material");
                if (material == null || !material.getBoolean("isapprovedsupplier")) continue;
                materialIds.add((Long)material.getPkValue());
                DynamicObject master = material.getDynamicObject("masterid");
                if (master == null || (group = master.getDynamicObject("group")) == null) continue;
                materialGroupIds.add((Long)group.getPkValue());
            }
            if (materialIds.isEmpty()) continue;
            QFilter q1 = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
            QFilter q2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
            QFilter q3 = new QFilter("org", "=", (Object)orgId);
            QFilter q4 = new QFilter("supplier", "=", (Object)supplierId);
            QFilter q5 = new QFilter("entryentity.effectdate", "<=", (Object)bizTime);
            QFilter q6 = new QFilter("entryentity.expirydate", ">=", (Object)bizTime);
            QFilter q7 = null;
            QFilter q71 = new QFilter("entryentity.type", "=", (Object)"A");
            QFilter q72 = new QFilter("entryentity.material", "in", materialIds);
            if (materialGroupIds.isEmpty()) {
                q7 = q71.and(q72);
            } else {
                QFilter q73 = new QFilter("entryentity.type", "=", (Object)"B");
                QFilter q74 = new QFilter("entryentity.materialsort", "in", materialGroupIds);
                q7 = q71.and(q72).or(q73.and(q74));
            }
            DynamicObjectCollection query = QueryServiceHelper.query((String)"pm_sourcelist", (String)"id,org,supplier,status,enable,entryentity.type type,entryentity.material material,entryentity.materialsort materialsort,entryentity.effectdate,entryentity.expirydate", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6, q7});
            ArrayList<Long> materials = null;
            ArrayList<Long> materialsorts = null;
            if (query != null && !query.isEmpty()) {
                int size = query.size();
                materials = new ArrayList<Long>(size);
                materialsorts = new ArrayList<Long>(size);
                for (DynamicObject dyn : query) {
                    Long id;
                    String type = dyn.getString("type");
                    if ("A".equals(type)) {
                        id = dyn.getLong("material");
                        if (id == null) continue;
                        materials.add(id);
                        continue;
                    }
                    if (!"B".equals(type) || (id = Long.valueOf(dyn.getLong("materialsort"))) == null) continue;
                    materialsorts.add(id);
                }
            }
            for (int j = 0; j < entrys.size(); ++j) {
                DynamicObject group;
                DynamicObject entry = (DynamicObject)entrys.get(j);
                DynamicObject material = entry.getDynamicObject("material");
                if (material == null || !material.getBoolean("isapprovedsupplier")) continue;
                Object pkValue = material.getPkValue();
                if (materials != null && materials.contains(pkValue)) continue;
                DynamicObject master = material.getDynamicObject("masterid");
                if (master != null && (group = master.getDynamicObject("group")) != null) {
                    Object pkValue2 = group.getPkValue();
                    if (materialsorts != null && materialsorts.contains(pkValue2)) continue;
                }
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u660e\u7ec6\u4e0d\u6ee1\u8db3\u8d27\u6e90\u63a7\u5236\u3002", (String)"SouceControlValidator_0", (String)"mpscmm-mspur", (Object[])new Object[0]), j + 1), ErrorLevel.Error);
            }
        }
    }
}

