/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mspur.validator;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.mspur.business.SupplierHelper;

public class SupplierPurchaseHoldValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> prepareProperties = super.preparePropertys();
        if (CommonUtils.isNull((Object)prepareProperties)) {
            prepareProperties = new HashSet<String>(16);
        }
        prepareProperties.add("supplier");
        return prepareProperties;
    }

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObject supplier = bill.getDynamicObject("supplier");
            if (!SupplierHelper.isPurchaseHold(supplier)) continue;
            String billNo = bill.getString("billno");
            String supplierName = supplier.getString("number");
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u201c%1$s\u201d\uff0c\u8ba2\u8d27\u4f9b\u5e94\u5546\u201c%2$s\u201d\u4e3a\u201c\u91c7\u8d2d\u51bb\u7ed3\u201d\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"SupplierPurchaseHoldValidator_0", (String)"mpscmm-mspur", (Object[])new Object[0]), billNo, supplierName));
        }
    }
}

