/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mspur.validator;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.mspur.business.BizCategoryHelper;

public class SupplierValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("org");
        preparePropertys.add("biztype");
        preparePropertys.add("supplier");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            QFilter supplierIdFilter;
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            DynamicObject supplier = bill.getDynamicObject("supplier");
            if (supplier == null) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SupplierValidator_0", (String)"mpscmm-mspur", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            QFilter supplierOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)((Long)org.getPkValue()));
            DynamicObject[] suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,enablevmi", (QFilter[])new QFilter[]{supplierOrgFilter, supplierIdFilter = new QFilter("id", "=", (Object)((Long)supplier.getPkValue()))});
            if (suppliers == null || suppliers.length == 0) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u4e0d\u5728\u8be5\u91c7\u8d2d\u7ec4\u7ec7\u7684\u4f7f\u7528\u8303\u56f4\u3002", (String)"SupplierValidator_1", (String)"mpscmm-mspur", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            DynamicObject bizType = bill.getDynamicObject("biztype");
            if (bizType == null || !BizCategoryHelper.isVMI((Long)bizType.getPkValue()) || supplier.getBoolean("enablevmi")) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u4e0d\u662f\u53efVMI\u7684\u4f9b\u5e94\u5546\u3002", (String)"SupplierValidator_2", (String)"mpscmm-mspur", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }
}

