/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.business.logger;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class RebateLoggerService {
    public static final DynamicObject createNewTask(String taskNo, String optype, String desc) {
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"msrcs_task"));
        dynamicObject.set("taskno", (Object)taskNo);
        dynamicObject.set("starttime", (Object)TimeServiceHelper.now());
        dynamicObject.set("status", (Object)"A");
        dynamicObject.set("creatorid", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("optype", (Object)optype);
        dynamicObject.set("detail", (Object)desc);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return dynamicObject;
    }

    public static final DynamicObject createNewSubTask(String mainTaskNo, String taskNo, long sourceId, String sourceNo) {
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"msrcs_subtask"));
        dynamicObject.set("taskno", (Object)taskNo);
        dynamicObject.set("maintaskno", (Object)mainTaskNo);
        dynamicObject.set("starttime", (Object)TimeServiceHelper.now());
        dynamicObject.set("status", (Object)"A");
        dynamicObject.set("creatorid", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("sourceid", (Object)sourceId);
        dynamicObject.set("sourcebillno", (Object)(sourceNo == null || sourceNo.equalsIgnoreCase("") ? " " : sourceNo));
        return dynamicObject;
    }

    public static final void logSubTask(String taskNo, String status, String msg) {
        QFilter filter = new QFilter("taskno", "=", (Object)taskNo);
        DynamicObject subtask = BusinessDataServiceHelper.loadSingleFromCache((String)"msrcs_subtask", (QFilter[])filter.toArray());
        if (StringUtil.isNotEmpty((String)status)) {
            subtask.set("status", (Object)status);
        }
        if (StringUtil.isNotEmpty((String)msg)) {
            String now = TimeServiceHelper.formatUserNow();
            subtask.set("detail", (Object)(subtask.getString("detail") + "\n " + now + msg));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{subtask});
    }
}

