/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.business.policyparserule;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msrcs.business.policyparserule.AbstractConditionMatch;

public class MaterialClassConditionMatch
extends AbstractConditionMatch {
    @Override
    public QFilter buildEntryFilter(String modelCol, Object sourceColValue, boolean isCheckBaseDataCtrl) {
        String materialKey = "material";
        if (isCheckBaseDataCtrl) {
            materialKey = "material.masterid";
        }
        HashSet<Long> materialClassIds = null;
        if (sourceColValue instanceof Collection) {
            materialClassIds = (HashSet<Long>)sourceColValue;
        } else {
            materialClassIds = new HashSet<Long>(1);
            materialClassIds.add(Long.parseLong(String.valueOf(sourceColValue)));
        }
        Set<Long> materialAllClassIds = this.queryMaterialClass(materialClassIds);
        Set<Long> materialIds = this.queryMaterialByClass(materialAllClassIds, materialKey);
        if (materialIds != null) {
            materialIds.remove(0L);
        }
        QFilter qFilter = new QFilter(modelCol, "in", materialIds);
        return qFilter;
    }

    private Set<Long> queryMaterialByClass(Set<Long> materialClassIds, String materialKey) {
        QFilter filter = new QFilter("group", "in", materialClassIds);
        DynamicObjectCollection materialGroupDetails = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)materialKey, (QFilter[])filter.toArray());
        if (!CollectionUtils.isEmpty((Collection)materialGroupDetails)) {
            return materialGroupDetails.stream().map(x -> x.getLong(materialKey)).collect(Collectors.toSet());
        }
        return new HashSet<Long>(0);
    }

    private Set<Long> queryMaterialClass(Set<Long> materialClassParentIds) {
        HashSet<Long> materialClassIds = new HashSet<Long>(0);
        materialClassIds.addAll(materialClassParentIds);
        materialClassIds.addAll(this.queryMaterialSubClass(materialClassParentIds));
        return materialClassIds;
    }

    private Set<Long> queryMaterialSubClass(Set<Long> materialClassParentIds) {
        QFilter filter = new QFilter("parent", "in", materialClassParentIds);
        DynamicObjectCollection classids = QueryServiceHelper.query((String)"bd_materialgroup", (String)"id", (QFilter[])filter.toArray());
        if (!CollectionUtils.isEmpty((Collection)classids)) {
            return classids.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        }
        return new HashSet<Long>(0);
    }
}

