/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.business.policyparserule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msrcs.business.policyparserule.AbstractConditionMatch;
import kd.mpscmm.msrcs.common.util.DynamicObjectUtils;
import kd.mpscmm.msrcs.common.util.FilterConditionUtil;
import kd.mpscmm.msrcs.common.util.QueryUtil;

public class PolicyParseRuleHelper {
    public static final String REBATETARGETOBJECT = "occpic_rebatetarget";
    public static final String CONDITIONGROUPOBJECT = "ocdbd_conditongroup";
    private static Log logger = LogFactory.getLog(PolicyParseRuleHelper.class);

    public static QFilter buildConditionMatchHeaderFilter(DynamicObject parseRuleDo, DynamicObject targetDo) {
        if (parseRuleDo == null || targetDo == null) {
            return null;
        }
        return PolicyParseRuleHelper.buildHeaderFilter(targetDo, parseRuleDo, "A");
    }

    public static QFilter buildConditionMatchItemRangeEntryFilter(DynamicObject parseRuleDo, DynamicObject targetDo) {
        if (parseRuleDo == null || targetDo == null) {
            return null;
        }
        DynamicObjectCollection itemClassEntity = targetDo.getDynamicObjectCollection("itemclassentity");
        if (CollectionUtils.isEmpty((Collection)itemClassEntity)) {
            return null;
        }
        return PolicyParseRuleHelper.buildItemRangeEntryFilter(itemClassEntity, parseRuleDo, "B");
    }

    public static QFilter buildConditionMatchConditionGroupFilter(DynamicObject parseRuleDo, long conditionGroupId) {
        DynamicObject conditionGroupDo = BusinessDataServiceHelper.loadSingle((Object)conditionGroupId, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)CONDITIONGROUPOBJECT).getDynamicObjectType());
        return PolicyParseRuleHelper.buildConditionMatchConditionGroupFilter(parseRuleDo, conditionGroupDo);
    }

    public static QFilter buildConditionMatchConditionGroupFilter(DynamicObject parseRuleDo, DynamicObject conditionGroupDo) {
        if (parseRuleDo == null || conditionGroupDo == null) {
            return null;
        }
        DynamicObjectCollection conditionGroupEntryEntity = conditionGroupDo.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)conditionGroupEntryEntity)) {
            return null;
        }
        return PolicyParseRuleHelper.buildConditionGroupEntryFilter(conditionGroupEntryEntity, parseRuleDo, "C");
    }

    public static Map<DynamicObject, List<DynamicObject>> getParseIdTargetDosMap(List<DynamicObject> targetDos) {
        if (CollectionUtils.isEmpty(targetDos)) {
            return null;
        }
        HashMap<String, DynamicObject> targetIdDoMap = new HashMap<String, DynamicObject>(targetDos.size());
        for (DynamicObject targetDo : targetDos) {
            targetIdDoMap.put(String.valueOf(targetDo.getPkValue()), targetDo);
        }
        String targetBillName = targetDos.get(0).getDynamicObjectType().getName();
        QFilter filter = new QFilter("policyentity", "=", (Object)targetBillName);
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] parserules = QueryUtil.load("msrcs_policyparserule", filter.toArray(), new String[0]);
        if (parserules == null || parserules.length == 0) {
            throw new KDBizException("\u672a\u542f\u7528\u653f\u7b56\u5bf9\u8c61\u4e3a\u201c\u653f\u7b56\u76ee\u6807\u201d\u7684\u653f\u7b56\u89e3\u6790\u89c4\u5219");
        }
        HashMap<DynamicObject, List<DynamicObject>> parseDoTargetDosMap = new HashMap<DynamicObject, List<DynamicObject>>(parserules.length);
        for (DynamicObject parserule : parserules) {
            Set tgtIdStrs = targetIdDoMap.keySet();
            if (tgtIdStrs.size() == 0) break;
            HashSet<Long> tgtIds = new HashSet<Long>(tgtIdStrs.size());
            for (String tgtIdStr : tgtIdStrs) {
                tgtIds.add(Long.valueOf(tgtIdStr));
            }
            DynamicObjectCollection targets = PolicyParseRuleHelper.getFilterMatchTargets(parserule, tgtIds);
            if (CollectionUtils.isEmpty((Collection)targets)) continue;
            ArrayList<DynamicObject> parseTargetDos = new ArrayList<DynamicObject>();
            for (DynamicObject target : targets) {
                String targetId = target.getString("id");
                DynamicObject targetDo = (DynamicObject)targetIdDoMap.get(targetId);
                if (targetDo == null) continue;
                parseTargetDos.add(targetDo);
                targetIdDoMap.remove(targetId);
            }
            parseDoTargetDosMap.put(parserule, parseTargetDos);
        }
        if (targetIdDoMap.size() > 0) {
            ArrayList nullTargetDos = new ArrayList(targetIdDoMap.size());
            for (Map.Entry targetIdDo : targetIdDoMap.entrySet()) {
                nullTargetDos.add(targetIdDo.getValue());
            }
            DynamicObject tempDo = BusinessDataServiceHelper.newDynamicObject((String)"msrcs_policyparserule");
            parseDoTargetDosMap.put(tempDo, nullTargetDos);
        }
        return parseDoTargetDosMap;
    }

    public static Map<String, Long> getRebateFieldTargetIdMap(DynamicObject parseRuleDo, List<DynamicObject> targetDos) {
        if (parseRuleDo == null || CollectionUtils.isEmpty(targetDos)) {
            return null;
        }
        Set<Long> targetIds = targetDos.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        HashMap<String, DynamicObject> targetIdDoMap = new HashMap<String, DynamicObject>(targetDos.size());
        for (DynamicObject targetDo : targetDos) {
            targetIdDoMap.put(String.valueOf(targetDo.getPkValue()), targetDo);
        }
        HashMap<String, Long> rebateFieldMap = new HashMap<String, Long>(targetDos.size());
        DynamicObjectCollection targets = PolicyParseRuleHelper.getFilterMatchTargets(parseRuleDo, targetIds);
        if (!CollectionUtils.isEmpty((Collection)targets)) {
            String baseEntityId;
            String rebatefield = parseRuleDo.getString("rebatefield");
            String targetEntityId = targetDos.get(0).getDataEntityType().getName();
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)targetEntityId);
            DynamicProperty rebateProperty = entityType.getProperty(rebatefield);
            boolean isCheckBaseDataCtrl = false;
            String masterIdProp = "id";
            if (rebateProperty instanceof BasedataProp && (isCheckBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)(baseEntityId = ((BasedataProp)rebateProperty).getBaseEntityId())).booleanValue())) {
                masterIdProp = BaseDataServiceHelper.getMasterIdPropName((String)baseEntityId);
            }
            for (DynamicObject target : targets) {
                long targetId = target.getLong("id");
                DynamicObject targetDo = (DynamicObject)targetIdDoMap.get(String.valueOf(targetId));
                DynamicObject rebateFieldObject = targetDo.getDynamicObject(rebatefield);
                if (rebateFieldObject == null) continue;
                String rebateFieldId = rebateFieldObject.getString(masterIdProp);
                if (rebateFieldMap.containsKey(rebateFieldId)) {
                    logger.error(String.format("\u653f\u7b56\u76ee\u6807[%1$s]\u5b58\u5728\u91cd\u590d\u7684\u8fd4\u5229\u5bf9\u8c61:%2$s", targetDo.getString("billno"), rebatefield));
                    throw new KDBizException(String.format("\u653f\u7b56\u76ee\u6807[%1$s]\u5b58\u5728\u91cd\u590d\u7684\u8fd4\u5229\u5bf9\u8c61:%2$s", targetDo.getString("billno"), rebatefield));
                }
                rebateFieldMap.put(rebateFieldId, targetId);
            }
        }
        return rebateFieldMap;
    }

    public static final DynamicObject getPolicParseData(Long targetId) {
        if (targetId <= 0L) {
            return null;
        }
        QFilter filter = new QFilter("policyentity", "=", (Object)REBATETARGETOBJECT);
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] parseDos = QueryUtil.load("msrcs_policyparserule", filter.toArray(), new String[0]);
        if (parseDos == null || parseDos.length == 0) {
            throw new KDBizException("\u672a\u542f\u7528\u653f\u7b56\u5bf9\u8c61\u4e3a\u201c\u653f\u7b56\u76ee\u6807\u201d\u7684\u653f\u7b56\u89e3\u6790\u89c4\u5219");
        }
        DynamicObject parseData = null;
        for (DynamicObject parseDo : parseDos) {
            DynamicObject target = PolicyParseRuleHelper.getFilterMatchTargets(parseDo, targetId);
            if (ObjectUtils.isEmpty((Object)target)) continue;
            parseData = parseDo;
            break;
        }
        return parseData;
    }

    public static final HashMap<Long, Set<Long>> getPolicParseMap(Set<Long> targetIds) {
        if (CollectionUtils.isEmpty(targetIds)) {
            return null;
        }
        QFilter filter = new QFilter("policyentity", "=", (Object)REBATETARGETOBJECT);
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] parseDos = QueryUtil.load("msrcs_policyparserule", filter.toArray(), new String[0]);
        if (parseDos == null || parseDos.length == 0) {
            throw new KDBizException("\u672a\u542f\u7528\u653f\u7b56\u5bf9\u8c61\u4e3a\u201c\u653f\u7b56\u76ee\u6807\u201d\u7684\u653f\u7b56\u89e3\u6790\u89c4\u5219");
        }
        HashMap<Long, Set<Long>> parseIdTargetIdsMap = new HashMap<Long, Set<Long>>(targetIds.size());
        for (DynamicObject parseDo : parseDos) {
            if (targetIds.size() == 0) break;
            DynamicObjectCollection targets = PolicyParseRuleHelper.getFilterMatchTargets(parseDo, targetIds);
            if (targets == null || targets.size() <= 0) continue;
            Set parseTargetIds = targets.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
            parseIdTargetIdsMap.put(parseDo.getLong("id"), parseTargetIds);
            targetIds.removeAll(parseTargetIds);
        }
        return parseIdTargetIdsMap;
    }

    public static Map<String, String> getSourceFieldVarMap(DynamicObject targetDo) {
        HashMap<String, String> sourceFieldVarMap = new HashMap<String, String>(0);
        long parseRuleId = PolicyParseRuleHelper.getParseRuleId(targetDo, "policyentity", REBATETARGETOBJECT);
        DynamicObjectCollection calEntity = PolicyParseRuleHelper.queryCalEntity(parseRuleId);
        if (!CollectionUtils.isEmpty((Collection)calEntity)) {
            for (DynamicObject calEntry : calEntity) {
                String sourceentity = calEntry.getString("calentity.sourceentity");
                if (!StringUtils.equals((CharSequence)sourceentity, (CharSequence)REBATETARGETOBJECT)) continue;
                String sourcecol = calEntry.getString("calentity.sourcecol");
                String varcol = calEntry.getString("calentity.varcol");
                sourceFieldVarMap.put(sourcecol, varcol);
            }
        }
        return sourceFieldVarMap;
    }

    public static Map<String, String> getSourceFieldEntryKeyMap(DynamicObject targetDo) {
        HashMap<String, String> sourceFieldVarMap = new HashMap<String, String>(0);
        long parseRuleId = PolicyParseRuleHelper.getParseRuleId(targetDo, "policyentity", REBATETARGETOBJECT);
        DynamicObjectCollection calEntity = PolicyParseRuleHelper.queryCalEntity(parseRuleId);
        if (!CollectionUtils.isEmpty((Collection)calEntity)) {
            for (DynamicObject calEntry : calEntity) {
                String sourceentity = calEntry.getString("calentity.sourceentity");
                if (!StringUtils.equals((CharSequence)sourceentity, (CharSequence)REBATETARGETOBJECT)) continue;
                String sourcecol = calEntry.getString("calentity.sourcecol");
                String sourceentrykey = calEntry.getString("calentity.sourceentrykey");
                sourceFieldVarMap.put(sourcecol, sourceentrykey);
            }
        }
        return sourceFieldVarMap;
    }

    private static long getParseRuleId(DynamicObject targetDo, String entityField, String entityObjectValue) {
        DynamicObject parserule;
        QFilter filter = new QFilter(entityField, "=", (Object)entityObjectValue);
        filter.and("enable", "=", (Object)"1");
        String selectFields = String.join((CharSequence)",", "id", "filterscheme", "policyentity", "rebateschema");
        DynamicObjectCollection parserules = QueryServiceHelper.query((String)"msrcs_policyparserule", (String)selectFields, (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)parserules)) {
            throw new KDBizException("\u672a\u542f\u7528\u653f\u7b56\u5bf9\u8c61\u4e3a\u201c\u653f\u7b56\u76ee\u6807\u201d\u7684\u653f\u7b56\u89e3\u6790\u89c4\u5219\u3002");
        }
        long parseRultId = 0L;
        long targetId = (Long)targetDo.getPkValue();
        Iterator iterator = parserules.iterator();
        while (iterator.hasNext() && (parseRultId = PolicyParseRuleHelper.getFilterMatchTargetParseRuleId(parserule = (DynamicObject)iterator.next(), targetId)) <= 0L) {
        }
        if (parseRultId == 0L) {
            throw new KDBizException(String.format("\u653f\u7b56\u76ee\u6807[%1$s]\u672a\u5339\u914d\u5230\u653f\u7b56\u89e3\u6790\u89c4\u5219\u3002", targetDo.getString("billno")));
        }
        return parseRultId;
    }

    private static long getFilterMatchTargetParseRuleId(DynamicObject parserule, long targetId) {
        long parseRultId = 0L;
        String dataEntityType = parserule.getString("policyentity");
        String filterscheme = parserule.getString("filterscheme");
        long rebateschemaId = parserule.getLong("rebateschema");
        QFilter qFilter = FilterConditionUtil.translateInfoSqlFilter(dataEntityType, filterscheme);
        if (qFilter == null) {
            qFilter = new QFilter("nrebateclass.rebateschema", "=", (Object)rebateschemaId);
        } else {
            qFilter.and("nrebateclass.rebateschema", "=", (Object)rebateschemaId);
        }
        boolean isExist = QueryServiceHelper.exists((String)dataEntityType, (QFilter[])qFilter.and("id", "=", (Object)targetId).toArray());
        if (isExist) {
            parseRultId = parserule.getLong("id");
        }
        return parseRultId;
    }

    private static DynamicObjectCollection getFilterMatchTargets(DynamicObject parserule, Set<Long> targetIds) {
        if (parserule == null) {
            return null;
        }
        DynamicObject dataEntityModel = parserule.getDynamicObject("policyentity");
        String entityName = dataEntityModel.getString("number");
        long rebateschemaId = DynamicObjectUtils.getDynamicObjectLPkValue(parserule, "rebateschema");
        String filterscheme = parserule.getString("filterscheme");
        QFilter qFilter = FilterConditionUtil.translateInfoSqlFilter(entityName, filterscheme);
        if (qFilter == null) {
            qFilter = new QFilter("nrebateclass.rebateschema", "=", (Object)rebateschemaId);
        } else {
            qFilter.and("nrebateclass.rebateschema", "=", (Object)rebateschemaId);
        }
        return QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qFilter.and("id", "in", targetIds).toArray());
    }

    private static DynamicObject getFilterMatchTargets(DynamicObject parserule, Long targetId) {
        DynamicObject dataEntityModel = parserule.getDynamicObject("policyentity");
        String entityName = dataEntityModel.getString("number");
        long rebateschemaId = DynamicObjectUtils.getDynamicObjectLPkValue(parserule, "rebateschema");
        String filterscheme = parserule.getString("filterscheme");
        QFilter qFilter = FilterConditionUtil.translateInfoSqlFilter(entityName, filterscheme);
        if (qFilter == null) {
            qFilter = new QFilter("nrebateclass.rebateschema", "=", (Object)rebateschemaId);
        } else {
            qFilter.and("nrebateclass.rebateschema", "=", (Object)rebateschemaId);
        }
        return QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])qFilter.and("id", "=", (Object)targetId).toArray());
    }

    private static QFilter buildHeaderFilter(DynamicObject targetDo, DynamicObject parseRuleDo, String conditionType) {
        DataEntityPropertyCollection rebateModelProperties = PolicyParseRuleHelper.getRebateModelProperties(parseRuleDo);
        DynamicObjectCollection matchEntryEntity = parseRuleDo.getDynamicObjectCollection("entryentity");
        DataEntityPropertyCollection tgtProperties = targetDo.getDataEntityType().getProperties();
        QFilter matchFilter = null;
        for (DynamicObject matchEntry : matchEntryEntity) {
            QFilter filter;
            String matchMode;
            Object sourceValue;
            String baseEntityId;
            String conditiontype = matchEntry.getString("conditiontype");
            if (!StringUtils.equals((CharSequence)conditiontype, (CharSequence)conditionType)) continue;
            String modelcol = matchEntry.getString("modelcol");
            String sourceCol = matchEntry.getString("policycol");
            if (!tgtProperties.containsKey((Object)sourceCol)) {
                throw new KDBizException(String.format("\u6761\u4ef6\u5b57\u6bb5\u6807\u8bc6[%1$s]\u5728\u6761\u4ef6\u6765\u6e90\u5bf9\u8c61\u4e2d\u4e0d\u5b58\u5728\u3002", sourceCol));
            }
            IDataEntityProperty modelProp = (IDataEntityProperty)rebateModelProperties.get((Object)modelcol);
            boolean isCheckBaseDataCtrl = false;
            String masterIdProp = "";
            if (modelProp instanceof BasedataProp && (isCheckBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)(baseEntityId = ((BasedataProp)modelProp).getBaseEntityId())).booleanValue())) {
                masterIdProp = BaseDataServiceHelper.getMasterIdPropName((String)baseEntityId);
            }
            if ((sourceValue = PolicyParseRuleHelper.getSourceValue(targetDo, tgtProperties, sourceCol, isCheckBaseDataCtrl, masterIdProp)) == null) continue;
            String qcpStr = matchMode = matchEntry.getString("matchmode");
            IDataEntityProperty entryProp = (IDataEntityProperty)tgtProperties.get((Object)sourceCol);
            if (entryProp instanceof MulBasedataProp) {
                qcpStr = "in";
            }
            if ((filter = PolicyParseRuleHelper.buildMatchDataEntryFilter(matchEntry, qcpStr, sourceValue, isCheckBaseDataCtrl, masterIdProp)) == null) continue;
            if (matchFilter == null) {
                matchFilter = filter;
                continue;
            }
            matchFilter.and(filter);
        }
        return matchFilter;
    }

    private static QFilter buildItemRangeEntryFilter(DynamicObjectCollection itemClassEntity, DynamicObject parseRuleDo, String conditionType) {
        DataEntityPropertyCollection rebateModelProperties = PolicyParseRuleHelper.getRebateModelProperties(parseRuleDo);
        DynamicObjectCollection matchEntryEntity = parseRuleDo.getDynamicObjectCollection("entryentity");
        QFilter matchFilter = null;
        Map<String, Set<Object>> mergeSourceValueMap = PolicyParseRuleHelper.getMergeSourceValueMap(itemClassEntity, parseRuleDo);
        Set<String> repeatModelColSet = PolicyParseRuleHelper.getRepeatModelColSet(matchEntryEntity);
        HashMap<String, Set> matchColValueMap = new HashMap<String, Set>(matchEntryEntity.size());
        DataEntityPropertyCollection entryProperties = ((DynamicObject)itemClassEntity.get(0)).getDataEntityType().getProperties();
        block0: for (DynamicObject matchEntry : matchEntryEntity) {
            String baseEntityId;
            String conditiontype = matchEntry.getString("conditiontype");
            if (!StringUtils.equals((CharSequence)conditiontype, (CharSequence)conditionType)) continue;
            String modelcol = matchEntry.getString("modelcol");
            String sourceCol = matchEntry.getString("policycol");
            String matchMode = matchEntry.getString("matchmode");
            if (!entryProperties.containsKey((Object)sourceCol) && !sourceCol.contains(".")) continue;
            IDataEntityProperty modelProp = (IDataEntityProperty)rebateModelProperties.get((Object)modelcol);
            boolean isCheckBaseDataCtrl = false;
            String masterIdProp = "";
            if (modelProp instanceof BasedataProp && (isCheckBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)(baseEntityId = ((BasedataProp)modelProp).getBaseEntityId())).booleanValue())) {
                masterIdProp = BaseDataServiceHelper.getMasterIdPropName((String)baseEntityId);
            }
            String qcpStr = matchMode;
            for (DynamicObject itemClassEntry : itemClassEntity) {
                boolean isMergeSourceValue = false;
                Object sourceValue = mergeSourceValueMap.get(sourceCol);
                if (sourceValue == null) {
                    sourceValue = PolicyParseRuleHelper.getSourceValue(itemClassEntry, entryProperties, sourceCol, isCheckBaseDataCtrl, masterIdProp);
                    if (sourceValue == null) continue;
                    IDataEntityProperty entryProp = (IDataEntityProperty)entryProperties.get((Object)sourceCol);
                    if (entryProp instanceof MulBasedataProp) {
                        qcpStr = "in";
                    }
                } else {
                    isMergeSourceValue = true;
                    qcpStr = "in";
                }
                QFilter filter = PolicyParseRuleHelper.buildMatchDataEntryFilter(matchEntry, qcpStr, sourceValue, isCheckBaseDataCtrl, masterIdProp);
                if (filter != null) {
                    if (repeatModelColSet.contains(modelcol)) {
                        sourceValue = filter.getValue();
                        Set filterValue = matchColValueMap.getOrDefault(modelcol, new HashSet(0));
                        if (sourceValue instanceof Set) {
                            filterValue.addAll((Set)sourceValue);
                        } else {
                            filterValue.add(sourceValue);
                        }
                        matchColValueMap.put(modelcol, filterValue);
                    } else if (matchFilter == null) {
                        matchFilter = filter;
                    } else {
                        matchFilter.and(filter);
                    }
                }
                if (!isMergeSourceValue) continue;
                continue block0;
            }
        }
        if (matchColValueMap != null && matchColValueMap.size() > 0) {
            for (Map.Entry matchColValue : matchColValueMap.entrySet()) {
                String baseEntityId;
                IDataEntityProperty modelProp = (IDataEntityProperty)rebateModelProperties.get(matchColValue.getKey());
                boolean isCheckBaseDataCtrl = false;
                String masterIdProp = "";
                if (modelProp instanceof BasedataProp && (isCheckBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)(baseEntityId = ((BasedataProp)modelProp).getBaseEntityId())).booleanValue())) {
                    masterIdProp = "." + BaseDataServiceHelper.getMasterIdPropName((String)baseEntityId);
                }
                if (matchFilter == null) {
                    matchFilter = new QFilter((String)matchColValue.getKey() + masterIdProp, "in", matchColValue.getValue());
                    continue;
                }
                matchFilter.and((String)matchColValue.getKey() + masterIdProp, "in", matchColValue.getValue());
            }
        }
        return matchFilter;
    }

    private static QFilter buildConditionGroupEntryFilter(DynamicObjectCollection conditionGroupEntryEntity, DynamicObject parseRuleDo, String conditionType) {
        String baseEntityId;
        String masterIdProp;
        IDataEntityProperty modelProp;
        DataEntityPropertyCollection rebateModelProperties = PolicyParseRuleHelper.getRebateModelProperties(parseRuleDo);
        DynamicObjectCollection matchEntryEntity = parseRuleDo.getDynamicObjectCollection("entryentity");
        QFilter matchFilter = null;
        Set<String> repeatModelColSet = PolicyParseRuleHelper.getRepeatModelColSet(matchEntryEntity);
        HashMap<String, Set> repeatColValueMap = new HashMap<String, Set>(matchEntryEntity.size());
        HashMap<String, Set> repeatColExcValueMap = new HashMap<String, Set>(matchEntryEntity.size());
        DataEntityPropertyCollection entryProperties = ((DynamicObject)conditionGroupEntryEntity.get(0)).getDataEntityType().getProperties();
        for (DynamicObject matchEntry : matchEntryEntity) {
            String baseEntityId2;
            String conditiontype = matchEntry.getString("conditiontype");
            if (!StringUtils.equals((CharSequence)conditiontype, (CharSequence)conditionType)) continue;
            String modelcol = matchEntry.getString("modelcol");
            String sourceCol = matchEntry.getString("policycol");
            String matchMode = matchEntry.getString("matchmode");
            if (!entryProperties.containsKey((Object)sourceCol) && !sourceCol.contains(".")) continue;
            IDataEntityProperty modelProp2 = (IDataEntityProperty)rebateModelProperties.get((Object)modelcol);
            boolean isCheckBaseDataCtrl = false;
            String masterIdProp2 = "";
            if (modelProp2 instanceof BasedataProp && (isCheckBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)(baseEntityId2 = ((BasedataProp)modelProp2).getBaseEntityId())).booleanValue())) {
                masterIdProp2 = BaseDataServiceHelper.getMasterIdPropName((String)baseEntityId2);
            }
            String qcpStr = matchMode;
            for (DynamicObject conditionGroupEntry : conditionGroupEntryEntity) {
                QFilter filter;
                IDataEntityProperty entryProp;
                Object sourceValue = PolicyParseRuleHelper.getSourceValue(conditionGroupEntry, entryProperties, sourceCol, isCheckBaseDataCtrl, masterIdProp2);
                if (sourceValue == null) continue;
                String logicrelation = conditionGroupEntry.getString("logicrelation");
                boolean isEqualsCp = true;
                if (StringUtils.equals((CharSequence)logicrelation, (CharSequence)"0")) {
                    isEqualsCp = false;
                    qcpStr = "!=";
                }
                if ((entryProp = (IDataEntityProperty)entryProperties.get((Object)sourceCol)) instanceof MulBasedataProp) {
                    qcpStr = "in";
                    if (!isEqualsCp) {
                        qcpStr = "not in";
                    }
                }
                if ((filter = PolicyParseRuleHelper.buildMatchDataEntryFilter(matchEntry, qcpStr, sourceValue, isCheckBaseDataCtrl, masterIdProp2)) == null) continue;
                if (repeatModelColSet.contains(modelcol)) {
                    Set filterValue;
                    sourceValue = filter.getValue();
                    if (StringUtils.equals((CharSequence)logicrelation, (CharSequence)"1")) {
                        filterValue = repeatColValueMap.getOrDefault(modelcol, new HashSet(0));
                        if (sourceValue instanceof Set) {
                            filterValue.addAll((Set)sourceValue);
                        } else {
                            filterValue.add(sourceValue);
                        }
                        repeatColValueMap.put(modelcol, filterValue);
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)logicrelation, (CharSequence)"0")) continue;
                    filterValue = repeatColExcValueMap.getOrDefault(modelcol, new HashSet(0));
                    if (sourceValue instanceof Set) {
                        filterValue.addAll((Set)sourceValue);
                    } else {
                        filterValue.add(sourceValue);
                    }
                    repeatColExcValueMap.put(modelcol, filterValue);
                    continue;
                }
                if (matchFilter == null) {
                    matchFilter = filter;
                    continue;
                }
                matchFilter.and(filter);
            }
        }
        if (repeatColValueMap != null && repeatColValueMap.size() > 0) {
            for (Map.Entry colValue : repeatColValueMap.entrySet()) {
                modelProp = (IDataEntityProperty)rebateModelProperties.get(colValue.getKey());
                boolean isCheckBaseDataCtrl = false;
                masterIdProp = "";
                if (modelProp instanceof BasedataProp && (isCheckBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)(baseEntityId = ((BasedataProp)modelProp).getBaseEntityId())).booleanValue())) {
                    masterIdProp = "." + BaseDataServiceHelper.getMasterIdPropName((String)baseEntityId);
                }
                if (matchFilter == null) {
                    matchFilter = new QFilter((String)colValue.getKey() + masterIdProp, "in", colValue.getValue());
                    continue;
                }
                matchFilter.and((String)colValue.getKey() + masterIdProp, "in", colValue.getValue());
            }
        }
        if (repeatColExcValueMap != null && repeatColExcValueMap.size() > 0) {
            for (Map.Entry colExcValue : repeatColExcValueMap.entrySet()) {
                modelProp = (IDataEntityProperty)rebateModelProperties.get(colExcValue.getKey());
                boolean isCheckBaseDataCtrl = false;
                masterIdProp = "";
                if (modelProp instanceof BasedataProp && (isCheckBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)(baseEntityId = ((BasedataProp)modelProp).getBaseEntityId())).booleanValue())) {
                    masterIdProp = "." + BaseDataServiceHelper.getMasterIdPropName((String)baseEntityId);
                }
                if (matchFilter == null) {
                    matchFilter = new QFilter((String)colExcValue.getKey() + masterIdProp, "not in", colExcValue.getValue());
                    continue;
                }
                matchFilter.and((String)colExcValue.getKey() + masterIdProp, "not in", colExcValue.getValue());
            }
        }
        return matchFilter;
    }

    private static Object getSourceValue(DynamicObject conditionGroupEntry, DataEntityPropertyCollection entryProperties, String sourceCol, boolean isCheckBaseDataCtrl, String masterIdProp) {
        String prop;
        Object sp1;
        String[] spProperties;
        Set sourceValue = conditionGroupEntry.get(sourceCol);
        if (sourceValue == null || ObjectUtils.isEmpty((Object)sourceValue)) {
            return null;
        }
        if (sourceCol.contains(".") && (spProperties = sourceCol.split("\\.")) != null && spProperties.length == 2 && (sp1 = conditionGroupEntry.get(prop = spProperties[0])) instanceof DynamicObject) {
            Object sp2 = ((DynamicObject)sp1).get(spProperties[1]);
            if (sp2 != null) {
                sourceValue = sp2 instanceof DynamicObject ? ((DynamicObject)sp2).getPkValue() : sp2;
            }
            return sourceValue;
        }
        IDataEntityProperty entryProp = (IDataEntityProperty)entryProperties.get((Object)sourceCol);
        if (entryProp instanceof BasedataProp) {
            DynamicObject basedata = conditionGroupEntry.getDynamicObject(sourceCol);
            if (basedata != null) {
                if (!isCheckBaseDataCtrl) {
                    sourceValue = basedata.getPkValue();
                } else if (!StringUtils.isEmpty((CharSequence)masterIdProp)) {
                    sourceValue = basedata.get(masterIdProp);
                }
            }
        } else if (entryProp instanceof MulBasedataProp) {
            DynamicObjectCollection mulDatas = conditionGroupEntry.getDynamicObjectCollection(sourceCol);
            if (!CollectionUtils.isEmpty((Collection)mulDatas)) {
                sourceValue = mulDatas.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toSet());
            }
        } else if (entryProp instanceof DateProp) {
            sourceValue = conditionGroupEntry.getDate(sourceCol);
        }
        return sourceValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static QFilter buildMatchDataEntryFilter(DynamicObject matchEntry, String qcpStr, Object sourceValue, boolean isCheckBaseDataCtrl, String masterIdProp) {
        QFilter filter = null;
        String modelCol = matchEntry.getString("modelcol");
        if (isCheckBaseDataCtrl) {
            modelCol = modelCol + "." + masterIdProp;
        }
        String matchPlugin = matchEntry.getString("matchplugin");
        String matchMode = matchEntry.getString("matchmode");
        if (!StringUtils.equals((CharSequence)matchMode, (CharSequence)"cus")) return new QFilter(modelCol, qcpStr, sourceValue);
        Object objService = TypesContainer.getOrRegisterSingletonInstance((String)matchPlugin);
        if (!(objService instanceof AbstractConditionMatch)) throw new KDBizException("\u63d2\u4ef6\u9700\u8981\u5b9e\u73b0AbstractConditionMatchByCtrlStrategy\u7c7b\u7684buildEntryFilter\u65b9\u6cd5\u3002");
        AbstractConditionMatch condMatch = (AbstractConditionMatch)objService;
        return condMatch.buildEntryFilter(modelCol, sourceValue, isCheckBaseDataCtrl);
    }

    private static DynamicObjectCollection queryCalEntity(long conditionMatchId) {
        String selectFields = "rebatefield,calentity.varcol,calentity.sourceentity,calentity.sourcecol,calentity.sourceentrykey,calentity.sourcecolid";
        QFilter filter = new QFilter("id", "=", (Object)conditionMatchId);
        return QueryServiceHelper.query((String)"msrcs_policyparserule", (String)selectFields, (QFilter[])filter.toArray());
    }

    private static Set<String> getRepeatModelColSet(DynamicObjectCollection entryEntity) {
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return new HashSet<String>(0);
        }
        HashSet<String> repeatColSet = new HashSet<String>(entryEntity.size());
        ArrayList<String> colLst = new ArrayList<String>(entryEntity.size());
        for (DynamicObject entry : entryEntity) {
            String matchCol = entry.getString("modelcol");
            String matchMode = entry.getString("matchmode");
            if (colLst.contains(matchCol) && (StringUtils.equals((CharSequence)matchMode, (CharSequence)"=") || StringUtils.equals((CharSequence)matchMode, (CharSequence)"in") || StringUtils.equals((CharSequence)matchMode, (CharSequence)"cus"))) {
                repeatColSet.add(matchCol);
                continue;
            }
            colLst.add(matchCol);
        }
        return repeatColSet;
    }

    private static Map<String, Set<Object>> getMergeSourceValueMap(DynamicObjectCollection itemClassEntity, DynamicObject parseRuleDo) {
        HashMap<String, Set<Object>> mergeSourceValueMap = new HashMap<String, Set<Object>>(0);
        DataEntityPropertyCollection rebateModelProperties = PolicyParseRuleHelper.getRebateModelProperties(parseRuleDo);
        DynamicObjectCollection matchEntryEntity = parseRuleDo.getDynamicObjectCollection("entryentity");
        DataEntityPropertyCollection entryProperties = ((DynamicObject)itemClassEntity.get(0)).getDataEntityType().getProperties();
        for (DynamicObject entry : matchEntryEntity) {
            String baseEntityId;
            String modelcol = entry.getString("modelcol");
            String sourceCol = entry.getString("policycol");
            if (!entryProperties.containsKey((Object)sourceCol) && !sourceCol.contains(".")) continue;
            IDataEntityProperty modelProp = (IDataEntityProperty)rebateModelProperties.get((Object)modelcol);
            IDataEntityProperty entryProp = (IDataEntityProperty)entryProperties.get((Object)sourceCol);
            if (entryProp == null) continue;
            boolean isCheckBaseDataCtrl = false;
            String masterIdProp = "";
            if (modelProp instanceof BasedataProp && (isCheckBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)(baseEntityId = ((BasedataProp)modelProp).getBaseEntityId())).booleanValue())) {
                masterIdProp = BaseDataServiceHelper.getMasterIdPropName((String)baseEntityId);
            }
            for (DynamicObject itemClassEntry : itemClassEntity) {
                Set<Object> mergeValueSet;
                Object sourceValue;
                if (entryProp instanceof BasedataProp) {
                    sourceValue = PolicyParseRuleHelper.getSourceValue(itemClassEntry, entryProperties, sourceCol, isCheckBaseDataCtrl, masterIdProp);
                    if (sourceValue == null) continue;
                    mergeValueSet = (HashSet<Object>)mergeSourceValueMap.get(sourceCol);
                    if (mergeValueSet == null) {
                        mergeValueSet = new HashSet<Object>();
                    }
                    mergeValueSet.add(sourceValue);
                    mergeSourceValueMap.put(sourceCol, mergeValueSet);
                    continue;
                }
                if (!(entryProp instanceof MulBasedataProp) || (sourceValue = PolicyParseRuleHelper.getSourceValue(itemClassEntry, entryProperties, sourceCol, isCheckBaseDataCtrl, masterIdProp)) == null) continue;
                mergeValueSet = (Set)mergeSourceValueMap.get(sourceCol);
                if (mergeValueSet == null) {
                    mergeValueSet = new HashSet();
                }
                if (sourceValue instanceof Set) {
                    Set sourceValueSet = (Set)sourceValue;
                    mergeValueSet.addAll(sourceValueSet);
                } else {
                    mergeValueSet.add(sourceValue);
                }
                mergeSourceValueMap.put(sourceCol, mergeValueSet);
            }
        }
        return mergeSourceValueMap;
    }

    private static DataEntityPropertyCollection getRebateModelProperties(DynamicObject parseRuleDo) {
        DynamicObject rebateSchema = parseRuleDo.getDynamicObject("rebateschema");
        if (rebateSchema == null) {
            throw new KDBizException("\u8fd4\u5229\u8ba1\u7b97\u65b9\u6848\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        DynamicObject rebateModel = rebateSchema.getDynamicObject("rebatemodel");
        if (rebateModel == null) {
            throw new KDBizException("\u8fd4\u5229\u8ba1\u7b97\u6a21\u578b:\u5c5e\u6027\u8868\u5143\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)rebateModel.getString("number"));
        return entityType.getProperties();
    }
}

