/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.common.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.mpscmm.msrcs.business.RebateFormulaServiceHelper;
import kd.sdk.mpscmm.msrcs.formula.AbstractCalculator;
import kd.sdk.mpscmm.msrcs.formula.AbstractLadder;

public class CalcFormula {
    private AbstractLadder ladder;
    private AbstractCalculator calculator;

    public static final CalcFormula init(Long ladderPkValue, Long calculatorPkValue) {
        CalcFormula calcFormula = new CalcFormula();
        calcFormula.ladder = RebateFormulaServiceHelper.getLadder(ladderPkValue);
        calcFormula.calculator = RebateFormulaServiceHelper.getCalculator(calculatorPkValue);
        return calcFormula;
    }

    public List<String> getAllVars() {
        ArrayList<String> allVars = new ArrayList<String>();
        allVars.addAll(Arrays.asList(this.ladder.getAllVar()));
        allVars.addAll(Arrays.asList(this.calculator.getAllVar()));
        return allVars.stream().distinct().collect(Collectors.toList());
    }

    public AbstractLadder getLadder() {
        return this.ladder;
    }

    public AbstractCalculator getCalculator() {
        return this.calculator;
    }
}

