/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.common.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.CRFormula;
import kd.bos.formula.FormulaEngine;
import kd.bos.util.StringUtils;
import kd.sdk.mpscmm.msrcs.formula.AbstractFactor;

public class Factor
implements Serializable {
    private static final String SUM = "A";
    private Object pkValue;
    private String key;
    private String exp;
    private String[] expFields;
    private String calcType;
    private String specDim;
    private String plugin;
    private AbstractFactor pluginInstance = null;
    private Map<String, BigDecimal> values = new HashMap<String, BigDecimal>(4);

    public Object getPkValue() {
        return this.pkValue;
    }

    public void setPkValue(Object pkValue) {
        this.pkValue = pkValue;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getExp() {
        return this.exp;
    }

    public void setExp(String exp) {
        if (StringUtils.isNotEmpty((String)exp)) {
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)exp, CRFormula.class);
            this.exp = formula.getExpression();
            this.setExpFields(FormulaEngine.extractVariables((String)this.exp));
        }
    }

    public String getCalcType() {
        return this.calcType;
    }

    public void setCalcType(String calcType) {
        this.calcType = calcType;
    }

    public String getSpecDim() {
        return this.specDim;
    }

    public void setSpecDim(String specDim) {
        this.specDim = specDim;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public void setPlugin(String plugin) {
        this.plugin = plugin;
    }

    public AbstractFactor getPluginInstance() {
        if (this.pluginInstance == null && StringUtils.isNotEmpty((String)this.plugin)) {
            this.pluginInstance = (AbstractFactor)TypesContainer.createInstance((String)this.plugin);
        }
        return this.pluginInstance;
    }

    public BigDecimal getValue(String dimKey) {
        if (!this.values.containsKey(dimKey)) {
            return BigDecimal.ZERO;
        }
        return this.values.get(dimKey);
    }

    public BigDecimal getValue(List<Object> dimValues) {
        String dimKey = this.getDimKey(dimValues);
        return this.getValue(dimKey);
    }

    public Map<String, BigDecimal> getAllValues() {
        return this.values;
    }

    public void calc(List<Object> dimValues, Map<String, Object> fieldValueMap) {
        String dimKey = this.getDimKey(dimValues);
        if (this.calcType.equalsIgnoreCase(SUM)) {
            BigDecimal value = (BigDecimal)FormulaEngine.execExcelFormula((String)this.exp, fieldValueMap);
            this.values.put(dimKey, this.getValue(dimKey).add(value));
        }
    }

    private String getDimKey(List<Object> dimValues) {
        StringBuilder v = new StringBuilder();
        for (Object value : dimValues) {
            v.append(value == null ? "_" : value).append(",");
        }
        v.deleteCharAt(v.length() - 1);
        return v.toString();
    }

    public String[] getExpFields() {
        return this.expFields;
    }

    public void setExpFields(String[] expFields) {
        this.expFields = expFields;
    }
}

