/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.common.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.StringUtils;
import kd.mpscmm.msrcs.common.model.CustomField;
import kd.mpscmm.msrcs.engine.enginer.Ladder;
import kd.mpscmm.msrcs.engine.output.obj.Grouper;
import kd.sdk.mpscmm.msrcs.formula.FormulaData;

public class PolicyParser {
    private static final long serialVersionUID = 3843892258273258377L;
    public final DynamicObject policyParserDataObject;

    public PolicyParser(DynamicObject policyParserDataObject) {
        this.policyParserDataObject = policyParserDataObject;
    }

    public final String getRebateModelFormId() {
        return this.policyParserDataObject.getDynamicObject("rebateschema").getDynamicObject("rebatemodel").getPkValue().toString();
    }

    public final List<DynamicObject> getCalcFactorList() {
        DynamicObjectCollection calcEntityCollection = this.policyParserDataObject.getDynamicObjectCollection("calentity");
        if (calcEntityCollection == null || calcEntityCollection.size() == 0) {
            return new ArrayList<DynamicObject>();
        }
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        for (DynamicObject dataObject : calcEntityCollection) {
            if (!dataObject.getDynamicObject("sourceentity").getPkValue().toString().equalsIgnoreCase("msrcs_rebatefactor")) continue;
            resultList.add(dataObject);
        }
        return resultList;
    }

    public final DynamicObject getVarMap(String var, String ladderIdentifier) {
        var = var.toLowerCase();
        ArrayList<String> varList = new ArrayList<String>();
        varList.add(var);
        Map<String, DynamicObject> maps = this.getVarMap(varList, ladderIdentifier);
        return maps.get(var);
    }

    public final String getAlgoxField(String var, String ladderIdentifier) {
        DynamicObject dynamicObject = this.getVarMap(var, ladderIdentifier);
        if (dynamicObject == null) {
            return null;
        }
        String rebateTargetFormId = this.getRebateModelFormId();
        String sourceentity = dynamicObject.getDynamicObject("sourceentity").getPkValue().toString();
        if (sourceentity.equalsIgnoreCase(rebateTargetFormId)) {
            return dynamicObject.getString("sourcecol");
        }
        return CustomField.getKey(var);
    }

    public final Map<String, DynamicObject> getVarMap(List<String> varList, String ladderIdentifier) {
        DynamicObjectCollection calcEntityCollection = this.policyParserDataObject.getDynamicObjectCollection("calentity");
        if (calcEntityCollection == null || calcEntityCollection.size() == 0) {
            return new HashMap<String, DynamicObject>();
        }
        HashMap<String, DynamicObject> varMap = new HashMap<String, DynamicObject>();
        if (StringUtils.isNotEmpty((String)ladderIdentifier)) {
            for (DynamicObject calcEntityDataObject : calcEntityCollection) {
                String dbLadderIdentifier;
                String varKey = calcEntityDataObject.getString("varcol").toLowerCase();
                if (!varList.contains(varKey) || (!StringUtils.isEmpty((String)(dbLadderIdentifier = calcEntityDataObject.getString("sourceentrykey"))) || varMap.containsKey(varKey)) && !dbLadderIdentifier.equalsIgnoreCase(ladderIdentifier)) continue;
                varMap.put(varKey, calcEntityDataObject);
            }
        } else {
            for (DynamicObject calcEntityDataObject : calcEntityCollection) {
                String varKey = calcEntityDataObject.getString("varcol");
                if (!varList.contains(varKey)) continue;
                varMap.put(varKey, calcEntityDataObject);
            }
        }
        return varMap;
    }

    public List<FormulaData> mapTargetFormDataToLadder(List<String> vars, List<Ladder> ladderList, String ladderIdentifier) {
        Map<String, DynamicObject> varMaps = this.getVarMap(vars, ladderIdentifier);
        String rebateTargetFormId = this.policyParserDataObject.getDynamicObject("policyentity").getPkValue().toString();
        ArrayList<FormulaData> destLadderList = new ArrayList<FormulaData>(ladderList.size());
        for (Ladder ladder : ladderList) {
            FormulaData formulaData = new FormulaData();
            for (String var : vars) {
                DynamicObject varMapSetting = varMaps.get(var);
                if (varMapSetting == null || !varMapSetting.getDynamicObject("sourceentity").getPkValue().toString().equalsIgnoreCase(rebateTargetFormId)) continue;
                String sourceFieldKey = varMapSetting.getString("sourcecol");
                formulaData.put(var, ladder.getBigDecimal(sourceFieldKey));
            }
            destLadderList.add(formulaData);
        }
        return destLadderList;
    }

    public FormulaData mapCalcFormDataFromAlgoRow(List<String> vars, RowMeta rowMeta, Grouper grouper, Object[] objects, String ladderIdentifier) {
        Map<String, DynamicObject> varMaps = this.getVarMap(vars, ladderIdentifier);
        FormulaData formulaData = new FormulaData();
        for (String var : vars) {
            BigDecimal value;
            DynamicObject varMapSetting = varMaps.get(var);
            if (varMapSetting == null) continue;
            String sourceEntity = varMapSetting.getDynamicObject("sourceentity").getPkValue().toString();
            String source_var = varMapSetting.getString("sourcecol");
            boolean isFromRebateModel = sourceEntity.equalsIgnoreCase(this.policyParserDataObject.getDynamicObject("rebateschema").getDynamicObject("rebatemodel").getPkValue().toString());
            if (isFromRebateModel) {
                source_var = "m_" + source_var;
            }
            if (grouper != null && grouper.isSumVar(source_var)) {
                value = grouper.getSumVarValue(source_var);
            } else {
                int fieldIndex;
                String algoRowfiekdKey = var;
                if (!isFromRebateModel) {
                    algoRowfiekdKey = CustomField.getKey(var);
                }
                if ((fieldIndex = rowMeta.getFieldIndex(algoRowfiekdKey, false)) < 0) continue;
                value = (BigDecimal)objects[fieldIndex];
            }
            formulaData.put(var, value);
        }
        return formulaData;
    }

    public long getRebateSchemeId() {
        return this.policyParserDataObject.getLong("rebateschema_id");
    }
}

