/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.common.model;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.mpscmm.msrcs.common.util.EntityUtil;

public class RebateDataSource {
    public final DynamicObject dataSource;

    public RebateDataSource(DynamicObject dataSource) {
        this.dataSource = dataSource;
    }

    public final DynamicObjectCollection getDataSourceBotpProperties() {
        return this.dataSource.getDynamicObjectCollection("entity");
    }

    public final Map<String, String> getDataSourceBotpPropertyMap() {
        DynamicObjectCollection properties = this.getDataSourceBotpProperties();
        String sourceEntityId = this.getSourceBillEntityId();
        MainEntityType sourceEntityType = EntityUtil.getMainEntityType(sourceEntityId);
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        for (DynamicObject property : properties) {
            String sourcePropertyId = EntityUtil.getColFullId(sourceEntityType, this.getBotpSourcePropertyId(property));
            String rebateModelPropertyId = this.getBotpRebateModelPropertyId(property);
            propertiesMap.put(rebateModelPropertyId, sourcePropertyId);
        }
        return propertiesMap;
    }

    public final String getSourceBillEntityId() {
        return (String)this.dataSource.getDynamicObject("srcbill").getPkValue();
    }

    public final String getBotpSourcePropertyId(DynamicObject botpDataObject) {
        return botpDataObject.getString("srcpropid");
    }

    public final String getBotpRebateModelPropertyId(DynamicObject botpDataObject) {
        return botpDataObject.getString("modelpropid");
    }

    public final QFilter getFilter() {
        String qFilterStr = this.dataSource.getString("qfitlerstr");
        if (StringUtils.isNotEmpty((String)qFilterStr)) {
            QFilter qFilter = QFilter.fromSerializedString((String)qFilterStr);
        }
        return null;
    }
}

