/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.designer.property.ComboItemsEditPlugin;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRValByCondition;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.botp.runtime.ConvertFuncLoader;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.mpscmm.msrcs.common.pojo.ConditionReceiveValue;
import org.apache.commons.lang3.StringUtils;

public class EntityUtil {
    private static final String CACHEKEY_TREENODE = "TreeNode";
    private static final String PARAM_FILTER = "qfilter";
    private static final String PARAM_FILTERSTR = "filterstr";
    private static final String PARAM_FORMULA = "formula";
    private static final String PARAM_IFCONSTANT = "ifconstant";

    private EntityUtil() {
    }

    public static Map<String, DynamicObject> querySameNumberAndNameEntity(List<DynamicObject> entityList, String entityName, String ... selectFields) {
        if (!CollectionUtils.isEmpty(entityList)) {
            int length = entityList.size();
            HashSet<String> names = new HashSet<String>(length);
            HashSet<String> numbers = new HashSet<String>(length);
            for (DynamicObject entity : entityList) {
                names.add(EntityUtil.getEntityName(entity));
                numbers.add(EntityUtil.getEntityNumber(entity));
            }
            QFilter[] filters = new QFilter("number", "in", numbers).or(new QFilter("name", "in", names)).toArray();
            ArrayList<String> selects = new ArrayList<String>(5);
            selects.add("id");
            selects.add("name");
            selects.add("number");
            if (selectFields != null && selectFields.length > 0) {
                selects.addAll(Arrays.asList(selectFields));
            }
            Map sameNumberAndNameEntityMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)String.join((CharSequence)",", selects), (QFilter[])filters);
            return sameNumberAndNameEntityMap.values().stream().collect(Collectors.toMap(r -> EntityUtil.getNumberAndNameKey(r), r -> r, (t1, t2) -> t1));
        }
        return new HashMap<String, DynamicObject>(0);
    }

    public static String getNumberAndNameKey(DynamicObject entity) {
        return EntityUtil.getEntityNumber(entity) + EntityUtil.getEntityName(entity);
    }

    private static String getEntityNumber(DynamicObject entity) {
        return entity.getString("number");
    }

    private static String getEntityName(DynamicObject entity) {
        return entity.getLocaleString("name").getLocaleValue();
    }

    public static final String getFormIdByField(IDataModel model, String fieldName) {
        DynamicObject entity = model.getDataEntity().getDynamicObject(fieldName);
        if (entity == null) {
            IDataEntityProperty pro = model.getDataEntityType().findProperty(fieldName);
            throw new KDBizException(String.format("\u5148\u9009\u62e9%s", pro.getDisplayName().getLocaleValue()));
        }
        return entity.getString("id");
    }

    public static final MainEntityType getMainEntityType(String formId) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)formId);
        if (type == null) {
            throw new KDBizException(String.format("\u5143\u6570\u636e%s\u5b9e\u4f53\u4e0d\u5b58\u5728", formId));
        }
        return type;
    }

    public static final void showSelectEntityFieldForm(IFormView view, String entityName, PropTreeBuildOption propTreeBuildOption, CloseCallBack closeCallBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        MainEntityType entityType = EntityUtil.getMainEntityType(entityName);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)entityType, (PropTreeBuildOption)propTreeBuildOption);
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(closeCallBack);
        view.showForm(showParameter);
    }

    public static final void showValByConditionForm(IFormView view, IPageCache pageCache, String json, String entityNumber, IDataEntityProperty targetProperty, CloseCallBack closeCallBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_valbycondition");
        showParameter.getCustomParams().put("crvalbyconditions", json);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        String fieldNodes = EntityUtil.getTreeNodeJson(pageCache, entityNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        if (targetProperty instanceof BasedataProp) {
            showParameter.getCustomParams().put("baseentityid", ((BasedataProp)targetProperty).getBaseEntityId());
        }
        String funcsXML = EntityUtil.getFuncsXML(pageCache);
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public static final void showFormulaForm(IFormView view, IPageCache pageCache, String formulaJson, String entityNumber, CloseCallBack closeCallBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_formula");
        showParameter.getCustomParams().put(PARAM_FORMULA, formulaJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        String fieldNodes = EntityUtil.getTreeNodeJson(pageCache, entityNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        String funcsXML = EntityUtil.getFuncsXML(pageCache);
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public static final String getFuncsXML(IPageCache pageCache) {
        String funcsXML = pageCache.get("functiontypes");
        if (StringUtils.isEmpty((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
            FunctionTypes cloudFunc = ConvertFuncLoader.loadBizCloudFuncTypes();
            functionTypes.getFunctionGroups().addAll(cloudFunc.getFunctionGroups());
            functionTypes.getFunctionTypes().addAll(cloudFunc.getFunctionTypes());
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
        }
        return funcsXML;
    }

    public static final String getTreeNodeJson(IPageCache pageCache, String formId) {
        String cacheKey = String.join((CharSequence)"#", CACHEKEY_TREENODE, formId);
        String treeNodeJson = pageCache.get(cacheKey);
        if (StringUtils.isEmpty((CharSequence)treeNodeJson)) {
            PropTreeBuildOption option = new PropTreeBuildOption();
            option.setIncludePKField(true);
            MainEntityType mainEntityType = EntityUtil.getMainEntityType(formId);
            TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainEntityType, (PropTreeBuildOption)option);
            treeNodeJson = SerializationUtils.toJsonString((Object)treeNode);
            pageCache.put(cacheKey, treeNodeJson);
        }
        return treeNodeJson;
    }

    public static final void showComboForm(IFormView view, ComboProp comboProp, CloseCallBack closeCallBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ide_comboitemsselect");
        showParameter.getCustomParams().put("comboProp", EntityUtil.getComboItems(comboProp));
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    private static final Object getComboItems(ComboProp comboProp) {
        List items = comboProp.getComboItems();
        ComboToJsonSerializer comboJson = new ComboToJsonSerializer();
        comboJson.setItems(items);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>(16);
        dts.add(OrmUtils.getDataEntityType(ComboItemsEditPlugin.ComboJsonSerializer.class));
        DcJsonSerializer serializer = new DcJsonSerializer((DcBinder)new ListDcxmlBinder(false, dts));
        Map mapCombo = serializer.serializeToMap((Object)comboJson, null);
        return mapCombo.containsKey("Items") ? mapCombo.get("Items") : items;
    }

    public static void showF7List(BasedataProp bdProp, IFormView view, CloseCallBack closeCallBack) {
        Objects.requireNonNull(bdProp);
        if (bdProp.getBaseEntityId() == null) {
            view.showTipNotification("\u8bf7\u5148\u9009\u62e9\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002");
            return;
        }
        if (FormMetadataCache.getListFormConfig((String)bdProp.getBaseEntityId()) == null) {
            view.showTipNotification("\u5f53\u524d\u57fa\u7840\u8d44\u6599\u672a\u8bbe\u8ba1F7\u5217\u8868\u3002");
            return;
        }
        EntityUtil.showF7List(bdProp.getBaseEntityId(), view, closeCallBack);
    }

    public static void showF7List(String bdEntityNumber, IFormView view, CloseCallBack closeCallBack) {
        BasedataEntityType bdType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)bdEntityNumber);
        EntityUtil.showF7List(bdType, view, closeCallBack);
    }

    public static void showF7List(BasedataEntityType bdType, IFormView view, CloseCallBack closeCallBack) {
        ListShowParameter para = null;
        para = ShowFormHelper.createShowListForm((String)bdType.getName(), (boolean)false);
        if (para == null) {
            return;
        }
        para.setCloseCallBack(closeCallBack);
        QFilter filter = null;
        if (StringUtils.isNotBlank((CharSequence)bdType.getBillStatus())) {
            filter = new QFilter(bdType.getBillStatus(), "=", (Object)BillStatus.C);
        }
        if (bdType.getProperties().containsKey((Object)"enable")) {
            QFilter forbidFilter = new QFilter("enable", "=", (Object)"1");
            if (filter == null) {
                filter = forbidFilter;
            } else {
                filter.and(forbidFilter);
            }
        }
        if (filter != null) {
            para.getListFilterParameter().getQFilters().add(filter);
        }
        view.showForm((FormShowParameter)para);
    }

    public static String getColFullName(MainEntityType entity, String col) {
        if (StringUtils.isBlank((CharSequence)col)) {
            return null;
        }
        if ("id".equals(col)) {
            return "\u5355\u636e\u5934.\u5185\u7801(id)";
        }
        String[] proCols = col.split("\\.");
        IDataEntityProperty pro = entity.findProperty(proCols[0]);
        if (pro == null) {
            return EntityUtil.notExistCol(col);
        }
        StringBuilder name = new StringBuilder(EntityUtil.getFullName(pro.getParent(), EntityUtil.getLocaleStringValue(pro.getDisplayName())));
        if (proCols.length > 1) {
            BasedataProp basePro = null;
            for (int i = 1; i < proCols.length && pro instanceof BasedataProp; ++i) {
                basePro = (BasedataProp)pro;
                MainEntityType type = MetadataServiceHelper.getDataEntityType((String)basePro.getBaseEntityId());
                pro = type.findProperty(proCols[i]);
                String subName = null;
                subName = pro.getDisplayName() == null ? ("id".equals(pro.getName()) ? "\u5185\u7801" : "") : pro.getDisplayName().getLocaleValue();
                name.append('.').append(subName);
            }
        }
        return name.toString();
    }

    public static String getColFullId(MainEntityType entity, String col) {
        if (StringUtils.isBlank((CharSequence)col)) {
            return null;
        }
        String[] proCols = col.split("\\.");
        IDataEntityProperty pro = entity.findProperty(proCols[0]);
        if (pro == null) {
            return EntityUtil.notExistCol(col);
        }
        if (pro.getParent() instanceof MainEntityType) {
            return col;
        }
        return EntityUtil.getColFullId(entity, pro.getParent().getName()) + "." + col;
    }

    public static final Map<String, IDataEntityProperty> getEntityAllFields(String formId) {
        MainEntityType mainEntityType = EntityUtil.getMainEntityType(formId);
        return mainEntityType.getAllFields();
    }

    public static final List<IDataEntityProperty> getEntityAllDefinedField(String formId) {
        return EntityUtil.getEntityAllFields(formId).entrySet().stream().filter(v -> !(((IDataEntityProperty)v.getValue()).getParent() instanceof LinkEntryType)).map(v -> (IDataEntityProperty)v.getValue()).collect(Collectors.toList());
    }

    public static String notExistCol(String col) {
        return String.format("\u5b57\u6bb5\u3010%s\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u5220\u9664", col);
    }

    private static String getFullName(IDataEntityType parent, String colName) {
        return parent instanceof MainEntityType ? colName : EntityUtil.getFullName(parent.getParent(), EntityUtil.getLocaleStringValue(parent.getDisplayName()) + "." + colName);
    }

    private static final String getLocaleStringValue(LocaleString localeString) {
        return localeString == null ? "" : localeString.getLocaleValue();
    }

    public static final ConditionReceiveValue receiveValByCondition(String formId, String json) {
        if (StringUtils.isNotEmpty((CharSequence)json)) {
            CRValByConditions valByConditions = (CRValByConditions)SerializationUtils.fromJsonString((String)json, CRValByConditions.class);
            List items = valByConditions.getItems();
            long count = items.stream().filter(obj -> obj.getCondition() != null && StringUtils.isNotEmpty((CharSequence)obj.getCondition().getExpression())).count();
            if (count > 0L) {
                throw new KDBizException("\u6309\u6761\u4ef6\u53d6\u503c\u6682\u65f6\u4e0d\u652f\u6301\u9ad8\u7ea7\u6761\u4ef6\u8bbe\u7f6e\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002");
            }
            JSONArray jsonArray = new JSONArray(items.size());
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formId);
            for (CRValByCondition crvCondition : items) {
                String formulaExpression = crvCondition.getFormula() != null ? crvCondition.getFormula().getExpression() : null;
                CRCondition condition = crvCondition.getCondition();
                if (!StringUtils.isNotEmpty((CharSequence)formulaExpression) || condition == null) continue;
                JSONObject jsonObj = new JSONObject();
                QFilter filter = EntityUtil.translateInfoSqlFilter(formId, condition.getFilterCondition());
                jsonObj.put(PARAM_FILTER, (Object)filter);
                jsonObj.put(PARAM_FILTERSTR, (Object)condition.buildFullFormula(mainEntityType));
                jsonObj.put(PARAM_FORMULA, (Object)formulaExpression);
                jsonObj.put(PARAM_IFCONSTANT, (Object)crvCondition.getIfconstant());
                jsonArray.add((Object)jsonObj);
            }
            if (!jsonArray.isEmpty()) {
                return new ConditionReceiveValue(json, valByConditions.getDescription(), jsonArray.toJSONString());
            }
        }
        return null;
    }

    public static final QFilter translateInfoSqlFilter(String dataEntityType, String filter) {
        if (StringUtils.isEmpty((CharSequence)dataEntityType) || StringUtils.isEmpty((CharSequence)filter)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
        return EntityUtil.translateInfoSqlFilter(dataEntityType, filterCondition);
    }

    public static final QFilter translateInfoSqlFilter(String dataEntityType, FilterCondition filterCondition) {
        if (StringUtils.isEmpty((CharSequence)dataEntityType) || filterCondition == null) {
            return null;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)dataEntityType);
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        filterBuilder.setUserService((IUserService)new UserService());
        filterBuilder.buildFilter(false);
        return filterBuilder.getQFilter();
    }

    public static class ComboToJsonSerializer {
        private List<ValueMapItem> items = new ArrayList<ValueMapItem>(16);

        @CollectionPropertyAttribute(collectionItemPropertyType=ValueMapItem.class)
        public List<ValueMapItem> getItems() {
            return this.items;
        }

        public void setItems(List<ValueMapItem> items) {
            this.items = items;
        }
    }
}

