/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.impl.RequestContextRunnable;
import kd.mpscmm.msrcs.common.model.TaskResult;
import kd.mpscmm.msrcs.engine.common.TaskStatusManager;
import kd.mpscmm.msrcs.engine.enginer.RebateEnginerFactory;
import kd.mpscmm.msrcs.engine.enginer.RebateTaskInfo;
import kd.mpscmm.msrcs.engine.logger.RebateLogger;
import kd.mpscmm.msrcs.engine.logger.RebateSubTaskLogger;

public class RebateEngine {
    private static Log logger = LogFactory.getLog(RebateEngine.class);
    private String rebateName;
    List<RebateTaskInfo> taskList = new ArrayList<RebateTaskInfo>();
    private List<Future> futures = new ArrayList<Future>();
    private RebateLogger rebateLogger = new RebateLogger();
    AtomicInteger index = new AtomicInteger(1);

    public static final RebateEngine get(String rebateName) {
        String taskId = RequestContext.get().getTraceId();
        RebateEngine rebateEngine = new RebateEngine();
        rebateEngine.rebateLogger.readyTask(taskId, "A", "\u8fdb\u5165\u8ba1\u7b97");
        if (RebateEngine.isRun(rebateName)) {
            rebateEngine.rebateLogger.setTaskError("\u540e\u53f0\u6b63\u5728\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5\u3002");
            throw new KDBizException("\u540e\u53f0\u6b63\u5728\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5\u3002");
        }
        TaskStatusManager.readyRun(rebateName);
        rebateEngine.rebateName = rebateName;
        return rebateEngine;
    }

    public static final boolean isRun(String rebateName) {
        return TaskStatusManager.isRun(rebateName);
    }

    public final void addTask(RebateTaskInfo rebateCalcTaskInfo) {
        this.taskList.add(rebateCalcTaskInfo);
    }

    public final void run() {
        ExecutorService mainExecutorService = Executors.newFixedThreadPool(1);
        final String taskId = RequestContext.get().getTraceId();
        logger.info(taskId + " rebate: engine is ready: taskSize(" + this.taskList.size() + ")");
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long beginTiem = TimeServiceHelper.getTimeStamp();
                logger.info(taskId + " rebate: engine is begin ");
                try {
                    RebateEngine.this.rebateLogger.setTotalCount(RebateEngine.this.taskList.size());
                    RebateEngine.this.runSub(taskId);
                }
                catch (Exception e) {
                    logger.error(taskId + " rebate: engine is running exception:" + e.getMessage());
                }
                finally {
                    TaskStatusManager.reset(RebateEngine.this.rebateName);
                }
                logger.info(taskId + " rebate: engine is end,cost: " + (TimeServiceHelper.getTimeStamp() - beginTiem));
            }
        };
        runnable = new RequestContextRunnable(runnable, RequestContextCreator.createForThreadPool());
        runnable = ThreadLifeCycleManager.wrapRunnable((Runnable)runnable);
        mainExecutorService.execute(runnable);
        mainExecutorService.shutdown();
    }

    private void runSub(final String mainTaskId) {
        this.rebateLogger.appendDesc("\u4efb\u52a1\u51c6\u5907\u4e2d");
        ExecutorService subExecutorService = Executors.newFixedThreadPool(10);
        for (final RebateTaskInfo rebateTaskInfo : this.taskList) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TaskStatusManager.setRun(RebateEngine.this.rebateName);
                    logger.info(mainTaskId + " rebate: engine sub is running ,idx = " + RebateEngine.this.index.get());
                    rebateTaskInfo.setMainTaskid(mainTaskId);
                    rebateTaskInfo.setTaskId(RequestContext.get().getTraceId());
                    RebateSubTaskLogger.batchAddNewLog(mainTaskId, rebateTaskInfo.getTaskId(), rebateTaskInfo);
                    try {
                        RebateEnginerFactory.get().execute(rebateTaskInfo);
                    }
                    catch (Exception e) {
                        RebateSubTaskLogger.batchUpdateLogForTermination(mainTaskId, rebateTaskInfo.getTaskId(), "\u521d\u59cb\u5316\u8f93\u5165\u6761\u4ef6\u65f6\u51fa\u9519", e);
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    RebateSubTaskLogger.upbateSuccessIfIsReadyForEnd(mainTaskId, rebateTaskInfo.getTaskId(), "\u65e0\u6ee1\u8db3\u6761\u4ef6\u7684\u8bb0\u5f55");
                    logger.info(mainTaskId + " rebate: engine sub is end ,idx = " + RebateEngine.this.index.get());
                }
            };
            runnable = new RequestContextRunnable(runnable, RequestContextCreator.createForThreadPool());
            runnable = ThreadLifeCycleManager.wrapRunnable((Runnable)runnable);
            Future future = subExecutorService.submit(runnable);
            this.futures.add(future);
            this.index.incrementAndGet();
        }
        this.rebateLogger.appendDesc("\u4efb\u52a1\u51c6\u5907\u5b8c\u6210");
        StringBuilder errorMsg = new StringBuilder(10);
        subExecutorService.shutdown();
        this.rebateLogger.setTaskRunning("\u4efb\u52a1\u8fd0\u884c\u4e2d");
        logger.info(mainTaskId + " rebate: engine check runstatus begin");
        TaskResult taskResult = new TaskResult();
        for (Future future : this.futures) {
            try {
                future.get();
                taskResult.addSuccess();
            }
            catch (Exception e) {
                taskResult.addError(e.getMessage());
                for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                    taskResult.appendErrMsg(stackTraceElement.toString());
                }
                if (errorMsg.length() < 2000) {
                    errorMsg.append(e.getMessage());
                }
                logger.info(mainTaskId + " rebate: isError:" + e.getMessage(), (Object)e);
            }
        }
        if (taskResult.getErrorCount() > 0) {
            this.rebateLogger.setTaskError(taskResult);
        } else {
            this.rebateLogger.setTaskFinish();
        }
    }
}

