/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.engine.algox;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msrcs.engine.algox.RebateAlgoxCtx;
import kd.mpscmm.msrcs.engine.algox.input.InputServiceHelper;
import kd.mpscmm.msrcs.engine.algox.output.OutputHelper;
import kd.mpscmm.msrcs.engine.algox.reduce.DataServiceHelper;
import kd.mpscmm.msrcs.engine.enginer.IRebateEnginer;
import kd.mpscmm.msrcs.engine.enginer.Kpi;
import kd.mpscmm.msrcs.engine.enginer.Ladder;
import kd.mpscmm.msrcs.engine.enginer.RebateTaskInfo;

public class RebateAlgoxEnginer
implements IRebateEnginer {
    private static Log logger = LogFactory.getLog(RebateAlgoxEnginer.class);
    private RebateTaskInfo rebateCalcTaskInfo;
    private JobSession session;

    public static final RebateAlgoxEnginer get() {
        return new RebateAlgoxEnginer();
    }

    @Override
    public final DataSet execute(RebateTaskInfo rebateCalcTaskInfo) {
        this.init(rebateCalcTaskInfo);
        return this.run();
    }

    private void init(RebateTaskInfo rebateCalcTaskInfo) {
        this.rebateCalcTaskInfo = rebateCalcTaskInfo;
    }

    private DataSet run() {
        this.session = AlgoX.createSession((String)"msrcs_rebateengine", (String)"\u8fd4\u5229\u8ba1\u7b97");
        ArrayList<DataSetX> resultDataSetX = new ArrayList<DataSetX>(2);
        for (Kpi kpi : this.rebateCalcTaskInfo.getKpiList()) {
            for (Ladder ladder : kpi.getLadderList()) {
                StringBuilder bs = new StringBuilder();
                bs.append("rebateLadder:");
                for (String key : ladder.getKeys()) {
                    bs.append("key = ").append(ladder.getBigDecimal(key)).append(",");
                }
                logger.info(bs.toString());
            }
            RebateAlgoxCtx rebateAlgoxCtx = new RebateAlgoxCtx(this.rebateCalcTaskInfo, kpi);
            Input[] inputs = InputServiceHelper.createSourceDataSetx(rebateAlgoxCtx);
            DataSetX dataSetX = this.session.fromInput(inputs);
            dataSetX = DataServiceHelper.reduceData(rebateAlgoxCtx, dataSetX);
            resultDataSetX.add(dataSetX);
        }
        DataSetX retDataSetx = this.merge(resultDataSetX);
        if (retDataSetx == null) {
            return null;
        }
        retDataSetx = retDataSetx.orderBy(new String[]{this.rebateCalcTaskInfo.getRebateObjectFieldId()});
        RebateAlgoxCtx rebateAlgoxCtx = new RebateAlgoxCtx(this.rebateCalcTaskInfo, retDataSetx.getRowMeta());
        Output output = OutputHelper.createOutput(rebateAlgoxCtx);
        retDataSetx.output(output);
        this.session.commit(7200, TimeUnit.SECONDS);
        return null;
    }

    private DataSetX merge(List<DataSetX> sourceDataSetXList) {
        DataSetX retDataSet = null;
        for (DataSetX dataSetX : sourceDataSetXList) {
            if (retDataSet == null) {
                retDataSet = dataSetX;
                continue;
            }
            retDataSet = retDataSet.union(dataSetX);
        }
        return retDataSet;
    }

    private void read(DataSet dataset) {
        while (dataset.hasNext()) {
            Row row = dataset.next();
            row.getBigDecimal("r__result");
        }
    }
}

