/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.engine.algox.input;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msrcs.business.RebateDataSourceServiceHelper;
import kd.mpscmm.msrcs.common.model.CalcFormula;
import kd.mpscmm.msrcs.common.model.CustomField;
import kd.mpscmm.msrcs.common.model.RebateDataSource;
import kd.mpscmm.msrcs.common.model.RebateScheme;
import kd.mpscmm.msrcs.common.util.EntityUtil;
import kd.mpscmm.msrcs.engine.algox.AbstractService;

public class DefaultInputService
extends AbstractService {
    private static Log logger = LogFactory.getLog(DefaultInputService.class);

    public Input[] createInputs() {
        RebateScheme rebateScheme = RebateScheme.getRebateScheme(this.getCtx().getRebateTaskInfo().getRebateSchemeId());
        List<DynamicObject> schemeDataSources = rebateScheme.getSourceBills();
        if (schemeDataSources == null || schemeDataSources.size() == 0) {
            throw new KDBizException("\u8fd4\u5229\u65b9\u6848\u6ca1\u6709\u8bbe\u7f6e\u6e90\u5355\u4fe1\u606f");
        }
        Object[] dataSourcePks = schemeDataSources.stream().map(v -> v.getLong("rebatesource_id")).toArray();
        DynamicObject[] dataSources = RebateDataSourceServiceHelper.getDataSources(dataSourcePks);
        Map<Long, DynamicObject> dataSourceMap = Arrays.stream(dataSources).collect(Collectors.toMap(v -> (Long)v.getPkValue(), v -> v));
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(schemeDataSources.size());
        for (DynamicObject schemeDataSource : schemeDataSources) {
            RebateDataSource rebateDataSource;
            DynamicObjectCollection properties;
            DynamicObject dataSourceBill = dataSourceMap.get(schemeDataSource.getLong("rebatesource_Id"));
            if (dataSourceBill == null || (properties = (rebateDataSource = new RebateDataSource(dataSourceBill)).getDataSourceBotpProperties()) == null || properties.isEmpty()) continue;
            String sourceEntityId = rebateDataSource.getSourceBillEntityId();
            MainEntityType sourceEntityType = EntityUtil.getMainEntityType(sourceEntityId);
            StringBuilder selectFields = new StringBuilder(50);
            Map _sourceEntityAllFields = sourceEntityType.getAllFields();
            for (DynamicObject property : properties) {
                String originalSourcePropertyId = rebateDataSource.getBotpSourcePropertyId(property);
                String sourcePropertyId = EntityUtil.getColFullId(sourceEntityType, originalSourcePropertyId = this.getMasterPropIfIsBasedata(_sourceEntityAllFields, originalSourcePropertyId));
                if (sourcePropertyId == null) continue;
                String rebateModelPropertyId = rebateDataSource.getBotpRebateModelPropertyId(property);
                selectFields.append(sourcePropertyId).append(" as ").append(rebateModelPropertyId).append(",");
            }
            selectFields.deleteCharAt(selectFields.length() - 1);
            logger.info("rebate,input's selectFields:" + selectFields);
            StringBuilder moreDefaultSelectBuilder = new StringBuilder(10);
            RowMeta rowMeta = this.createRowMeta(sourceEntityId, selectFields, moreDefaultSelectBuilder);
            selectFields = selectFields.append((CharSequence)moreDefaultSelectBuilder);
            OrmInput ormInput = new OrmInput("msrcs_rebate_input" + sourceEntityId, sourceEntityId, selectFields.toString(), this.getQFilter(rebateDataSource, schemeDataSource), rowMeta);
            inputs.add(ormInput);
        }
        return inputs.toArray(new Input[inputs.size()]);
    }

    private void addBasedataDisplayProp(MainEntityType rebateModelMainEntityType, MainEntityType sourceEntityType, String rebateModelPropertyId, String originalSourcePropertyId, String sourcePropertyId, StringBuilder selectFields) {
        IDataEntityProperty sourceField;
        IDataEntityProperty rebateModelField = (IDataEntityProperty)rebateModelMainEntityType.getAllFields().get(rebateModelPropertyId);
        if (rebateModelField instanceof BasedataProp && (sourceField = (IDataEntityProperty)sourceEntityType.getAllFields().get(originalSourcePropertyId)) instanceof BasedataProp) {
            selectFields.append(sourcePropertyId).append(".").append(((BasedataProp)sourceField).getDisplayProp()).append(" as ").append(rebateModelPropertyId).append("__name").append(",");
        }
    }

    private RowMeta createRowMeta(String sourceEntityId, StringBuilder selectFields, StringBuilder moreSelectFieldBuilder) {
        RowMeta oldRowMeta = ORM.create().createRowMeta(sourceEntityId, selectFields.toString());
        List<Field> fieldList = Arrays.stream(oldRowMeta.getFields()).collect(Collectors.toList());
        List<Object> moreFieldKeyList = new ArrayList<String>();
        CalcFormula calcFormula = CalcFormula.init(this.getCtx().getRebateTaskInfo().getJudgeBasisId(), this.getCtx().getRebateTaskInfo().getRebateCalcFormulaId());
        moreFieldKeyList.addAll(calcFormula.getAllVars());
        moreFieldKeyList.addAll(this.getCtx().getRebateTaskInfo().getFactorEngine().getVars());
        moreFieldKeyList.add(CustomField.getResultKey());
        moreFieldKeyList.add(CustomField.getGroupNoKey());
        moreFieldKeyList = moreFieldKeyList.stream().distinct().collect(Collectors.toList());
        for (String string : moreFieldKeyList) {
            String customKey = CustomField.getKey(string);
            fieldList.add(new Field(customKey, (DataType)DataType.BigDecimalType));
            moreSelectFieldBuilder.append(", 0 as ").append(customKey);
        }
        return new RowMeta(fieldList.toArray(new Field[fieldList.size()]));
    }

    private QFilter[] getQFilter(RebateDataSource rebateDataSource, DynamicObject schemeDataSource) {
        QFilter mainFilter;
        String rebateObjectField = this.getCtx().getRebateTaskInfo().getRebateObjectFieldId();
        Map<String, String> botpPropertiesMap = rebateDataSource.getDataSourceBotpPropertyMap();
        List rebateObjectIds = this.getCtx().getRebateTaskInfo().getRebateObjectIds().entrySet().stream().map(v -> Long.parseLong((String)v.getKey())).collect(Collectors.toList());
        String rebateObjectFieldKey = this.getMasterPropIfIsBasedata(MetadataServiceHelper.getDataEntityType((String)rebateDataSource.getSourceBillEntityId()).getAllFields(), botpPropertiesMap.get(rebateObjectField));
        QFilter qfilter = new QFilter(rebateObjectFieldKey, "in", rebateObjectIds);
        QFilter qFilter = mainFilter = this.getCtx().getRebateTaskInfo().getCondition() != null ? this.getCtx().getRebateTaskInfo().getCondition().copy() : null;
        if (mainFilter != null) {
            this.replaceAllQfilter(mainFilter, botpPropertiesMap);
            qfilter.and(mainFilter);
        }
        logger.info("rebate,input pre qfilter:" + (this.getCtx().getKpi().getGroupCondition() != null ? this.getCtx().getKpi().getGroupCondition().toString() : ""));
        if (this.getCtx().getKpi().getGroupCondition() != null) {
            QFilter groupNoFilter = this.getCtx().getKpi().getGroupCondition().copy();
            this.replaceAllQfilter(groupNoFilter, botpPropertiesMap);
            qfilter.and(groupNoFilter);
        }
        logger.info("rebate,input qfilter:" + qfilter.toString());
        String qFilterStr = schemeDataSource.getString("qfitlerstr_tag");
        if (StringUtils.isNotEmpty((String)qFilterStr)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)qFilterStr, CRCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(MetadataServiceHelper.getDataEntityType((String)rebateDataSource.getSourceBillEntityId()), condition.getFilterCondition());
            filterBuilder.buildFilter();
            QFilter dataSourceFilter = filterBuilder.getQFilter();
            if (dataSourceFilter != null) {
                qfilter.and(dataSourceFilter);
            }
        }
        return qfilter.toArray();
    }

    private void replaceAllQfilter(QFilter qfilter, Map<String, String> botpPropertiesMap) {
        this._replaceAllQfilter(qfilter, botpPropertiesMap);
        Iterator iterator = qfilter.getNests(false).iterator();
        while (iterator.hasNext()) {
            this._replaceAllQfilter(((QFilter.QFilterNest)iterator.next()).getFilter(), botpPropertiesMap);
        }
    }

    private void _replaceAllQfilter(QFilter qfilter, Map<String, String> botpPropertiesMap) {
        String destProperty;
        String qfilterProperty = qfilter.getProperty();
        String childProperty = "";
        if (qfilterProperty.contains(".")) {
            childProperty = qfilterProperty.substring(qfilterProperty.indexOf("."));
            qfilterProperty = qfilterProperty.split("\\.")[0];
        }
        if (StringUtil.isNotEmpty((String)(destProperty = botpPropertiesMap.get(qfilterProperty)))) {
            qfilter.__setProperty(destProperty + childProperty);
        }
    }

    private String getMasterPropIfIsBasedata(Map<String, IDataEntityProperty> _sourceEntityAllFields, String fieldKey) {
        IDataEntityProperty dataEntityProperty = _sourceEntityAllFields.get(fieldKey);
        if (dataEntityProperty == null || !(dataEntityProperty instanceof BasedataProp)) {
            return fieldKey;
        }
        String baseEntityId = ((BasedataProp)dataEntityProperty).getBaseEntityId();
        if (!BaseDataServiceHelper.checkBaseDataCtrl((String)baseEntityId).booleanValue()) {
            return fieldKey;
        }
        String masterIdProp = BaseDataServiceHelper.getMasterIdPropName((String)baseEntityId);
        if (!StringUtils.isEmpty((String)masterIdProp)) {
            return fieldKey + "." + masterIdProp;
        }
        return fieldKey;
    }
}

