/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.engine.algox.output;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.CustomizedOutput;
import kd.bos.algo.RowMeta;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msrcs.common.model.CustomField;
import kd.mpscmm.msrcs.engine.algox.RebateAlgoxCtx;
import kd.mpscmm.msrcs.engine.output.RebateOutputEngine;

public class DefaultOutputService
implements CustomizedOutput {
    private static Log logger = LogFactory.getLog(DefaultOutputService.class);
    private Object currentGroupObject = null;
    private List<Object[]> groupObjects = new ArrayList<Object[]>(10);
    private int groupObjectIndex = -1;
    private Set<String> hasDataGroupObject = new HashSet<String>();
    private StringBuffer errorInfo = new StringBuffer(100);
    private RebateAlgoxCtx ctx;

    public DefaultOutputService(RebateAlgoxCtx ctx) {
        this.ctx = ctx;
    }

    public void open() {
        logger.info("OutputOpen");
        this.groupObjectIndex = this.ctx.getRowMeta().getFieldIndex(this.ctx.getMainDim());
    }

    public void write(Object[] objects) {
        if (objects == null || this.groupObjectIndex == -1) {
            return;
        }
        logger.info("OutputWriteReady");
        Object nextData = objects[this.groupObjectIndex];
        if (this.currentGroupObject == null) {
            this.currentGroupObject = nextData;
            this.hasDataGroupObject.add(nextData.toString());
        }
        if (this.currentGroupObject.equals(nextData)) {
            int fieldIndex = this.ctx.getRowMeta().getFieldIndex(CustomField.getKey(CustomField.getResultKey()));
            if (CustomField.isMatchSucess((BigDecimal)objects[fieldIndex])) {
                this.groupObjects.add(objects);
            }
        } else {
            this.out();
            this.groupObjects.clear();
            this.groupObjects.add(objects);
            this.currentGroupObject = nextData;
            this.hasDataGroupObject.add(nextData.toString());
        }
    }

    public void close() {
        if (this.currentGroupObject != null) {
            this.out();
            this.outNoData();
            this.throwErrorIfHas();
        }
    }

    private void out() {
        this.out(this.currentGroupObject, this.groupObjects);
    }

    private void out(Object currentGroupObject, List<Object[]> groupObjects) {
        logger.info("OutputWrite:" + groupObjects.size());
        RebateOutputEngine rebateOutputEngine = new RebateOutputEngine(this.getCtx().getRebateTaskInfo(), currentGroupObject, this.getRowMeta());
        rebateOutputEngine.setCalcResultObjects(groupObjects);
        OperationResult operationResult = rebateOutputEngine.out();
        if (operationResult != null && !operationResult.isSuccess()) {
            this.errorInfo.append("targetN:").append(rebateOutputEngine.getRebateTargetBillno());
            this.appdneResult(operationResult, this.errorInfo);
            this.errorInfo.append("\n");
        }
    }

    private void outNoData() {
        for (Map.Entry<String, Long> srcTargets : this.ctx.getRebateTaskInfo().getRebateObjectIds().entrySet()) {
            if (this.hasDataGroupObject.contains(srcTargets.getKey())) continue;
            this.out(srcTargets.getKey(), new ArrayList<Object[]>());
        }
    }

    public RowMeta getRowMeta() {
        return this.ctx.getRowMeta();
    }

    public boolean isSingleParallel() {
        return false;
    }

    private void throwErrorIfHas() {
        if (this.errorInfo.length() == 0) {
            return;
        }
        throw new KDBizException(this.errorInfo.toString());
    }

    private void appdneResult(OperationResult operationResult, StringBuffer result) {
        if (!operationResult.isSuccess()) {
            List errorInfos = operationResult.getAllErrorOrValidateInfo();
            result.append((String)operationResult.getBillNos().get("0")).append(":\n");
            for (IOperateInfo errorInfo : errorInfos) {
                result.append(errorInfo.getMessage()).append("\n");
            }
        }
    }

    public RebateAlgoxCtx getCtx() {
        return this.ctx;
    }
}

