/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.engine.algox.reduce;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.mpscmm.msrcs.common.model.CalcFormula;
import kd.mpscmm.msrcs.common.model.CustomField;
import kd.mpscmm.msrcs.common.model.Factor;
import kd.mpscmm.msrcs.common.model.PolicyParser;
import kd.mpscmm.msrcs.engine.algox.RebateAlgoxCtx;
import kd.mpscmm.msrcs.engine.common.FactorEngine;
import kd.mpscmm.msrcs.engine.enginer.Kpi;
import kd.mpscmm.msrcs.engine.logger.RebateSubTaskLogger;
import kd.sdk.mpscmm.msrcs.formula.FormulaData;

public class LadderReduceGroupFunc
extends GroupReduceFunction {
    private static final long serialVersionUID = -4503267073992488423L;
    private RowMeta rowMeta;
    private Kpi kpi;
    private String mainDim;
    private FactorEngine factorEngine;
    private RebateAlgoxCtx ctx;

    public LadderReduceGroupFunc(RebateAlgoxCtx ctx) {
        this.ctx = ctx;
        this.rowMeta = ctx.getRowMeta();
        this.kpi = ctx.getKpi();
        this.factorEngine = ctx.getRebateTaskInfo().getFactorEngine();
        this.mainDim = ctx.getMainDim();
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList<RowX> copy = new ArrayList<RowX>();
        this.factorEngine.setRowMeta(this.rowMeta);
        this.factorEngine.setMainDim(this.mainDim);
        for (RowX rowX : iterable) {
            this.factorEngine.calc(rowX);
            copy.add(rowX);
        }
        List<Factor> factorList = this.factorEngine.getFactors();
        if (factorList != null && factorList.size() > 0) {
            for (Factor factor : factorList) {
                if (factor.getPluginInstance() == null) continue;
                factor.getPluginInstance().afterCalculate((Object)this.getCtx(), (Object)factor);
            }
        }
        CalcFormula calcFormula = CalcFormula.init(this.getCtx().getRebateTaskInfo().getJudgeBasisId(), this.getCtx().getRebateTaskInfo().getRebateCalcFormulaId());
        ArrayList<String> allVars = new ArrayList<String>();
        allVars.addAll(calcFormula.getAllVars());
        PolicyParser policyParser = new PolicyParser(this.ctx.getRebateTaskInfo().getPolicyParseObject());
        List<FormulaData> destFormulData = policyParser.mapTargetFormDataToLadder(allVars, this.ctx.getKpi().getLadderList(), this.getKpi().getLadderIdentifier());
        RebateSubTaskLogger rebateSubTaskLogger = RebateSubTaskLogger.getLogger(this.getCtx().getRebateTaskInfo(), this.rowMeta);
        int maxSize = copy.size();
        for (int i = 0; i < maxSize; ++i) {
            RowX rowx = (RowX)copy.get(i);
            boolean isOk = false;
            Map<String, BigDecimal> factorMap = this.factorEngine.getValueMap(rowx);
            FormulaData successFormulaData = null;
            for (FormulaData formulaData : destFormulData) {
                formulaData.putAll(factorMap);
                isOk = calcFormula.getLadder().compare((Object)formulaData);
                if (!isOk) continue;
                successFormulaData = formulaData;
                break;
            }
            if (isOk) {
                this.writeFormulaDataToRowX(rowx, successFormulaData);
                this.setCustomValue(rowx, CustomField.getResultKey(), BigDecimal.ONE);
            } else {
                this.setCustomValue(rowx, CustomField.getResultKey(), BigDecimal.ZERO);
            }
            this.setCustomValue(rowx, CustomField.getGroupNoKey(), BigDecimal.valueOf(this.getKpi().getGroupNo().intValue()));
            collector.collect(rowx);
            rebateSubTaskLogger.record(rowx, isOk);
        }
        rebateSubTaskLogger.commitRecord();
    }

    private void writeFormulaDataToRowX(RowX rowx, FormulaData formulaData) {
        for (Map.Entry data : formulaData.entrySet()) {
            this.setCustomValue(rowx, (String)data.getKey(), data.getValue());
        }
    }

    private void setCustomValue(RowX rowx, String field, Object value) {
        int fieldIndex = this.getResultRowMeta().getFieldIndex(CustomField.getKey(field));
        rowx.set(fieldIndex, value);
    }

    public RebateAlgoxCtx getCtx() {
        return this.ctx;
    }

    public Kpi getKpi() {
        return this.kpi;
    }
}

