/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.engine.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.mpscmm.msrcs.common.model.Factor;

public class FactorEngine
implements Serializable {
    private Map<String, Factor> factorsMap;
    private Map<String, String> varMapFactorSet;
    private RowMeta rowMeta;
    private String mainDim;

    public FactorEngine(List<Factor> factors, List<DynamicObject> varMapSetting) {
        this.factorsMap = factors.stream().collect(Collectors.toMap(v -> v.getPkValue().toString(), v -> v));
        this.varMapFactorSet = varMapSetting.stream().collect(Collectors.toMap(v -> v.getString("varcol").toLowerCase(), v -> v.getString("sourcecolid")));
    }

    public void calc(RowX rowData) {
        for (Map.Entry<String, Factor> factorSet : this.factorsMap.entrySet()) {
            Factor factor = factorSet.getValue();
            HashMap<String, Object> expFieldValueMap = new HashMap<String, Object>();
            String[] expFields = factor.getExpFields();
            if (expFields != null && expFields.length > 0) {
                for (String expField : expFields) {
                    int fieldIndex = this.rowMeta.getFieldIndex(factor.getExp());
                    expFieldValueMap.put(expField, rowData.get(fieldIndex));
                }
            }
            List<Object> dimValues = this.getDimValues(factor.getSpecDim(), rowData);
            factor.calc(dimValues, expFieldValueMap);
        }
    }

    public Map<String, BigDecimal> getValueMap(RowX rowData) {
        HashMap<String, BigDecimal> factorValMaps = new HashMap<String, BigDecimal>(500);
        for (Map.Entry<String, String> varMapFactor : this.varMapFactorSet.entrySet()) {
            String var = varMapFactor.getKey();
            Factor factor = this.factorsMap.get(varMapFactor.getValue());
            List<Object> dimValues = this.getDimValues(factor.getSpecDim(), rowData);
            factorValMaps.put(var, factor.getValue(dimValues));
        }
        return factorValMaps;
    }

    private String[] getDims(String specDim) {
        if (StringUtils.isNotEmpty((String)specDim)) {
            return specDim.split(",");
        }
        return this.mainDim.split(",");
    }

    private List<Object> getDimValues(String specDim, RowX rowData) {
        String[] dims = this.getDims(specDim);
        return this.getDimValues(dims, rowData);
    }

    private List<Object> getDimValues(String[] dims, RowX rowData) {
        ArrayList<Object> values = new ArrayList<Object>(dims.length);
        for (String dim : dims) {
            int dimFieldIndex = this.rowMeta.getFieldIndex(dim);
            values.add(rowData.get(dimFieldIndex));
        }
        return values;
    }

    public List<String> getVars() {
        return this.varMapFactorSet.keySet().stream().collect(Collectors.toList());
    }

    public List<Factor> getFactors() {
        return this.factorsMap.values().stream().collect(Collectors.toList());
    }

    public Map<String, Factor> getFactorMap() {
        return this.factorsMap;
    }

    public void setFactors(Map<String, Factor> factors) {
        this.factorsMap = factors;
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public void setRowMeta(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public String getMainDim() {
        return this.mainDim;
    }

    public void setMainDim(String mainDim) {
        this.mainDim = mainDim;
    }
}

