/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.engine.enginer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msrcs.business.RebateClassServiceHelper;
import kd.mpscmm.msrcs.business.RebateFactorServiceHelper;
import kd.mpscmm.msrcs.business.policyparserule.PolicyParseRuleHelper;
import kd.mpscmm.msrcs.common.model.Factor;
import kd.mpscmm.msrcs.common.model.PolicyParser;
import kd.mpscmm.msrcs.common.model.RebateClass;
import kd.mpscmm.msrcs.engine.common.FactorEngine;
import kd.mpscmm.msrcs.engine.enginer.Kpi;

public class RebateTaskInfo
implements Serializable {
    private String taskId;
    private long _rebateSchemeId;
    private String rebateTargetFormId;
    private long judgeBasisId;
    private long rebateCalcFormulaId;
    private long rebateClassId;
    private String _rebateObjectFieldId;
    private FactorEngine _factorEnginer;
    private List<Kpi> kpiList;
    private long currencyId;
    private DynamicObject _currency;
    private QFilter condition;
    private Map<String, Long> rebateObjectIds = new HashMap<String, Long>();
    private String mainTaskid;

    public static final RebateTaskInfo newInstance(String rebateTargetFormId, QFilter condition, long rebateClassId, long judgeBasisId, long rebateCalcFormulaId, long currencyId) {
        RebateTaskInfo rebateCalcTaskInfo = new RebateTaskInfo();
        rebateCalcTaskInfo.setCondition(condition);
        rebateCalcTaskInfo.setRebateClassId(rebateClassId);
        rebateCalcTaskInfo.setJudgeBasisId(judgeBasisId);
        rebateCalcTaskInfo.setRebateCalcFormulaId(rebateCalcFormulaId);
        rebateCalcTaskInfo.setRebateClassId(rebateClassId);
        rebateCalcTaskInfo.setRebateTargetFormId(rebateTargetFormId);
        rebateCalcTaskInfo.currencyId = currencyId;
        return rebateCalcTaskInfo;
    }

    public Map<String, Long> getRebateObjectIds() {
        return this.rebateObjectIds;
    }

    public void setRebateObjectIds(Map<String, Long> rebateObjectIds) {
        this.rebateObjectIds = rebateObjectIds;
        this.init();
    }

    public long getRebateSchemeId() {
        return this._rebateSchemeId;
    }

    public List<Kpi> getKpiList() {
        return this.kpiList;
    }

    public void setKpiList(List<Kpi> kpiList) {
        this.kpiList = kpiList;
    }

    public QFilter getCondition() {
        return this.condition;
    }

    public void setCondition(QFilter condition) {
        this.condition = condition;
    }

    public Long getRebateClassId() {
        return this.rebateClassId;
    }

    public void setRebateClassId(Long rebateClassId) {
        this.rebateClassId = rebateClassId;
    }

    public String getRebateTargetFormId() {
        return this.rebateTargetFormId;
    }

    public void setRebateTargetFormId(String rebateTargetFormId) {
        this.rebateTargetFormId = rebateTargetFormId;
    }

    public final String getRebateObjectFieldId() {
        return this._rebateObjectFieldId;
    }

    private void init() {
        if (this.rebateObjectIds == null || this.rebateObjectIds.isEmpty()) {
            return;
        }
        DynamicObject dataObject = this.getPolicyParseObject();
        PolicyParser policyParser = new PolicyParser(dataObject);
        if (this._factorEnginer == null) {
            List<DynamicObject> calcFactorList = policyParser.getCalcFactorList();
            Object[] factorPks = calcFactorList.stream().map(v -> Long.parseLong(v.getString("sourcecolid"))).toArray();
            List<Factor> factors = RebateFactorServiceHelper.getFactorList(factorPks);
            this._factorEnginer = new FactorEngine(factors, calcFactorList);
        }
        this._rebateSchemeId = policyParser.getRebateSchemeId();
    }

    public FactorEngine getFactorEngine() {
        return this._factorEnginer;
    }

    public final DynamicObject getPolicyParseObject() {
        if (this.rebateObjectIds == null) {
            return null;
        }
        return PolicyParseRuleHelper.getPolicParseData(this.rebateObjectIds.entrySet().iterator().next().getValue());
    }

    public final long getJudgeBasisId() {
        return this.judgeBasisId;
    }

    public void setJudgeBasisId(long judgeBasisId) {
        this.judgeBasisId = judgeBasisId;
    }

    public final long getRebateCalcFormulaId() {
        return this.rebateCalcFormulaId;
    }

    public void setRebateCalcFormulaId(long rebateCalcFormulaId) {
        this.rebateCalcFormulaId = rebateCalcFormulaId;
    }

    public void setRebateClassId(long rebateClassId) {
        this.rebateClassId = rebateClassId;
        RebateClass rebateClass = new RebateClass(RebateClassServiceHelper.getRebateClass(rebateClassId));
        this._rebateObjectFieldId = rebateClass.getRebateObjectFieldId();
    }

    public DynamicObject getCurrency() {
        if (this._currency == null) {
            this._currency = BusinessDataServiceHelper.loadSingle((Object)this.currencyId, (String)"bd_currency");
        }
        return this._currency;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getMainTaskid() {
        return this.mainTaskid;
    }

    public void setMainTaskid(String mainTaskid) {
        this.mainTaskid = mainTaskid;
    }
}

