/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.engine.formula.calculator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.sdk.mpscmm.msrcs.formula.AbstractCalculator;
import kd.sdk.mpscmm.msrcs.formula.FormulaData;
import kd.sdk.mpscmm.msrcs.formula.TotalAmount;

public class FixAmountCalculator
extends AbstractCalculator {
    private static final long serialVersionUID = 4697754702098294485L;
    private static final String VAR_FIXEDAMOUNT = "fixedrebate";
    private static final String VAR_AMOUNT = "lineamount";

    public boolean isEnableTailCalc() {
        return true;
    }

    public String getAmountVar() {
        return VAR_AMOUNT;
    }

    public BigDecimal calcTotalRebateAmount(Object formulaData, Object totalAmount) {
        FormulaData data = (FormulaData)formulaData;
        return data.get((Object)VAR_FIXEDAMOUNT);
    }

    public boolean isCanCalculate(Object formulaData, Object totalAmount) {
        FormulaData data = (FormulaData)formulaData;
        BigDecimal amount = data.get((Object)VAR_AMOUNT);
        if (amount.compareTo(BigDecimal.ZERO) <= 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public BigDecimal calculate(Object formulaData, Object totalAmount) {
        BigDecimal amount;
        FormulaData data = (FormulaData)formulaData;
        TotalAmount tAmount = (TotalAmount)totalAmount;
        BigDecimal fixedAmount = data.get((Object)VAR_FIXEDAMOUNT) == null ? BigDecimal.ZERO : data.get((Object)VAR_FIXEDAMOUNT);
        BigDecimal bigDecimal = amount = data.get((Object)VAR_AMOUNT) == null ? BigDecimal.ZERO : data.get((Object)VAR_AMOUNT);
        if (!this.isCanCalculate(formulaData, totalAmount)) {
            return BigDecimal.ZERO;
        }
        BigDecimal rebateAmount = fixedAmount.multiply(amount.divide(tAmount.getTotalAmountForPositive(), RoundingMode.HALF_UP)).setScale(data.getAmtPrecision(), RoundingMode.HALF_UP);
        return rebateAmount;
    }

    public String[] initVar() {
        return new String[]{VAR_FIXEDAMOUNT, VAR_AMOUNT};
    }
}

