/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.engine.logger;

import java.io.Serializable;
import java.text.MessageFormat;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msrcs.business.logger.RebateLoggerServiceHelper;
import kd.mpscmm.msrcs.common.model.TaskResult;

public class RebateLogger
implements Serializable {
    private String taskNo;
    private String opType;
    private DynamicObject mainTaskInfo;

    public void readyTask(String taskNo, String opType, String desc) {
        this.taskNo = taskNo;
        this.opType = opType;
        this.mainTaskInfo = RebateLoggerServiceHelper.createNewTask(taskNo, opType, desc);
    }

    public void setTaskRunning(String msg) {
        this._setStatus("B", msg);
    }

    public void setTaskError(TaskResult taskResult) {
        this.mainTaskInfo.set("failcount", (Object)taskResult.getErrorCount());
        String errorMsg = MessageFormat.format("\u6709\u9519\u8bef\uff0c\u5171\u6709{0}\u4e2a\u4efb\u52a1\u51fa\u9519\uff0c\n \u51fa\u9519\u4fe1\u606f{1}", taskResult.getErrorCount(), taskResult.getErrMsg());
        this.setTaskError(errorMsg);
    }

    public void setTaskError(String errorMsg) {
        this._setStatus("C", errorMsg);
    }

    public void setTaskFinish() {
        this._setStatus("Z", "\u8fd0\u884c\u7ed3\u675f");
    }

    public void setTotalCount(int totalCount) {
        this.mainTaskInfo.set("taskcount", (Object)totalCount);
        this.appendDesc(MessageFormat.format("\u603b\u5171\u6709{0}\u4e2a\u8ba1\u7b97\u4efb\u52a1", totalCount));
    }

    public void appendDesc(String desc) {
        this._appendDesc(desc);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.mainTaskInfo});
    }

    public void _appendDesc(String desc) {
        if (desc != null) {
            String now = TimeServiceHelper.formatUserNow();
            this.mainTaskInfo.set("detail", (Object)(this.mainTaskInfo.getString("detail") + "\n" + now + " " + desc));
        }
    }

    private void _setStatus(String status, String msg) {
        this.mainTaskInfo.set("status", (Object)status);
        if (status.equalsIgnoreCase("C") || status.equalsIgnoreCase("Z")) {
            this.mainTaskInfo.set("endtime", (Object)TimeServiceHelper.now());
        }
        this._appendDesc(msg);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.mainTaskInfo});
    }

    public String getTaskNo() {
        return this.taskNo;
    }

    public void setTaskNo(String taskNo) {
        this.taskNo = taskNo;
    }

    public String getOpType() {
        return this.opType;
    }

    public void setOpType(String opType) {
        this.opType = opType;
    }
}

