/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.engine.logger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msrcs.business.logger.RebateLoggerServiceHelper;
import kd.mpscmm.msrcs.common.model.TaskResult;
import kd.mpscmm.msrcs.engine.enginer.RebateTaskInfo;

public class RebateSubTaskLogger {
    private final Map<Long, TaskResult> _resultMap = new HashMap<Long, TaskResult>();
    private int _rebateObjectFieldIndex = -1;
    private RebateTaskInfo _rebateTaskInfo;
    private DynamicObject _logDynamicObject;

    public static final RebateSubTaskLogger getLogger(RebateTaskInfo rebateTaskInfo, RowMeta rowMeta) {
        RebateSubTaskLogger rebateSubTaskLogger = new RebateSubTaskLogger();
        rebateSubTaskLogger._rebateObjectFieldIndex = rowMeta.getFieldIndex(rebateTaskInfo.getRebateObjectFieldId());
        rebateSubTaskLogger._rebateTaskInfo = rebateTaskInfo;
        return rebateSubTaskLogger;
    }

    public static final RebateSubTaskLogger getLogger(RebateTaskInfo rebateTaskInfo, RowMeta rowMeta, Object rebateObjectPkValue) {
        RebateSubTaskLogger rebateSubTaskLogger = RebateSubTaskLogger.getLogger(rebateTaskInfo, rowMeta);
        rebateSubTaskLogger._logDynamicObject = rebateSubTaskLogger._loadLogData(rebateObjectPkValue);
        return rebateSubTaskLogger;
    }

    public void record(RowX rowX, boolean isOk) {
        String rebateObjectId = rowX.getString(this._rebateObjectFieldIndex);
        this._count(rebateObjectId, isOk);
    }

    public void commitRecord() {
        List sourceIds = this._rebateTaskInfo.getRebateObjectIds().values().stream().collect(Collectors.toList());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(sourceIds.size());
        String taskno = this._rebateTaskInfo.getTaskId();
        for (Long sourceId : sourceIds) {
            Object[] param = new Object[5];
            TaskResult taskResult = this._resultMap.get(sourceId);
            if (taskResult != null) {
                param[0] = taskResult.getCount();
                param[1] = taskResult.getSuccessCount();
            } else {
                param[0] = 0;
                param[1] = 0;
            }
            param[2] = "B";
            param[3] = taskno;
            param[4] = sourceId;
            paramsList.add(param);
        }
        String sql = "update t_msrcs_subtask set frecords = ? ,fsuccess = ? , fstatus= ?  where ftaskno=? and fsourceid=?";
        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, paramsList);
    }

    public void log(String status, Exception exception) {
        this.log(status, RebateSubTaskLogger._getExceptionMsg(exception));
    }

    public void log(String status, String message) {
        if (this._logDynamicObject == null) {
            return;
        }
        if (status != null) {
            this._logDynamicObject.set("status", (Object)(!this._logDynamicObject.getString("status").equalsIgnoreCase("c") ? status : "C"));
            if (status.equalsIgnoreCase("c") || status.equalsIgnoreCase("z")) {
                this._logDynamicObject.set("endtime", (Object)TimeServiceHelper.now());
            }
        }
        String detail = this._logDynamicObject.getString("detail") + (StringUtils.isNotEmpty((String)this._logDynamicObject.getString("detail")) ? "\n" : "") + message;
        this._logDynamicObject.set("detail", (Object)(detail.length() > 2000 ? detail.substring(0, 2000) : detail));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this._logDynamicObject});
    }

    private void _count(String rebateObjectId, boolean isOk) {
        Long rebateTargetId = this._rebateTaskInfo.getRebateObjectIds().get(rebateObjectId);
        TaskResult taskResult = this._resultMap.get(rebateTargetId);
        if (taskResult == null) {
            taskResult = new TaskResult();
            this._resultMap.put(rebateTargetId, taskResult);
        }
        taskResult.addCount();
        if (isOk) {
            taskResult.addSuccess();
        }
    }

    public static void batchAddNewLog(String mainTaskId, String subTaskId, RebateTaskInfo rebateTaskInfo) {
        List sourceIds = rebateTaskInfo.getRebateObjectIds().values().stream().collect(Collectors.toList());
        String sourceTargetFormId = rebateTaskInfo.getRebateTargetFormId();
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>();
        if (sourceIds != null && !sourceIds.isEmpty()) {
            QFilter filter = new QFilter("id", "in", sourceIds);
            Map numberMap = BusinessDataServiceHelper.loadFromCache((String)sourceTargetFormId, (String)"billno", (QFilter[])filter.toArray(), null);
            for (Long sourceId : sourceIds) {
                dataList.add(RebateLoggerServiceHelper.createNewTaskDetail(mainTaskId, subTaskId, sourceId, numberMap.get(sourceId) != null ? ((DynamicObject)numberMap.get(sourceId)).getString("billno") : " "));
            }
        } else {
            dataList.add(RebateLoggerServiceHelper.createNewTaskDetail(mainTaskId, subTaskId, 0L, " "));
        }
        SaveServiceHelper.save((DynamicObject[])dataList.toArray(new DynamicObject[dataList.size()]));
    }

    public static void batchUpdateLogForTermination(String mainTaskId, String subTaskId, String message, Exception e) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(1);
        Object[] param = new Object[]{message + "\n" + RebateSubTaskLogger._getExceptionMsg(e), TimeServiceHelper.now(), mainTaskId, subTaskId};
        paramsList.add(param);
        String sql = "update t_msrcs_subtask set fstatus = 'D',fdetail=?,fendtime=?  where fmaintaskno = ? and ftaskno= ? ";
        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, paramsList);
    }

    public static void batchUpdateLog(String mainTaskId, String subTaskId, String status) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(1);
        Object[] param = new Object[]{status, mainTaskId, subTaskId};
        paramsList.add(param);
        String sql = "update t_msrcs_subtask set fstatus = ?  where fmaintaskno = ? and ftaskno= ? ";
        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, paramsList);
    }

    public static void upbateSuccessIfIsReadyForEnd(String mainTaskId, String subTaskId, String message) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(1);
        Object[] param = new Object[]{TimeServiceHelper.now(), message, mainTaskId, subTaskId};
        paramsList.add(param);
        String sql = "update t_msrcs_subtask set fstatus = 'Z', fendtime=? ,fdetail=? where fmaintaskno = ? and ftaskno= ? and fstatus='A'";
        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, paramsList);
    }

    private DynamicObject _loadLogData(Object rebateObjectPkValue) {
        Long rebateTargetId = this._rebateTaskInfo.getRebateObjectIds().get(rebateObjectPkValue.toString());
        QFilter qfilter = new QFilter("taskno", "=", (Object)this._rebateTaskInfo.getTaskId());
        qfilter = qfilter.and(new QFilter("sourceid", "=", (Object)rebateTargetId));
        return BusinessDataServiceHelper.loadSingleFromCache((String)"msrcs_subtask", (QFilter[])qfilter.toArray());
    }

    private static String _getExceptionMsg(Exception exception) {
        StringBuilder errorMsg = new StringBuilder(100);
        errorMsg.append(exception.getMessage()).append("\n");
        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
            errorMsg.append(stackTraceElement.toString()).append("\n");
        }
        return errorMsg.toString();
    }
}

