/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.engine.output;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msrcs.business.RebateOutputServiceHelper;
import kd.mpscmm.msrcs.common.model.CalcFormula;
import kd.mpscmm.msrcs.common.model.CustomField;
import kd.mpscmm.msrcs.common.model.PolicyParser;
import kd.mpscmm.msrcs.common.model.RebateOutput;
import kd.mpscmm.msrcs.common.util.EntityUtil;
import kd.mpscmm.msrcs.common.util.FilterConditionUtil;
import kd.mpscmm.msrcs.common.util.QueryUtil;
import kd.mpscmm.msrcs.engine.common.TailEngine;
import kd.mpscmm.msrcs.engine.enginer.RebateTaskInfo;
import kd.mpscmm.msrcs.engine.exception.RebateBizException;
import kd.mpscmm.msrcs.engine.logger.RebateSubTaskLogger;
import kd.mpscmm.msrcs.engine.output.basedata.BasedataConvert;
import kd.mpscmm.msrcs.engine.output.ext.DefaultConvertPlugin;
import kd.mpscmm.msrcs.engine.output.obj.Continue;
import kd.mpscmm.msrcs.engine.output.obj.GroupCounter;
import kd.mpscmm.msrcs.engine.output.obj.Grouper;
import kd.mpscmm.msrcs.engine.output.obj.TargetQueryResult;
import kd.mpscmm.msrcs.engine.output.sdk.AbstractConvertPlugin;
import kd.mpscmm.msrcs.engine.output.sdk.ConvertArgs;
import kd.sdk.mpscmm.msrcs.formula.AbstractCalculator;
import kd.sdk.mpscmm.msrcs.formula.FormulaData;
import kd.sdk.mpscmm.msrcs.formula.TotalAmount;

public class RebateOutputEngine {
    private static Log logger = LogFactory.getLog(RebateOutputEngine.class);
    private RebateTaskInfo taskInfo;
    private Object rebateObjectPkValue;
    private List<Object[]> calcResultObjects;
    private RebateOutput rebateOutputRuleObject;
    private String rebateTargetBillno;
    private DynamicObject mainDataObject;
    private DynamicObject srcRebateTargetObject;
    private RowMeta rowMeta;
    private CalcFormula calcFormula;
    private RebateSubTaskLogger subTaskLogger;

    public RebateOutputEngine(RebateTaskInfo taskInfo, Object rebateObjectPkValue, RowMeta rowMeta) {
        this.taskInfo = taskInfo;
        this.rebateObjectPkValue = rebateObjectPkValue;
        this.rowMeta = rowMeta;
        this.calcFormula = CalcFormula.init(taskInfo.getJudgeBasisId(), taskInfo.getRebateCalcFormulaId());
        this.subTaskLogger = RebateSubTaskLogger.getLogger(taskInfo, rowMeta, this.rebateObjectPkValue);
        this.init();
    }

    private void init() {
        try {
            this._init();
        }
        catch (RebateBizException e) {
            logger.error(e.getMessage(), (Throwable)((Object)e));
            this.subTaskLogger.log("C", (Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.subTaskLogger.log("C", e);
        }
    }

    private void _init() {
        this.rebateOutputRuleObject = new RebateOutput(RebateOutputServiceHelper.getTargetInfo(this.taskInfo.getRebateSchemeId()));
        if (this.rebateObjectPkValue == null) {
            return;
        }
        Long rebateTargetId = this.taskInfo.getRebateObjectIds().get(this.rebateObjectPkValue.toString());
        if (rebateTargetId == null) {
            return;
        }
        this.srcRebateTargetObject = BusinessDataServiceHelper.loadSingle((Object)rebateTargetId, (String)this.rebateOutputRuleObject.getSrcPolicyTargetFormId());
        this.rebateTargetBillno = this.srcRebateTargetObject != null ? this.srcRebateTargetObject.getString("billno") : "";
        logger.info(String.format("rebateConvert: rebateObjectId: %s, rebateTarget:%s, result:%s", this.rebateObjectPkValue, this.rebateTargetBillno, this.getCalcResultObjects() != null ? this.getCalcResultObjects().size() : 0));
    }

    public final OperationResult out() {
        try {
            OperationResult result = this._out();
            this.subTaskLogger.log("Z", "\u5b8c\u6210");
            return result;
        }
        catch (RebateBizException e) {
            logger.error(e.getMessage(), (Throwable)((Object)e));
            this.subTaskLogger.log("C", (Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.subTaskLogger.log("C", e);
        }
        return null;
    }

    public final OperationResult _out() {
        if (this.rebateObjectPkValue == null) {
            throw new RebateBizException("\u8fd4\u5229\u5bf9\u8c61\u4e3a\u7a7a");
        }
        logger.info("rebateConvert: rebateObjectId:" + this.rebateObjectPkValue);
        if (this.srcRebateTargetObject == null) {
            throw new RebateBizException("\u8fd4\u5229\u76ee\u6807\u4e3a\u7a7a");
        }
        AbstractConvertPlugin pluginProxy = this.getPlugin();
        Continue isContinue = new Continue();
        this.mainDataObject = this.getOrCreateBillInfo(isContinue);
        if (!isContinue.isContinue()) {
            return null;
        }
        this.handNodata(isContinue);
        if (!isContinue.isContinue()) {
            return null;
        }
        this.convertBillHead();
        BasedataConvert basedataConvert = new BasedataConvert(this.rebateOutputRuleObject, this.mainDataObject);
        basedataConvert.convertHead();
        basedataConvert.convertSourceData(this.rowMeta, this.getCalcResultObjects());
        this.convertBillEntry();
        pluginProxy.afterConvert(this.mainDataObject);
        DynamicObject existDataObject = this.getExistBill();
        ConvertArgs convertArgs = new ConvertArgs();
        pluginProxy.compareBill(this.mainDataObject, existDataObject, convertArgs);
        if (convertArgs.isCancel()) {
            return null;
        }
        pluginProxy.beforeSave(this.mainDataObject);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)this.rebateOutputRuleObject.getOutTargetFormId(), (DynamicObject[])new DynamicObject[]{this.mainDataObject}, (OperateOption)OperateOption.create());
        this.logResult(operationResult, this.rebateTargetBillno, this.rebateObjectPkValue);
        return null;
    }

    private DynamicObject getOrCreateBillInfo(Continue isContinue) {
        TargetQueryResult targetQueryResult = this.getTargetQueryResult();
        if (targetQueryResult.isExist()) {
            DynamicObject dataObject = targetQueryResult.getResult();
            if (dataObject != null) {
                return dataObject;
            }
            isContinue.setContinue(false);
            return null;
        }
        return this.buildDynamicObject();
    }

    private TargetQueryResult getTargetQueryResult() {
        boolean isExistBill;
        List<QFilter> isExistQfitler = this.getQueryExistBillQfilter();
        String entityName = this.rebateOutputRuleObject.getOutTargetFormId();
        if (!CollectionUtils.isEmpty(isExistQfitler) && (isExistBill = QueryServiceHelper.exists((String)entityName, (QFilter[])((QFilter[])isExistQfitler.stream().toArray(QFilter[]::new))))) {
            QFilter extendQFilter = this.getRebateModelOutputFilterScheme();
            if (extendQFilter != null) {
                isExistQfitler.add(extendQFilter);
            }
            DynamicObject result = QueryUtil.loadSingle(entityName, (QFilter[])isExistQfitler.stream().toArray(QFilter[]::new), new String[0]);
            return new TargetQueryResult(isExistBill, result);
        }
        return new TargetQueryResult(false, null);
    }

    private QFilter getRebateModelOutputFilterScheme() {
        QFilter qFilter = null;
        if (this.rebateOutputRuleObject != null) {
            String dataEntityType = this.rebateOutputRuleObject.getOutTargetFormId();
            String filter = this.rebateOutputRuleObject.getRebateOutputObject().getString("filterscheme");
            if (StringUtils.isNotEmpty((String)dataEntityType) && StringUtils.isNotEmpty((String)filter)) {
                qFilter = FilterConditionUtil.translateInfoSqlFilter(dataEntityType, filter);
            }
        }
        return qFilter;
    }

    private List<QFilter> getQueryExistBillQfilter() {
        List<DynamicObject> uniqueFieldBotpProperties = this.rebateOutputRuleObject.getBillUniqueBotpProperties();
        if (!CollectionUtils.isEmpty(uniqueFieldBotpProperties)) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(uniqueFieldBotpProperties.size());
            Continue isContinue = new Continue();
            for (DynamicObject uniqueFieldBotpProperty : uniqueFieldBotpProperties) {
                String f = uniqueFieldBotpProperty.getString("tid");
                Object value = this.getHeadValue(uniqueFieldBotpProperty, isContinue);
                qFilterList.add(new QFilter(f, "=", value));
            }
            return qFilterList;
        }
        return new ArrayList<QFilter>(0);
    }

    private DynamicObject getExistBill() {
        List<QFilter> isExistQfitler = this.getQueryExistBillQfilter();
        if (!CollectionUtils.isEmpty(isExistQfitler)) {
            String entityName = this.rebateOutputRuleObject.getOutTargetFormId();
            return QueryUtil.loadSingle(entityName, (QFilter[])isExistQfitler.stream().toArray(QFilter[]::new), new String[0]);
        }
        return null;
    }

    private AbstractConvertPlugin getPlugin() {
        String plugin = this.rebateOutputRuleObject.getRebateOutputObject().getString("plugin");
        AbstractConvertPlugin pluginProxy = null;
        pluginProxy = StringUtil.isNotEmpty((String)plugin) ? (AbstractConvertPlugin)TypesContainer.createInstance((String)plugin) : new DefaultConvertPlugin();
        return pluginProxy;
    }

    private DynamicObject buildDynamicObject() {
        String targetFormId = this.rebateOutputRuleObject.getOutTargetFormId();
        return BusinessDataServiceHelper.newDynamicObject((String)targetFormId);
    }

    private void handNodata(Continue isContinue) {
        boolean hasNoData;
        String noDataType = this.getNoDataType();
        boolean bl = hasNoData = this.getCalcResultObjects().size() == 0;
        if (noDataType.equalsIgnoreCase("a") && hasNoData) {
            isContinue.setContinue(false);
            if ((Long)this.mainDataObject.getPkValue() > 0L) {
                OperationServiceHelper.executeOperate((String)"delete", (String)this.rebateOutputRuleObject.getOutTargetFormId(), (DynamicObject[])new DynamicObject[]{this.mainDataObject}, (OperateOption)OperateOption.create());
            }
        }
    }

    private void convertBillHead() {
        if (this.mainDataObject != null) {
            MainEntityType billEntity = EntityUtil.getMainEntityType(this.rebateOutputRuleObject.getOutTargetFormId());
            Map allOutputTargetFields = billEntity.getAllFields();
            DynamicObjectCollection botpProperties = this.rebateOutputRuleObject.getBotpCollection();
            for (DynamicObject botpProperty : botpProperties) {
                String tid;
                if (botpProperty == null || !this.isCanUpdate(botpProperty, this.mainDataObject) || allOutputTargetFields.get(tid = botpProperty.getString("tid")) == null || ((IDataEntityProperty)allOutputTargetFields.get(tid)).getParent() instanceof EntryType) continue;
                DynamicProperty dynamicProperty = this.mainDataObject.getDynamicObjectType().getProperty(tid);
                String valueType = botpProperty.getString("valuetype");
                if (dynamicProperty == null || StringUtil.isEmpty((String)valueType)) continue;
                Continue isContinue = new Continue();
                Object value = this.getHeadValue(botpProperty, isContinue);
                if (!isContinue.isContinue()) continue;
                if (dynamicProperty instanceof BasedataProp && !(value instanceof DynamicObject)) {
                    this.mainDataObject.set(tid + "_id", value);
                    continue;
                }
                this.mainDataObject.set(tid, value);
            }
            if (this.mainDataObject.getDataEntityType().getProperties().get((Object)"creator") != null) {
                this.mainDataObject.set("creator_Id", (Object)RequestContext.get().getCurrUserId());
            }
        }
    }

    private boolean isCanUpdate(DynamicObject botpProperty, DynamicObject dyObj) {
        String updateType;
        boolean result = true;
        if (botpProperty != null && dyObj != null && StringUtils.isNotEmpty((String)(updateType = botpProperty.getString("updatetype"))) && "B".equals(updateType)) {
            result = dyObj.getPkValue() == null || dyObj.getLong("id") == 0L;
        }
        return result;
    }

    private Object getHeadValue(DynamicObject botpProperty, Continue isContinue) {
        String valueType = botpProperty.getString("valuetype");
        if (StringUtil.isEmpty((String)valueType)) {
            isContinue.setContinue(false);
            return null;
        }
        String sourceFieldType = botpProperty.getString("sourcefieldtype");
        Object value = null;
        if (valueType.equalsIgnoreCase("0")) {
            String sid = botpProperty.getString("sid");
            if (StringUtil.isEmpty((String)sid)) {
                isContinue.setContinue(false);
                return null;
            }
            if (sourceFieldType.equalsIgnoreCase("B")) {
                value = this.getSrcRebateTargetValue(sid);
            }
        } else if (valueType.equalsIgnoreCase("3")) {
            value = botpProperty.get("fieldformula");
        } else if (valueType.equalsIgnoreCase("1")) {
            String formulaStr = botpProperty.getString("fieldformula");
            if (StringUtil.isEmpty((String)formulaStr)) {
                isContinue.setContinue(false);
                return null;
            }
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)formulaStr, CRFormula.class);
            value = FormulaEngine.execExcelFormula((String)formula.getExpression());
        }
        return value;
    }

    private void convertBillEntry() {
        GroupCounter groupCounter = this.groupAndSum();
        Map<String, List<DynamicObject>> entrypBotpPropertiesMap = this.getEntryBotpProperties();
        List<DynamicObject> rowUniqueFields = this.rebateOutputRuleObject.getRowUniqueField();
        List<DynamicObject> rowUniqueSumFields = this.rebateOutputRuleObject.getRowUniqueSumField();
        for (Map.Entry<String, List<DynamicObject>> entryBotpProperty : entrypBotpPropertiesMap.entrySet()) {
            String entrykey = entryBotpProperty.getKey();
            DynamicObjectCollection historyRowCollection = this.mainDataObject.getDynamicObjectCollection(entrykey);
            List<Object> noExistRowIds = new ArrayList();
            DynamicObjectType historyRowDynamicObjectType = historyRowCollection.getDynamicObjectType();
            for (int i = 0; i < historyRowCollection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)historyRowCollection.get(i);
                String groupKey = this.getOutputTargetRowUniqueKey(dynamicObject, rowUniqueFields);
                Grouper group = groupCounter.getGrouper(groupKey);
                if (group != null) {
                    this.setRowData(dynamicObject, historyRowDynamicObjectType, this.calcResultObjects.get(group.getRowDataIndex().get(0)), entryBotpProperty.getValue());
                    this.setSumData(dynamicObject, group, rowUniqueSumFields);
                    groupCounter.addExistHistoryKey(groupKey);
                    continue;
                }
                noExistRowIds.add(i);
            }
            noExistRowIds = noExistRowIds.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
            for (Integer n : noExistRowIds) {
                historyRowCollection.remove(n.intValue());
            }
            Map<String, Grouper> newRowsGrouper = groupCounter.getNewRows();
            for (Map.Entry<String, Grouper> newRowGrouper : newRowsGrouper.entrySet()) {
                DynamicObject newRowData = historyRowCollection.addNew();
                this.setRowData(newRowData, historyRowDynamicObjectType, this.calcResultObjects.get(newRowGrouper.getValue().getRowDataIndex().get(0)), entryBotpProperty.getValue());
                this.setSumData(newRowData, newRowGrouper.getValue(), rowUniqueSumFields);
            }
            BusinessDataServiceHelper.loadRefence((Object[])historyRowCollection.toArray((Object[])new DynamicObject[historyRowCollection.size()]), (IDataEntityType)historyRowDynamicObjectType);
            this.convertSelfField();
        }
    }

    private void setRowData(DynamicObject targetRowData, DynamicObjectType targetRowDataType, Object[] srcCalcResult, List<DynamicObject> rowBotpProperties) {
        for (DynamicObject botpRowData : rowBotpProperties) {
            if (botpRowData == null || targetRowData == null || !this.isCanUpdate(botpRowData, targetRowData)) continue;
            Continue isContinue = new Continue();
            Object value = this.getResultRowValue(botpRowData, srcCalcResult, isContinue);
            if (!isContinue.isContinue()) continue;
            String tid = botpRowData.getString("tid");
            DynamicProperty dynamicProperty = targetRowDataType.getProperty(tid);
            if (dynamicProperty instanceof BasedataProp) {
                targetRowData.set(tid + "_id", value);
                continue;
            }
            targetRowData.set(tid, value);
        }
    }

    private Object getResultRowValue(DynamicObject botpRowData, Object[] srcCalcResult, Continue isContinue) {
        String valueType = botpRowData.getString("valuetype");
        if (StringUtil.isEmpty((String)valueType)) {
            isContinue.setContinue(false);
            return null;
        }
        Object value = null;
        if (valueType.equalsIgnoreCase("0")) {
            String sid = botpRowData.getString("sid");
            if (StringUtil.isNotEmpty((String)sid)) {
                String fieldKey = sid;
                String sourceFieldType = botpRowData.getString("sourcefieldtype");
                if (sourceFieldType.equalsIgnoreCase("B")) {
                    value = this.srcRebateTargetObject.get(sid);
                } else {
                    int fieldIndex;
                    if (sourceFieldType.equalsIgnoreCase("D")) {
                        fieldKey = CustomField.getKey(sid);
                    }
                    if ((fieldIndex = this.rowMeta.getFieldIndex(fieldKey, false)) >= 0) {
                        value = srcCalcResult[fieldIndex];
                    }
                }
            }
        } else if (valueType.equalsIgnoreCase("3")) {
            value = botpRowData.getString("fieldformula");
        } else if (valueType.equalsIgnoreCase("1")) {
            String formulaStr = botpRowData.getString("fieldformula");
            if (StringUtil.isEmpty((String)formulaStr)) {
                isContinue.setContinue(false);
                return null;
            }
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)formulaStr, CRFormula.class);
            value = FormulaEngine.execExcelFormula((String)formula.getExpression());
        }
        return value;
    }

    private void convertSelfField() {
        Map<String, List<DynamicObject>> groupSelfFieldByFieldTypes = this.groupSelfFieldByFieldType();
        for (Map.Entry<String, List<DynamicObject>> selfConvertProperties : groupSelfFieldByFieldTypes.entrySet()) {
            for (DynamicObject selfConvertPropertie : selfConvertProperties.getValue()) {
                if (selfConvertProperties.getKey().equals("._billhead")) continue;
                DynamicObjectCollection entryDataObjectCollection = this.mainDataObject.getDynamicObjectCollection(selfConvertProperties.getKey());
                for (DynamicObject entryDataObject : entryDataObjectCollection) {
                    if (selfConvertPropertie == null || entryDataObject == null || !this.isCanUpdate(selfConvertPropertie, entryDataObject)) continue;
                    entryDataObject.set(selfConvertPropertie.getString("tid"), entryDataObject.get(selfConvertPropertie.getString("sid")));
                }
            }
        }
    }

    private Map<String, List<DynamicObject>> groupSelfFieldByFieldType() {
        DynamicObjectCollection botpProperties = this.rebateOutputRuleObject.getBotpCollection();
        Map<String, IDataEntityProperty> allOutputObjectFields = this.getOutputObjectFields();
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>();
        List selfConvertProperties = botpProperties.stream().filter(v -> v.getString("sourcefieldtype").equalsIgnoreCase("C")).collect(Collectors.toList());
        for (DynamicObject botpProperty : selfConvertProperties) {
            ArrayList<DynamicObject> listObjs;
            String groupKey = "._billhead";
            String tid = botpProperty.getString("tid");
            IDataEntityProperty property = allOutputObjectFields.get(tid);
            if (property == null) continue;
            if (property.getParent() instanceof EntryType) {
                groupKey = allOutputObjectFields.get(tid).getParent().getName();
            }
            if ((listObjs = (ArrayList<DynamicObject>)result.get(groupKey)) == null) {
                listObjs = new ArrayList<DynamicObject>();
                result.put(groupKey, listObjs);
            }
            listObjs.add(botpProperty);
        }
        return result;
    }

    private Map<String, List<DynamicObject>> getEntryBotpProperties() {
        Map<String, IDataEntityProperty> allTargetObjectFields = this.getOutputObjectFields();
        DynamicObjectCollection botpProperties = this.rebateOutputRuleObject.getBotpCollection();
        HashMap<String, List<DynamicObject>> entryMap = new HashMap<String, List<DynamicObject>>(2);
        for (DynamicObject botpRowProperty : botpProperties) {
            IDataEntityProperty tidProperty;
            boolean isConststr;
            String valueType = botpRowProperty.getString("valuetype");
            String sourceFieldType = botpRowProperty.getString("sourcefieldtype");
            if (StringUtil.isEmpty((String)valueType)) continue;
            boolean isResultField = "0".equalsIgnoreCase(valueType) && (sourceFieldType.equalsIgnoreCase("D") || sourceFieldType.equalsIgnoreCase("A") || sourceFieldType.equalsIgnoreCase("B"));
            boolean bl = isConststr = ("3".equalsIgnoreCase(valueType) || "1".equalsIgnoreCase(valueType)) && StringUtil.isNotEmpty((String)botpRowProperty.getString("fieldformula"));
            if (!isResultField && !isConststr || !((tidProperty = allTargetObjectFields.get(botpRowProperty.get("tid"))).getParent() instanceof EntryType)) continue;
            ArrayList<DynamicObject> entryFieldList = (ArrayList<DynamicObject>)entryMap.get(tidProperty.getParent().getName());
            if (entryFieldList == null) {
                entryFieldList = new ArrayList<DynamicObject>(10);
                entryMap.put(tidProperty.getParent().getName(), entryFieldList);
            }
            entryFieldList.add(botpRowProperty);
        }
        return entryMap;
    }

    private String getOutputTargetRowUniqueKey(DynamicObject row, List<DynamicObject> rowUniqueFields) {
        StringBuilder key = new StringBuilder(10);
        for (DynamicObject rowUniqueField : rowUniqueFields) {
            String fieldId = rowUniqueField.getString("tid");
            Object obj = row.get(fieldId);
            String value = obj == null ? "" : (obj instanceof DynamicObject ? ((DynamicObject)obj).getPkValue().toString() : obj.toString());
            key.append(value).append("_");
        }
        return key.toString();
    }

    private String getResultRowUniqueKey(Object[] rowData, List<DynamicObject> rowUniqueFields) {
        StringBuilder key = new StringBuilder(10);
        Continue isContinue = new Continue();
        for (DynamicObject rowUniqueField : rowUniqueFields) {
            Object value = this.getResultRowValue(rowUniqueField, rowData, isContinue);
            key.append(value != null ? value : "").append("_");
        }
        return key.toString();
    }

    private GroupCounter groupAndSum() {
        List<DynamicObject> rowUniqueFields = this.rebateOutputRuleObject.getRowUniqueField();
        List<DynamicObject> rowUniqueSumFields = this.rebateOutputRuleObject.getRowUniqueSumField();
        GroupCounter groupCounter = new GroupCounter();
        List<Object[]> resultObjects = this.getCalcResultObjects();
        Continue isContinue = new Continue();
        String resultField = this.rebateOutputRuleObject.getTargetResultFieldName();
        PolicyParser policyParser = new PolicyParser(this.getTaskInfo().getPolicyParseObject());
        AbstractCalculator calculatorPlugin = this.getCalcFormula().getCalculator();
        TailEngine tailEnginer = null;
        if (calculatorPlugin.isEnableTailCalc()) {
            tailEnginer = this.sumTotalAmount(calculatorPlugin.getAmountVar(), policyParser);
        }
        int groupNoIndex = this.rowMeta.getFieldIndex(CustomField.getKey(CustomField.getGroupNoKey()), false);
        for (int i = 0; i < resultObjects.size(); ++i) {
            Object usedAmount;
            Object[] rowData = resultObjects.get(i);
            String groupKey = this.getResultRowUniqueKey(rowData, rowUniqueFields);
            String groupNo = String.valueOf(rowData[groupNoIndex] == null ? "0" : rowData[groupNoIndex]);
            TotalAmount totalAmount = tailEnginer != null ? tailEnginer.getTotalAmount(groupNo) : null;
            Grouper groupger = groupCounter.getGrouper(groupKey);
            if (calculatorPlugin.isEnableTailCalc() && groupger != null) {
                Object object = usedAmount = groupger.getResultData() != null ? groupger.getResultData().get(resultField) : null;
                if (usedAmount == null) {
                    usedAmount = BigDecimal.ZERO;
                }
                if (totalAmount != null) {
                    totalAmount.use(((BigDecimal)usedAmount).multiply(new BigDecimal(-1)));
                }
            }
            groupger = groupCounter.add(groupKey, i);
            usedAmount = rowUniqueSumFields.iterator();
            while (usedAmount.hasNext()) {
                DynamicObject rowUniqueSumField = (DynamicObject)usedAmount.next();
                Object value = this.getResultRowValue(rowUniqueSumField, rowData, isContinue);
                String field = rowUniqueSumField.getString("tid");
                String sourceFieldKey = rowUniqueSumField.getString("sid");
                if (rowUniqueSumField.getString("sourcefieldtype").equalsIgnoreCase("A")) {
                    sourceFieldKey = "m_" + sourceFieldKey;
                }
                groupger.sumField(field, sourceFieldKey, (BigDecimal)value);
            }
            FormulaData destFormulData = policyParser.mapCalcFormDataFromAlgoRow(Arrays.asList(calculatorPlugin.getAllVar()), this.rowMeta, groupger, rowData, this.taskInfo.getKpiList().get(0).getLadderIdentifier());
            destFormulData.setCurrency(this.taskInfo.getCurrency());
            BigDecimal result = BigDecimal.ZERO;
            if (calculatorPlugin.isCanCalculate((Object)destFormulData, (Object)totalAmount)) {
                result = calculatorPlugin.calculate((Object)destFormulData, (Object)totalAmount);
                if (totalAmount != null) {
                    totalAmount.use(result, (Object)groupKey);
                }
            }
            groupger.calc(resultField, result);
        }
        if (calculatorPlugin.isEnableTailCalc() && tailEnginer != null) {
            List<TotalAmount> totalAmounts = tailEnginer.getAllTotalAmountList();
            for (TotalAmount totalAmount : totalAmounts) {
                String groupKey = (String)totalAmount.getLastIndex();
                Grouper groupger = groupCounter.getGrouper(groupKey);
                groupger.calc(resultField, groupger.getResultData().get(resultField).add(totalAmount.getTailAmount()));
            }
        }
        return groupCounter;
    }

    private TailEngine sumTotalAmount(String amountVar, PolicyParser policyParser) {
        List<Object[]> resultObjects = this.getCalcResultObjects();
        int groupNoIndex = this.rowMeta.getFieldIndex(CustomField.getKey(CustomField.getGroupNoKey()), false);
        String amountField = policyParser.getAlgoxField(amountVar, this.taskInfo.getKpiList().get(0).getLadderIdentifier());
        int amountFieldIndex = this.rowMeta.getFieldIndex(amountField, false);
        TailEngine tailEngine = new TailEngine();
        ArrayList<Integer> dataIndex = new ArrayList<Integer>();
        int i = 0;
        for (Object[] data : resultObjects) {
            String groupNo = String.valueOf(data[groupNoIndex] == null ? "0" : data[groupNoIndex]);
            TotalAmount totalAmount = tailEngine.getTotalAmount(groupNo);
            if (totalAmount == null) {
                totalAmount = tailEngine.init(groupNo);
                dataIndex.add(i);
            }
            ++i;
            totalAmount.addTotalAmount((BigDecimal)data[amountFieldIndex]);
        }
        for (Integer index : dataIndex) {
            Object[] rowData = resultObjects.get(index);
            String groupNo = String.valueOf(rowData[groupNoIndex] == null ? "0" : rowData[groupNoIndex]);
            TotalAmount totalAmount = tailEngine.getTotalAmount(groupNo);
            AbstractCalculator calculatorPlugin = this.getCalcFormula().getCalculator();
            FormulaData destFormulData = policyParser.mapCalcFormDataFromAlgoRow(Arrays.asList(calculatorPlugin.getAllVar()), this.rowMeta, null, rowData, this.taskInfo.getKpiList().get(0).getLadderIdentifier());
            BigDecimal totalRebateAmount = calculatorPlugin.calcTotalRebateAmount((Object)destFormulData, (Object)totalAmount);
            totalAmount.setTotalRebateAmount(totalRebateAmount);
        }
        return tailEngine;
    }

    private void setSumData(DynamicObject rowData, Grouper grouper, List<DynamicObject> rowUniqueSumFields) {
        if (rowData != null) {
            for (DynamicObject rowUniqueSumField : rowUniqueSumFields) {
                if (rowUniqueSumField == null || rowData == null || !this.isCanUpdate(rowUniqueSumField, rowData)) continue;
                String field = rowUniqueSumField.getString("tid");
                BigDecimal sumValue = grouper.getSumData().get(field);
                if (sumValue == null) continue;
                rowData.set(field, (Object)sumValue);
            }
            DynamicObject resultSettingObj = this.rebateOutputRuleObject.getTargetResultSettingObject();
            String resultFieldKey = resultSettingObj.getString("tid");
            BigDecimal calcValue = grouper.getResultData().get(resultFieldKey);
            if (calcValue != null) {
                rowData.set(resultFieldKey, (Object)calcValue);
            }
        }
    }

    private Map<String, IDataEntityProperty> getOutputObjectFields() {
        return EntityMetadataCache.getDataEntityType((String)this.rebateOutputRuleObject.getOutTargetFormId()).getAllFields();
    }

    public List<Object[]> getCalcResultObjects() {
        return this.calcResultObjects;
    }

    public void setCalcResultObjects(List<Object[]> calcResultObjects) {
        this.calcResultObjects = calcResultObjects;
    }

    public DynamicObject getMainDataObject() {
        return this.mainDataObject;
    }

    public void setMainDataObject(DynamicObject mainDataObject) {
        this.mainDataObject = mainDataObject;
    }

    public String getRebateTargetBillno() {
        return this.rebateTargetBillno;
    }

    private Object getSrcRebateTargetValue(String fieldName) {
        return this.srcRebateTargetObject.get(fieldName);
    }

    private void logResult(OperationResult operationResult, String rebateTargetNumber, Object rebateObjectId) {
        if (operationResult.isSuccess()) {
            logger.info(String.format("rebateConvert:RebateObjectId: %s, %s Convert success ,preObj:%s", rebateObjectId, rebateTargetNumber, operationResult.getBillNos().get("0")));
        } else {
            logger.info(String.format("rebateConvert:RebateObjectId: %s, %s Convert fail: %s", rebateObjectId, rebateTargetNumber, this.getErrorInfo(operationResult)));
        }
    }

    private String getErrorInfo(OperationResult operationResult) {
        if (!operationResult.isSuccess()) {
            List errorInfos = operationResult.getAllErrorOrValidateInfo();
            StringBuilder result = new StringBuilder();
            for (IOperateInfo errorInfo : errorInfos) {
                result.append(errorInfo.getMessage()).append("\n");
            }
            return result.toString();
        }
        return "";
    }

    private String getNoDataType() {
        String nodatamodel = this.rebateOutputRuleObject.getRebateOutputObject().getString("nodatamodel");
        return (StringUtils.isEmpty((String)nodatamodel) ? "A" : nodatamodel).toLowerCase();
    }

    public RebateTaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public CalcFormula getCalcFormula() {
        return this.calcFormula;
    }
}

