/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.engine.output.basedata;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msrcs.common.model.RebateOutput;
import kd.mpscmm.msrcs.engine.output.basedata.BasedataPkFetch;
import kd.mpscmm.msrcs.engine.output.basedata.BasedataPkSet;
import kd.mpscmm.msrcs.engine.output.basedata.ConvertFieldInfo;
import kd.mpscmm.msrcs.engine.output.basedata.ConvertFieldPicker;

public class BasedataConvert {
    private String entityId;
    private BillEntityType mainEntityType;
    private DynamicObjectCollection botpDataCollection;
    private String mainOrgField;
    private ConvertFieldPicker convertFieldPicker = ConvertFieldPicker.get();
    private Long mainOrgPkValue = null;
    private RebateOutput rebateOutput;
    private DynamicObject mainDataObject;

    public BasedataConvert(RebateOutput rebateOutput, DynamicObject dataObject) {
        this.rebateOutput = rebateOutput;
        this.entityId = rebateOutput.getOutTargetFormId();
        this.botpDataCollection = rebateOutput.getBotpCollection();
        this.mainDataObject = dataObject;
        this.init();
    }

    private void init() {
        this.mainEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.entityId);
        this.mainOrgField = this.mainEntityType.getMainOrg();
        this.findNeedConvertBasedataField();
        this.convertFieldPicker.setMainEntityId(this.entityId);
        if (StringUtils.isEmpty((String)this.mainOrgField)) {
            return;
        }
        this.mainOrgPkValue = (Long)this.mainDataObject.getDynamicObject(this.mainOrgField).getPkValue();
    }

    private void findNeedConvertBasedataField() {
        if (this.botpDataCollection == null || this.botpDataCollection.size() == 0) {
            return;
        }
        Map targetFormAllFields = this.mainEntityType.getAllFields();
        for (DynamicObject botpData : this.botpDataCollection) {
            String tid = botpData.getString("tid");
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)targetFormAllFields.get(tid);
            this.convertFieldPicker.addField(dataEntityProperty);
        }
    }

    public void convertHead() {
        if (this.mainOrgPkValue == null) {
            return;
        }
        Map<String, List<ConvertFieldInfo>> convertFieldMap = this.convertFieldPicker.getConvertFieldInfoMap(this.entityId);
        if (convertFieldMap == null || convertFieldMap.size() == 0) {
            return;
        }
        BasedataPkFetch basedataPkFetch = BasedataPkFetch.get(this.mainDataObject, this.mainOrgPkValue, this.convertFieldPicker);
        BasedataPkSet basedataPkSet = BasedataPkSet.get(this.mainDataObject, this.convertFieldPicker);
        for (Map.Entry<String, List<ConvertFieldInfo>> convertFieldInfo : convertFieldMap.entrySet()) {
            List<Object> originalPks = basedataPkFetch.getOriginalPks(convertFieldInfo.getValue());
            Map<Object, Object> targetMap = basedataPkFetch.convertToTargetOrgId(convertFieldInfo.getKey(), convertFieldInfo.getValue().get(0).getMasterProp(), originalPks);
            basedataPkSet.setNewPks(convertFieldInfo.getValue(), targetMap);
        }
    }

    public void convertSourceData(RowMeta rowMeta, List<Object[]> calcModelResultObjects) {
        if (this.mainOrgPkValue == null || calcModelResultObjects == null) {
            return;
        }
        BasedataPkFetch basedataPkFetch = BasedataPkFetch.get(this.mainDataObject, this.mainOrgPkValue, this.convertFieldPicker);
        Map entityAllFields = this.mainEntityType.getAllFields();
        List<DynamicObject> botpOnlyFromModelCollection = this.rebateOutput.getBotpCollectionOnlyFromModel();
        for (DynamicObject botpConfig : botpOnlyFromModelCollection) {
            String masterIdProp;
            String baseEntityId;
            String tid = botpConfig.getString("tid");
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)entityAllFields.get(tid);
            if (dataEntityProperty == null || !(dataEntityProperty instanceof BasedataProp) || !BaseDataServiceHelper.checkBaseDataCtrl((String)(baseEntityId = ((BasedataProp)dataEntityProperty).getBaseEntityId())).booleanValue() || StringUtils.isEmpty((String)(masterIdProp = BaseDataServiceHelper.getMasterIdPropName((String)baseEntityId)))) continue;
            String sid = botpConfig.getString("sid");
            int fieldIndex = rowMeta.getFieldIndex(sid);
            HashSet<Object> pkValues = new HashSet<Object>(calcModelResultObjects == null ? 0 : calcModelResultObjects.size());
            for (Object[] calcModelResultObject : calcModelResultObjects) {
                pkValues.add(calcModelResultObject[fieldIndex]);
            }
            Map<Object, Object> targetMap = basedataPkFetch.convertToTargetOrgId(baseEntityId, masterIdProp, Arrays.asList(pkValues.toArray()));
            for (Object[] calcModelResultObject : calcModelResultObjects) {
                calcModelResultObject[fieldIndex] = targetMap.get(calcModelResultObject[fieldIndex]);
            }
        }
    }
}

