/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.engine.output.obj;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.mpscmm.msrcs.engine.output.obj.Grouper;

public class GroupCounter {
    private Map<String, Grouper> _map = new HashMap<String, Grouper>();
    private Set<String> historyKeyList = new HashSet<String>(10);

    public Grouper add(String groupKey, int index) {
        Grouper grouper = this._map.get(groupKey);
        if (grouper == null) {
            grouper = new Grouper();
            this._map.put(groupKey, grouper);
        }
        grouper.addIndex(index);
        return grouper;
    }

    public Grouper addSumData(String groupKey, String sumField, String sourceFieldIdentity, BigDecimal value) {
        if (value == null) {
            value = BigDecimal.ZERO;
        }
        Grouper grouper = this._map.get(groupKey);
        grouper.sumField(sumField, sourceFieldIdentity, value);
        return grouper;
    }

    public void setResultData(String groupKey, String sumField, BigDecimal value) {
        if (value == null) {
            value = BigDecimal.ZERO;
        }
        Grouper grouper = this._map.get(groupKey);
        grouper.calc(sumField, value);
    }

    public Grouper getGrouper(String key) {
        return this._map.get(key);
    }

    public Set<String> getHistoryKeyList() {
        return this.historyKeyList;
    }

    public void setHistoryKeyList(Set<String> historyKeyList) {
        this.historyKeyList = historyKeyList;
    }

    public void addExistHistoryKey(String key) {
        this.historyKeyList.add(key);
    }

    public Map<String, Grouper> getNewRows() {
        return this._map.entrySet().stream().filter(v -> !this.historyKeyList.contains(v.getKey())).collect(Collectors.toMap(v -> (String)v.getKey(), v -> (Grouper)v.getValue()));
    }
}

