/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msrcs.common.util.DynamicObjectUtils;
import kd.mpscmm.msrcs.common.util.EntityUtil;
import kd.mpscmm.msrcs.formplugin.base.BaseFormPlugin;

public class PolicyParseRuleEdit
extends BaseFormPlugin
implements IBillPlugin {
    private static final String FILTERGRIDAP = "filtergridap";
    private static final String REBATEFIELDNAME_CLOSE = "rebatefieldname_close";
    private static final String POLICYCOL_CLOSE = "policycol_close";
    private static final String MODELCOL_CLOSE = "modelcol_close";
    private static final String POLICYCONDITIONCOL_CLOSE = "policyconditioncol_close";
    private static final String SOURCECOL_CLOSE = "sourcecol_close";
    private static final String SOURCECOLFACTOR_CLOSE = "sourcecolfactor_close";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"policycol", "modelcol", "sourcecol", "sourcecolvalue", "rebatefieldname"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.updateRequestFilterCols(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": {
                this.beforeSave();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterGrid filterGridCtrl = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        FilterCondition filterCondition = this.loadFilter("filterscheme");
        if (filterCondition != null) {
            filterGridCtrl.SetValue(filterCondition);
            this.getView().updateView(FILTERGRIDAP);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setEntryComboVarcol();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.setEntryComboVarcol();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        switch (fieldKey = e.getProperty().getName()) {
            case "policyentity": {
                Object oldValue;
                ChangeData[] changeDatas = e.getChangeSet();
                if (changeDatas != null && (oldValue = e.getChangeSet()[0].getOldValue()) == null) break;
                DynamicObjectCollection entryEntity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                entryEntity.clear();
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    private void setEntryComboVarcol() {
        Map<String, String> formulamap = this.getCalFormulaMap();
        if (formulamap == null || formulamap.size() == 0) {
            return;
        }
        ArrayList<ComboItem> comboItemlist = new ArrayList<ComboItem>(formulamap.size());
        ComboEdit comboEdit = (ComboEdit)this.getControl("varcol");
        for (Map.Entry<String, String> entry : formulamap.entrySet()) {
            ComboItem item = new ComboItem();
            item.setId(entry.getKey());
            item.setValue(entry.getKey());
            item.setCaption(new LocaleString(entry.getValue()));
            comboItemlist.add(item);
        }
        comboEdit.setComboItems(comboItemlist);
    }

    public void click(EventObject evt) {
        String controlKey;
        Control control = (Control)evt.getSource();
        switch (controlKey = control.getKey()) {
            case "rebatefieldname": {
                this.showEntityFieldForm("policyentity", REBATEFIELDNAME_CLOSE);
                break;
            }
            case "policycol": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                Object conditiontype = this.getModel().getValue("conditiontype", rowIndex);
                if (conditiontype == null) {
                    this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u6761\u4ef6\u7c7b\u578b\u3002");
                    break;
                }
                if (StringUtils.equals((CharSequence)String.valueOf(conditiontype), (CharSequence)"A") || StringUtils.equals((CharSequence)String.valueOf(conditiontype), (CharSequence)"B")) {
                    this.showEntityFieldForm("policyentity", POLICYCOL_CLOSE);
                    break;
                }
                if (!StringUtils.equals((CharSequence)String.valueOf(conditiontype), (CharSequence)"C")) break;
                this.showEntityFieldForm("conditiongroupentity", POLICYCONDITIONCOL_CLOSE);
                break;
            }
            case "modelcol": {
                this.showModelFieldForm("rebateschema", MODELCOL_CLOSE);
                break;
            }
            case "sourcecol": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("calentity");
                DynamicObject sourceEntity = (DynamicObject)this.getModel().getValue("sourceentity", rowIndex);
                if (sourceEntity == null) {
                    return;
                }
                String sourceEntityNumber = sourceEntity.getString("number");
                this.showFormIdFieldForm(sourceEntityNumber, SOURCECOL_CLOSE);
                break;
            }
            case "sourcecolvalue": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("calentity");
                DynamicObject sourceEntity = (DynamicObject)this.getModel().getValue("sourceentity", rowIndex);
                if (sourceEntity == null) {
                    return;
                }
                String sourceEntityNumber = sourceEntity.getString("number");
                ListShowParameter param = ShowFormHelper.createShowListForm((String)sourceEntityNumber, (boolean)false, (int)2, (boolean)true);
                param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SOURCECOLFACTOR_CLOSE));
                this.getView().showForm((FormShowParameter)param);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String callBack;
        super.closedCallBack(e);
        if (e.getReturnData() == null) {
            return;
        }
        switch (callBack = e.getActionId()) {
            case "rebatefieldname_close": {
                String field = (String)e.getReturnData();
                this.callBackRebateFieldName(field);
                break;
            }
            case "policycol_close": {
                String field = (String)e.getReturnData();
                this.callBackBillCol(field);
                break;
            }
            case "modelcol_close": {
                String field = (String)e.getReturnData();
                this.callBackMatchBillCol(field);
                break;
            }
            case "policyconditioncol_close": {
                String field = (String)e.getReturnData();
                this.callBackConditionGroupCol(field);
                break;
            }
            case "sourcecol_close": {
                String field = (String)e.getReturnData();
                this.callBackSourceCol(field);
                break;
            }
            case "sourcecolfactor_close": {
                this.callBackSourceColFactor(e.getReturnData());
                break;
            }
        }
    }

    private void callBackRebateFieldName(String field) {
        MainEntityType policyEntityType = this.getMainEntityType("policyentity");
        IDataModel model = this.getModel();
        model.setValue("rebatefield", (Object)field);
        model.setValue("rebatefieldname", (Object)EntityUtil.getColFullName(policyEntityType, field));
    }

    private void callBackBillCol(String field) {
        MainEntityType policyEntityType = this.getMainEntityType("policyentity");
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("entryentity");
        model.setValue("policycol", (Object)field, rowIndex);
        model.setValue("policycolname", (Object)EntityUtil.getColFullName(policyEntityType, field), rowIndex);
    }

    private void callBackMatchBillCol(String field) {
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("entryentity");
        MainEntityType entityType = this.getModelEntityType("rebateschema");
        model.setValue("modelcol", (Object)field, rowIndex);
        model.setValue("modelcolname", (Object)EntityUtil.getColFullName(entityType, field), rowIndex);
    }

    private void callBackConditionGroupCol(String field) {
        MainEntityType condEntityType = this.getMainEntityType("conditiongroupentity");
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("entryentity");
        model.setValue("policycol", (Object)field, rowIndex);
        model.setValue("policycolname", (Object)EntityUtil.getColFullName(condEntityType, field), rowIndex);
    }

    private void callBackSourceCol(String field) {
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("calentity");
        DynamicObject sourceEntity = (DynamicObject)this.getModel().getValue("sourceentity", rowIndex);
        if (sourceEntity == null) {
            return;
        }
        String sourceEntityNumber = sourceEntity.getString("number");
        MainEntityType entityType = EntityUtil.getMainEntityType(sourceEntityNumber);
        model.setValue("sourcecol", (Object)field, rowIndex);
        model.setValue("sourcecolname", (Object)EntityUtil.getColFullName(entityType, field), rowIndex);
        IDataEntityType fieldType = entityType.findProperty(field).getParent();
        if (fieldType instanceof EntryType) {
            model.setValue("sourceentrykey", (Object)fieldType.getName(), rowIndex);
        }
    }

    private void callBackSourceColFactor(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection listSelectedRow = (ListSelectedRowCollection)returnData;
            ListSelectedRow selectedRow = listSelectedRow.get(0);
            int rowIndex = this.getModel().getEntryCurrentRowIndex("calentity");
            this.getModel().setValue("sourcecolid", selectedRow.getPrimaryKeyValue(), rowIndex);
            this.getModel().setValue("sourcecolvalue", (Object)selectedRow.getName(), rowIndex);
        }
    }

    private void showEntityFieldForm(String fieldName, String actionId) {
        MainEntityType entityType = this.getMainEntityType(fieldName);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setOnlyPhysicsField(false);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)entityType, (PropTreeBuildOption)option);
        this.showSelectFieldForm(srcBillNode, actionId);
    }

    private void showFormIdFieldForm(String formId, String actionId) {
        MainEntityType sourceType = EntityUtil.getMainEntityType(formId);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setOnlyPhysicsField(false);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceType, (PropTreeBuildOption)option);
        this.showSelectFieldForm(srcBillNode, actionId);
    }

    private void showModelFieldForm(String modelEntityKey, String actionId) {
        MainEntityType matchType = this.getModelEntityType(modelEntityKey);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setOnlyPhysicsField(false);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)matchType, (PropTreeBuildOption)option);
        this.showSelectFieldForm(srcBillNode, actionId);
    }

    private MainEntityType getMainEntityType(String entityKey) {
        String formId = EntityUtil.getFormIdByField(this.getModel(), entityKey);
        MainEntityType entityType = EntityUtil.getMainEntityType(formId);
        return entityType;
    }

    private MainEntityType getModelEntityType(String modelEntityKey) {
        DynamicObject modelEntity = (DynamicObject)this.getModel().getValue(modelEntityKey);
        if (modelEntity == null) {
            return null;
        }
        DynamicObject rebateModel = modelEntity.getDynamicObject("rebatemodel");
        if (rebateModel == null) {
            throw new KDBizException("\u8fd4\u5229\u8ba1\u7b97\u6a21\u578b:\u5c5e\u6027\u8868\u5143\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        return MetadataServiceHelper.getDataEntityType((String)rebateModel.getString("number"));
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String actionId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
        OperationResult operationResult = new OperationResult();
        operationResult.isShowMessage();
    }

    private Map<String, String> getCalFormulaMap() {
        DynamicObjectCollection calFormulaEntity;
        DynamicObject rebateSchema = (DynamicObject)this.getModel().getValue("rebateschema");
        if (rebateSchema == null) {
            throw new KDBizException("\u8bf7\u5148\u9009\u62e9\u8fd4\u5229\u8ba1\u7b97\u65b9\u6848\u3002");
        }
        ArrayList calFormulaAllIds = new ArrayList();
        DynamicObjectCollection judgeStandardEntity = rebateSchema.getDynamicObjectCollection("judgestandardentity");
        if (!CollectionUtils.isEmpty((Collection)judgeStandardEntity)) {
            List judgeFormulaIds = judgeStandardEntity.stream().map(r -> DynamicObjectUtils.getDynamicObjectLPkValue(r, "judgestandard")).collect(Collectors.toList());
            calFormulaAllIds.addAll(judgeFormulaIds);
        }
        if (!CollectionUtils.isEmpty((Collection)(calFormulaEntity = rebateSchema.getDynamicObjectCollection("calformulaentity")))) {
            List calFormulaIds = calFormulaEntity.stream().map(r -> DynamicObjectUtils.getDynamicObjectLPkValue(r, "calformula")).collect(Collectors.toList());
            calFormulaAllIds.addAll(calFormulaIds);
        }
        HashMap<String, String> formulamap = new HashMap<String, String>(calFormulaAllIds.size());
        String selectFields = "entryentity.varname,entryentity.description";
        QFilter filter = new QFilter("id", "in", calFormulaAllIds);
        DynamicObjectCollection formulas = QueryServiceHelper.query((String)"msrcs_rebateformula", (String)selectFields, (QFilter[])filter.toArray());
        if (!CollectionUtils.isEmpty((Collection)formulas)) {
            for (DynamicObject formula : formulas) {
                String formulakey = formula.getString("entryentity.varname");
                if (!StringUtils.isNotEmpty((CharSequence)formulakey)) continue;
                formulamap.put(formulakey, formula.getString("entryentity.description"));
            }
        }
        return formulamap;
    }

    private void beforeSave() {
        IDataModel model = this.getModel();
        String requestFilter = this.getRequestFilterStr();
        model.setValue("filterscheme", (Object)requestFilter);
    }

    private String getRequestFilterStr() {
        FilterGrid grid = (FilterGrid)this.getControl(FILTERGRIDAP);
        if (grid == null) {
            return null;
        }
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        return SerializationUtils.toJsonString((Object)condition);
    }

    private FilterCondition loadFilter(String ctrlName) {
        String filter = this.getStringValue(ctrlName);
        if (StringUtils.isEmpty((CharSequence)filter)) {
            return null;
        }
        return (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
    }

    private void updateRequestFilterCols(boolean changed) {
        IDataModel model = this.getModel();
        DynamicObject entity = model.getDataEntity().getDynamicObject("policyentity");
        if (entity == null) {
            return;
        }
        MainEntityType entityType = this.getMainEntityType("policyentity");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        if (entityType == null) {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFilterColumns(new ArrayList(0));
            filterGrid.setEntityNumber("");
        } else {
            if (changed) {
                filterGrid.SetValue(new FilterCondition());
            }
            filterGrid.setEntityNumber(entityType.getName());
        }
        this.getView().updateView(FILTERGRIDAP);
    }
}

