/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.formplugin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.IBillPlugin;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.runtime.ConvertFuncLoader;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msrcs.common.util.EntityUtil;
import kd.mpscmm.msrcs.formplugin.base.BaseFormPlugin;

public class RebateFactorEdit
extends BaseFormPlugin
implements IBillPlugin {
    private static final String CACHEKEY_REBATEFACTOR_SOURCE_BILL_TREENODE = "RebateFactorSourceBillTreeNode";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"formuladesc", "dimformuladesc"});
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.loadMulComboDimension();
        this.setEntryComboDimension();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.loadMulComboDimension();
        this.setEntryComboDimension();
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        switch (control.getKey()) {
            case "formuladesc": {
                this.clickFieldFormula("formuladesc");
                break;
            }
            case "dimformuladesc": {
                this.clickEntryDimFieldFormula("dimformuladesc");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        super.propertyChanged(e);
        switch (proName = e.getProperty().getName()) {
            case "sourcemodel": {
                this.loadMulComboDimension();
                this.setEntryComboDimension();
                break;
            }
            case "statisticdimension": {
                this.getModel().deleteEntryData("entryentity");
                this.setEntryComboDimension();
                break;
            }
        }
    }

    private void loadMulComboDimension() {
        DynamicObject sourceModel = (DynamicObject)this.getModel().getValue("sourcemodel");
        if (sourceModel == null) {
            return;
        }
        List<IDataEntityProperty> rebateProperties = EntityUtil.getEntityAllDefinedField((String)sourceModel.getPkValue());
        this.loadMulComboValue(rebateProperties);
    }

    private void loadMulComboValue(List<IDataEntityProperty> rebateProperties) {
        MulComboEdit mulComboEdit = (MulComboEdit)this.getControl("statisticdimension");
        ArrayList<ComboItem> comboItemlist = new ArrayList<ComboItem>(rebateProperties.size());
        for (IDataEntityProperty prop : rebateProperties) {
            if (prop instanceof QtyProp || prop instanceof AmountProp) continue;
            ComboItem item = new ComboItem(prop.getDisplayName(), prop.getName());
            comboItemlist.add(item);
        }
        mulComboEdit.setComboItems(comboItemlist);
    }

    private void setEntryComboDimension() {
        ArrayList<ComboItem> comboItemlist = new ArrayList<ComboItem>();
        Object mulDimension = this.getModel().getValue("statisticdimension");
        if (mulDimension == null) {
            return;
        }
        List<String> dimensionList = RebateFactorEdit.getMultipleDropValue(String.valueOf(mulDimension));
        DynamicObject sourceModel = (DynamicObject)this.getModel().getValue("sourcemodel");
        if (sourceModel == null) {
            return;
        }
        List<IDataEntityProperty> rebateProperties = EntityUtil.getEntityAllDefinedField((String)sourceModel.getPkValue());
        ComboEdit comboEdit = (ComboEdit)this.getControl("dimension");
        for (IDataEntityProperty prop : rebateProperties) {
            String proName = prop.getName();
            if (dimensionList == null || dimensionList.size() == 0) break;
            if (!dimensionList.contains(proName)) continue;
            ComboItem item = new ComboItem(prop.getDisplayName(), proName);
            comboItemlist.add(item);
            dimensionList.remove(proName);
        }
        comboEdit.setComboItems(comboItemlist);
    }

    private static List<String> getMultipleDropValue(String dropValue) {
        String[] dropValues = dropValue.split(",");
        return Arrays.stream(dropValues).filter(s -> !"".equals(s)).collect(Collectors.toList());
    }

    private void clickFieldFormula(String sourceCtrlKey) {
        String formula;
        String billNodeJson = this.getSourceBillTreeNode();
        if (StringUtils.isEmpty((CharSequence)billNodeJson)) {
            PropTreeBuildOption option = new PropTreeBuildOption();
            option.setIncludePKField(true);
            option.setOnlyPhysicsField(false);
            MainEntityType srcEntityType = RebateFactorEdit.getMainEntityType(this.getModel(), "sourcemodel");
            TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)srcEntityType, (PropTreeBuildOption)option);
            billNodeJson = this.putSourceBillTreeNode(billTreeNode);
        }
        if (StringUtils.isEmpty((CharSequence)(formula = (String)this.getModel().getValue("formula")))) {
            CRFormula crFormula = new CRFormula();
            formula = SerializationUtils.toJsonString((Object)crFormula);
        }
        this.showFormulaForm(formula, this.getSourceEntityNumber(), billNodeJson, sourceCtrlKey);
    }

    private void clickEntryDimFieldFormula(String sourceCtrlKey) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        String dimension = String.valueOf(this.getModel().getValue("dimension", rowIndex));
        MainEntityType srcEntityType = RebateFactorEdit.getMainEntityType(this.getModel(), "sourcemodel");
        IDataEntityProperty pro = srcEntityType.findProperty(dimension);
        if (pro == null) {
            return;
        }
        if (pro instanceof UnitProp) {
            String formId = ((BasedataProp)pro).getBaseEntityId();
            ListShowParameter param = ShowFormHelper.createShowListForm((String)formId, (boolean)false);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
            this.getView().showForm((FormShowParameter)param);
        } else if (pro instanceof BasedataProp) {
            String formId = ((BasedataProp)pro).getBaseEntityId();
            ListShowParameter param = ShowFormHelper.createShowListForm((String)formId, (boolean)false, (int)2, (boolean)true);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
            this.getView().showForm((FormShowParameter)param);
        } else {
            String formula;
            String billNodeJson = this.getSourceBillTreeNode();
            if (StringUtils.isEmpty((CharSequence)billNodeJson)) {
                PropTreeBuildOption option = new PropTreeBuildOption();
                option.setIncludePKField(true);
                TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)srcEntityType, (PropTreeBuildOption)option);
                billNodeJson = this.putSourceBillTreeNode(billTreeNode);
            }
            if (StringUtils.isEmpty((CharSequence)(formula = (String)this.getModel().getValue("dimformula", rowIndex)))) {
                CRFormula crFormula = new CRFormula();
                formula = SerializationUtils.toJsonString((Object)crFormula);
            }
            this.showFormulaForm(formula, this.getSourceEntityNumber(), billNodeJson, sourceCtrlKey + "formula");
        }
    }

    public static MainEntityType getMainEntityType(IDataModel model, String fieldName) {
        DynamicObject entity = model.getDataEntity().getDynamicObject(fieldName);
        if (entity == null) {
            IDataEntityProperty pro = model.getDataEntityType().findProperty(fieldName);
            throw new KDBizException(MessageFormat.format("\u5148\u9009\u62e9\u201c{0}\u201d\u3002", pro.getDisplayName().getLocaleValue()));
        }
        String number = entity.getString("id");
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)number);
        if (type == null) {
            throw new KDBizException(MessageFormat.format("\u5143\u6570\u636e{0}\u5b9e\u4f53\u4e0d\u5b58\u5728\u3002", fieldName));
        }
        return type;
    }

    private void showFormulaForm(String formulaJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_formula");
        showParameter.getCustomParams().put("formula", formulaJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        String funcsXML = this.getFuncsXML();
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public static ListShowParameter openNewList(String caption, String formId, ShowType showType, OperationStatus status, Map<String, Object> customParams) {
        ListShowParameter param = new ListShowParameter();
        if (StringUtils.isNotBlank((CharSequence)caption)) {
            param.setCaption(caption);
        }
        param.setFormId(formId);
        param.getOpenStyle().setShowType(showType);
        if (status != null) {
            param.setStatus(status);
        }
        if (!CollectionUtils.isEmpty(customParams)) {
            for (Map.Entry<String, Object> entry : customParams.entrySet()) {
                param.setCustomParam(entry.getKey(), entry.getValue());
            }
        }
        return param;
    }

    private String getSourceEntityNumber() {
        DynamicObject srcEntityDynObj = this.getF7Value("sourcemodel");
        if (srcEntityDynObj != null) {
            return srcEntityDynObj.getString("id");
        }
        return "";
    }

    @Override
    public DynamicObject getF7Value(String f7Name) {
        return this.getModel().getDataEntity().getDynamicObject(f7Name);
    }

    private String getFuncsXML() {
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isEmpty((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
            FunctionTypes cloudFunc = ConvertFuncLoader.loadBizCloudFuncTypes();
            functionTypes.getFunctionGroups().addAll(cloudFunc.getFunctionGroups());
            functionTypes.getFunctionTypes().addAll(cloudFunc.getFunctionTypes());
        }
        return funcsXML;
    }

    private String getSourceBillTreeNode() {
        return this.getPageCache().get(CACHEKEY_REBATEFACTOR_SOURCE_BILL_TREENODE);
    }

    private String putSourceBillTreeNode(TreeNode billTreeNode) {
        String json = SerializationUtils.toJsonString((Object)billTreeNode);
        this.getPageCache().put(CACHEKEY_REBATEFACTOR_SOURCE_BILL_TREENODE, json);
        return json;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId = e.getActionId()) {
            case "formuladesc": {
                this.receiveFormula(String.valueOf(returnData));
                break;
            }
            case "dimformuladesc": {
                this.receiveEntryDimFormuladesc(returnData);
                break;
            }
            case "dimformuladescformula": {
                this.receiveEntryDimFormula(String.valueOf(returnData));
                break;
            }
        }
    }

    private void receiveFormula(String formulaJson) {
        if (StringUtils.isNotEmpty((CharSequence)formulaJson)) {
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)formulaJson, CRFormula.class);
            this.getModel().setValue("formula", (Object)formulaJson);
            this.getModel().setValue("formuladesc", (Object)formula.getExprDesc());
        }
    }

    private void receiveEntryDimFormuladesc(Object returnData) {
        String selectedRowDatas = "";
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection listSelectedRow = (ListSelectedRowCollection)returnData;
            for (ListSelectedRow selectedRow : listSelectedRow) {
                String pkValue = String.valueOf(selectedRow.getPrimaryKeyValue());
                if (StringUtils.isEmpty((CharSequence)selectedRowDatas)) {
                    selectedRowDatas = pkValue;
                    continue;
                }
                selectedRowDatas = selectedRowDatas + "," + pkValue;
            }
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        this.getModel().setValue("dimformuladesc", (Object)selectedRowDatas, rowIndex);
    }

    private void receiveEntryDimFormula(String formulaJson) {
        if (StringUtils.isNotEmpty((CharSequence)formulaJson)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)formulaJson, CRFormula.class);
            this.getModel().setValue("dimformula", (Object)formulaJson, rowIndex);
            this.getModel().setValue("dimformuladesc", (Object)formula.getExprDesc(), rowIndex);
        }
    }
}

