/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.mpscmm.msrcs.common.pojo.ConditionReceiveValue;
import kd.mpscmm.msrcs.common.util.EntityUtil;
import kd.mpscmm.msrcs.formplugin.base.BaseFormPlugin;

public class RebateOutputEdit
extends BaseFormPlugin {
    private static final String FILTERGRIDAP = "filtergridap";
    private static List<String> INGOREKEYS = Arrays.stream("billno,creator,modifier,auditor,auditdate,modifytime,createtime,changer,version,name".split(",")).collect(Collectors.toList());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"sid", "fieldformuladesc"});
    }

    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
        this.updateRequestFilterCols(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterGrid filterGridCtrl = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        FilterCondition filterCondition = this.loadFilter("filterscheme");
        if (filterCondition != null) {
            filterGridCtrl.SetValue(filterCondition);
            this.getView().updateView(FILTERGRIDAP);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "sourcefieldtype": {
                int row = e.getChangeSet()[0].getRowIndex();
                this.setValue("sid", null, row);
                this.setValue("sname", null, row);
                break;
            }
            case "valuetype": {
                int row = e.getChangeSet()[0].getRowIndex();
                this.setValue("sourcefieldtype", null, row);
                this.setValue("fieldformula", null, row);
                this.setValue("fieldformuladesc", null, row);
                this.setValue("conditionformula", null, row);
                this.setValue("handtype", null, row);
                this.setValue("updatetype", null, row);
                break;
            }
            case "policytarget": {
                this.resetSidSnameOfBotpEntry("policytarget");
                break;
            }
            case "rebateschema": {
                DynamicObject rebateSchema = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (rebateSchema == null) {
                    this.setValue("rebatemodel", null);
                } else {
                    this.setValue("rebatemodel", rebateSchema.getDynamicObject("rebatemodel").getPkValue());
                }
                this.resetSidSnameOfBotpEntry("rebateschema");
                break;
            }
            case "output": {
                this.reSetTargetProperties(true);
                this.updateRequestFilterCols(true);
                break;
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.reSetTargetProperties(false);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.reSetTargetProperties(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": {
                this.beforeSave();
                break;
            }
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        int row = this.getModel().getEntryCurrentRowIndex("botpentry");
        switch (control.getKey()) {
            case "fieldformuladesc": {
                this.onClickFieldFormulaDesc();
                break;
            }
            case "sid": {
                String sourceFieldType = this.getStringValue("sourcefieldtype", row);
                String sourceField = this.getSourceFieldBySourceFieldType(sourceFieldType);
                if (!StringUtils.isNotEmpty((String)sourceField)) break;
                PropTreeBuildOption option = new PropTreeBuildOption();
                switch (sourceField) {
                    case "calresult": 
                    case "rebatemodel": {
                        option.setOnlyPhysicsField(false);
                        break;
                    }
                    default: {
                        option.setIncludePKField(true);
                    }
                }
                if (this.getF7Value(sourceField) == null) break;
                EntityUtil.showSelectEntityFieldForm(this.getView(), (String)this.getF7PKValue(sourceField), option, new CloseCallBack((IFormPlugin)this, sourceField));
                break;
            }
        }
    }

    private void onClickFieldFormulaDesc() {
        int row = this.getModel().getEntryCurrentRowIndex("botpentry");
        String valueType = this.getStringValue("valuetype", row);
        if (StringUtils.isEmpty((String)valueType)) {
            this.getView().showMessage("\u8bf7\u9009\u62e9\u53d6\u503c\u65b9\u5f0f\u3002");
        } else {
            String targetPropName = this.getStringValue("tid", row);
            if (StringUtils.isNotEmpty((String)targetPropName) && this.getF7PKValue("output") != null) {
                String formula = this.getStringValue("fieldformula", row);
                MainEntityType targetMainType = EntityUtil.getMainEntityType((String)this.getF7PKValue("output"));
                IDataEntityProperty targetProperty = targetMainType.findProperty(targetPropName);
                switch (valueType) {
                    case "1": {
                        if (StringUtils.isEmpty((String)formula)) {
                            CRFormula crFormula = new CRFormula();
                            formula = SerializationUtils.toJsonString((Object)crFormula);
                        }
                        EntityUtil.showFormulaForm(this.getView(), this.getPageCache(), formula, (String)this.getF7PKValue("output"), new CloseCallBack((IFormPlugin)this, "fieldformuladesc"));
                        break;
                    }
                    case "3": {
                        if (targetProperty instanceof BasedataProp) {
                            EntityUtil.showF7List((BasedataProp)targetProperty, this.getView(), new CloseCallBack((IFormPlugin)this, "fieldformuladesc"));
                            break;
                        }
                        if (targetProperty instanceof ComboProp) {
                            EntityUtil.showComboForm(this.getView(), (ComboProp)targetProperty, new CloseCallBack((IFormPlugin)this, "fieldformuladesc"));
                            break;
                        }
                        this.getView().showMessage("\u6682\u4e0d\u652f\u6301\u6b64\u7c7b\u578b\u5b57\u6bb5\u5e38\u91cf\u8bbe\u7f6e\u3002");
                        break;
                    }
                    case "2": {
                        if (StringUtils.isEmpty((String)formula)) {
                            CRValByConditions valByConditions = new CRValByConditions();
                            formula = SerializationUtils.toJsonString((Object)valByConditions);
                        }
                        EntityUtil.showValByConditionForm(this.getView(), this.getPageCache(), formula, (String)this.getF7PKValue("output"), targetProperty, new CloseCallBack((IFormPlugin)this, "fieldformuladesc"));
                        break;
                    }
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData != null) {
            switch (e.getActionId()) {
                case "rebatemodel": 
                case "policytarget": 
                case "output": 
                case "calresult": {
                    this.setSoureFieldName((String)returnData, (String)this.getF7PKValue(e.getActionId()));
                    break;
                }
                case "fieldformuladesc": {
                    if (returnData instanceof ListSelectedRowCollection) {
                        this.doReceiceFieldConstant((ListSelectedRowCollection)returnData);
                        break;
                    }
                    this.doReceiveFieldFormula((String)returnData);
                    break;
                }
            }
        }
    }

    private void doReceiceFieldConstant(ListSelectedRowCollection returnData) {
        if (CollectionUtils.isEmpty((Collection)returnData)) {
            return;
        }
        int row = this.getModel().getEntryCurrentRowIndex("botpentry");
        this.getModel().setValue("fieldformula", returnData.get(0).getPrimaryKeyValue(), row);
        this.getModel().setValue("fieldformuladesc", (Object)returnData.get(0).getName(), row);
    }

    private void doReceiveFieldFormula(String returnData) {
        String valueType;
        if (StringUtils.isEmpty((String)returnData)) {
            return;
        }
        int row = this.getModel().getEntryCurrentRowIndex("botpentry");
        switch (valueType = this.getStringValue("valuetype", row)) {
            case "1": {
                this.receiveFormula(returnData, row);
                break;
            }
            case "3": {
                this.receiveConstant(returnData, row);
                break;
            }
            case "2": {
                this.receiveValByCondition(returnData, row);
                break;
            }
        }
    }

    private void receiveFormula(String formulaJson, int row) {
        if (StringUtils.isNotEmpty((String)formulaJson)) {
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)formulaJson, CRFormula.class);
            this.setValue("fieldformula", formulaJson, row);
            this.setValue("fieldformuladesc", formula.getExprDesc(), row);
        }
    }

    private void receiveConstant(String formulaJson, int row) {
        if (StringUtils.isNotEmpty((String)formulaJson)) {
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)formulaJson, CRFormula.class);
            this.getModel().setValue("fieldformula", (Object)formula.getExpression(), row);
            this.getModel().setValue("fieldformuladesc", (Object)formula.getExprDesc(), row);
        }
    }

    private void receiveValByCondition(String json, int row) {
        String formId = (String)this.getF7PKValue("output");
        if (StringUtils.isNotEmpty((String)json) && StringUtils.isNotEmpty((String)formId)) {
            try {
                ConditionReceiveValue conditionReceiveValue = EntityUtil.receiveValByCondition(formId, json);
                if (conditionReceiveValue != null) {
                    this.setValue("fieldformula", conditionReceiveValue.getFieldFormula(), row);
                    this.setValue("fieldformuladesc", conditionReceiveValue.getFieldFormulaDesc(), row);
                    this.setValue("conditionformula", conditionReceiveValue.getConditionFormula(), row);
                }
            }
            catch (KDBizException e) {
                this.getView().showMessage(e.getMessage());
            }
        }
    }

    private String getSourceFieldBySourceFieldType(String sourceFieldType) {
        String sourceField = "";
        if (StringUtils.isNotEmpty((String)sourceFieldType)) {
            switch (sourceFieldType) {
                case "A": {
                    sourceField = "rebatemodel";
                    break;
                }
                case "B": {
                    sourceField = "policytarget";
                    break;
                }
                case "C": {
                    sourceField = "output";
                    break;
                }
                case "D": {
                    sourceField = "calresult";
                    break;
                }
            }
        }
        return sourceField;
    }

    private void setSoureFieldName(String field, String sourceFieldFormId) {
        MainEntityType billEntity = EntityUtil.getMainEntityType(sourceFieldFormId);
        int row = this.getModel().getEntryCurrentRowIndex("botpentry");
        this.setValue("sid", field, row);
        this.setValue("sname", EntityUtil.getColFullName(billEntity, field), row);
    }

    private final void reSetTargetProperties(boolean isReset) {
        if (this.getF7Value("output") == null && isReset) {
            this.getModel().deleteEntryData("botpentry");
            return;
        }
        String outputFormId = (String)this.getF7PKValue("output");
        List<IDataEntityProperty> properties = EntityUtil.getEntityAllDefinedField(outputFormId);
        if (properties == null) {
            return;
        }
        DynamicObjectCollection botpEntryData = this.getModel().getEntryEntity("botpentry");
        if (isReset) {
            botpEntryData.clear();
        }
        Map<String, DynamicObject> tid2BotpEntryMap = botpEntryData.stream().collect(Collectors.toMap(r -> r.getString("tid"), r -> r));
        boolean isRebatePreBudget = "occpic_rebateprebudget".equals(outputFormId);
        for (IDataEntityProperty property : properties) {
            if (isRebatePreBudget && INGOREKEYS.contains(property.getName())) continue;
            String tid = property.getName();
            String tName = EntityUtil.getColFullName(EntityUtil.getMainEntityType(outputFormId), property.getName());
            DynamicObject botpEntry = tid2BotpEntryMap.get(tid);
            if (botpEntry != null) {
                if (botpEntry.getString("tname").equals(tName)) continue;
                botpEntry.set("tname", (Object)tName);
                continue;
            }
            DynamicObject botpRowData = botpEntryData.addNew();
            botpRowData.set("tname", (Object)EntityUtil.getColFullName(EntityUtil.getMainEntityType(outputFormId), property.getName()));
            botpRowData.set("tid", (Object)property.getName());
        }
        this.getView().updateView("botpentry");
    }

    private FilterCondition loadFilter(String ctrlName) {
        String filter = this.getStringValue(ctrlName);
        if (StringUtils.isEmpty((String)filter)) {
            return null;
        }
        return (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
    }

    private void updateRequestFilterCols(boolean changed) {
        MainEntityType entityType = this.getOutputMainEntityType();
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        if (entityType == null) {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFilterColumns(new ArrayList(0));
            filterGrid.setEntityNumber("");
        } else {
            if (changed) {
                filterGrid.SetValue(new FilterCondition());
            }
            filterGrid.setEntityNumber(entityType.getName());
        }
        this.getView().updateView(FILTERGRIDAP);
    }

    private MainEntityType getOutputMainEntityType() {
        IDataModel model = this.getModel();
        DynamicObject requireBill = model.getDataEntity().getDynamicObject("output");
        if (requireBill == null) {
            return null;
        }
        String metaDataNo = requireBill.getString("number");
        return EntityMetadataCache.getDataEntityType((String)metaDataNo);
    }

    private void beforeSave() {
        IDataModel model = this.getModel();
        String requestFilter = this.getRequestFilterStr();
        model.setValue("filterscheme", (Object)requestFilter);
    }

    private String getRequestFilterStr() {
        FilterGrid grid = (FilterGrid)this.getControl(FILTERGRIDAP);
        if (grid == null) {
            return null;
        }
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        return SerializationUtils.toJsonString((Object)condition);
    }

    private void resetSidSnameOfBotpEntry(String key) {
        DynamicObjectCollection entryCol;
        String sourceFieldType = null;
        if ("policytarget".equals(key)) {
            sourceFieldType = "B";
        } else if ("rebateschema".equals(key)) {
            sourceFieldType = "A";
        }
        if (sourceFieldType != null && sourceFieldType.length() > 0 && !CollectionUtils.isEmpty((Collection)(entryCol = this.getModel().getEntryEntity("botpentry")))) {
            for (DynamicObject entry : entryCol) {
                int row = entry.getInt("seq") - 1;
                if (!"0".equals(this.getStringValue("valuetype", row)) || !sourceFieldType.equals(this.getStringValue("sourcefieldtype", row))) continue;
                this.setValue("sid", null, row);
                this.setValue("sname", null, row);
            }
        }
    }
}

