/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msrcs.formplugin.base.BaseFormPlugin;

public class RebateSchemaEdit
extends BaseFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "rebatesource");
        this.addClickListeners(new String[]{"qfilter"});
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        switch (control.getKey()) {
            case "qfilter": {
                this.clickFsSet(e);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection sourceCol = data.getDynamicObjectCollection("sourceentity");
        for (DynamicObject sourceEntry : sourceCol) {
            String dataFs = sourceEntry.getString("qfitlerstr_tag");
            if (!StringUtils.isNotEmpty((String)dataFs)) continue;
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)dataFs, CRCondition.class);
            sourceEntry.set("qfilter", (Object)condition.getExprDesc());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "rebatesource": {
                DynamicObject rebateSource = (DynamicObject)e.getChangeSet()[0].getNewValue();
                int rowindex = e.getChangeSet()[0].getRowIndex();
                if (rebateSource == null) {
                    this.setValue("srcbill", null, rowindex);
                } else {
                    this.setValue("srcbill", rebateSource.getDynamicObject("srcbill").getPkValue(), rowindex);
                }
                this.setValue("qfilter", null, rowindex);
                this.setValue("qfitlerstr_tag", null, rowindex);
                break;
            }
            case "rebatemodel": {
                this.getModel().deleteEntryData("sourceentity");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        if (returnData != null) {
            switch (e.getActionId()) {
                case "qfilter": {
                    this.closedFsSet((String)returnData);
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "rebatesource": {
                DynamicObject rebateModel = this.getF7Value("rebatemodel");
                if (rebateModel == null) {
                    this.getView().showMessage("\u8bf7\u9009\u62e9\u8fd4\u5229\u8ba1\u7b97\u6a21\u578b\u3002");
                    e.setCancel(true);
                    break;
                }
                e.addCustomQFilter(new QFilter("rebatemodel", "=", rebateModel.getPkValue()));
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryName;
        super.beforeDeleteRow(e);
        switch (entryName = e.getEntryProp().getName()) {
            case "judgestandardentity": {
                int[] rowIndexes;
                for (int rowIndex : rowIndexes = e.getRowIndexs()) {
                    DynamicObject rowEntry = this.getModel().getEntryRowEntity("judgestandardentity", rowIndex);
                    boolean isPreset = rowEntry.getBoolean("judgeispreset");
                    if (!isPreset) continue;
                    e.setCancel(true);
                    this.getView().showTipNotification("\u9884\u7f6e\u884c\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002");
                    return;
                }
                break;
            }
            case "calformulaentity": {
                int[] rowIndexes;
                for (int rowIndex : rowIndexes = e.getRowIndexs()) {
                    DynamicObject rowEntry = this.getModel().getEntryRowEntity("calformulaentity", rowIndex);
                    boolean isPreset = rowEntry.getBoolean("calispreset");
                    if (!isPreset) continue;
                    e.setCancel(true);
                    this.getView().showTipNotification("\u9884\u7f6e\u884c\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002");
                    return;
                }
                break;
            }
            case "sourceentity": {
                int[] rowIndexes;
                for (int rowIndex : rowIndexes = e.getRowIndexs()) {
                    DynamicObject rowEntry = this.getModel().getEntryRowEntity("sourceentity", rowIndex);
                    boolean isPreset = rowEntry.getBoolean("sourceispreset");
                    if (!isPreset) continue;
                    e.setCancel(true);
                    this.getView().showTipNotification("\u9884\u7f6e\u884c\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002");
                    return;
                }
                break;
            }
        }
    }

    private void clickFsSet(EventObject e) {
        int row = this.getModel().getEntryCurrentRowIndex("sourceentity");
        DynamicObject srcEntity = this.getF7Value("srcbill", row);
        if (srcEntity == null) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002");
            return;
        }
        MainEntityType srcType = MetadataServiceHelper.getDataEntityType((String)((String)srcEntity.getPkValue()));
        String conditionJson = this.getStringValue("qfitlerstr_tag", row);
        TreeNode tree = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)srcType, null);
        String jsonTree = SerializationUtils.toJsonString((Object)tree);
        this.showConditionForm(conditionJson, srcType.getName(), jsonTree, "qfilter");
    }

    private void showConditionForm(String conditionJson, String entityNumber, String fieldNodes, String fieldKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.setCustomParam("formula", (Object)conditionJson);
        showParameter.setCustomParam("entitynumber", (Object)entityNumber);
        showParameter.setCustomParam("treenodes", (Object)fieldNodes);
        String funcsXML = "";
        showParameter.setCustomParam("functiontypes", (Object)funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void closedFsSet(String conditionJson) {
        if (StringUtils.isNotEmpty((String)conditionJson)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            String expression = condition.getExpression();
            if (StringUtils.isNotEmpty((String)expression)) {
                this.getView().showTipNotification("\u201c\u9ad8\u7ea7\u201d\u8fc7\u6ee4\u6761\u4ef6\u6682\u4e0d\u652f\u6301\uff0c\u8bf7\u5173\u6ce8\u540e\u7eed\u7248\u672c");
                return;
            }
            int row = this.getModel().getEntryCurrentRowIndex("sourceentity");
            this.setValue("qfilter", condition.getExprDesc(), row);
            this.setValue("qfitlerstr_tag", conditionJson, row);
        }
    }
}

