/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.message.service.pa.util.StringUtil;
import kd.mpscmm.msrcs.common.util.EntityUtil;
import kd.mpscmm.msrcs.formplugin.base.BaseFormPlugin;

public class RebateSourceEdit
extends BaseFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"srcpropname"});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.refreshEntry();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.refreshEntry();
    }

    private void refreshEntry() {
        DynamicObject rebateModel = (DynamicObject)this.getModel().getValue("rebatemodel");
        if (rebateModel != null) {
            boolean isChanged = false;
            Map<String, IDataEntityProperty> rebateModelPropertiesMap = EntityUtil.getEntityAllFields(rebateModel.getPkValue().toString());
            DynamicObjectCollection entryCol = this.getModel().getEntryEntity("entity");
            MainEntityType billEntity = EntityUtil.getMainEntityType(EntityUtil.getFormIdByField(this.getModel(), "srcbill"));
            for (DynamicObject entry : entryCol) {
                IDataEntityProperty rebateModelProperty = rebateModelPropertiesMap.get(entry.get("modelpropid"));
                if (rebateModelProperty != null) {
                    rebateModelPropertiesMap.remove(entry.get("modelpropid"));
                    if (!rebateModelProperty.getDisplayName().equals((Object)entry.getString("modelpropname"))) {
                        entry.set("modelpropname", (Object)rebateModelProperty.getDisplayName());
                        isChanged = true;
                    }
                }
                if (!StringUtil.isNotEmpty((String)entry.getString("srcpropid")) || EntityUtil.getColFullName(billEntity, entry.getString("srcpropid")).equals(entry.getString("srcpropname"))) continue;
                entry.set("srcpropname", (Object)EntityUtil.getColFullName(billEntity, entry.getString("srcpropid")));
                isChanged = true;
            }
            if (!rebateModelPropertiesMap.isEmpty()) {
                for (Map.Entry<String, IDataEntityProperty> rebateModelPropertiesEntry : rebateModelPropertiesMap.entrySet()) {
                    DynamicObject newEntry = entryCol.addNew();
                    newEntry.set("modelpropid", (Object)rebateModelPropertiesEntry.getKey());
                    newEntry.set("modelpropname", (Object)rebateModelPropertiesEntry.getValue().getDisplayName());
                }
                isChanged = true;
            }
            if (isChanged) {
                this.getView().updateView("entity");
            }
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        switch (control.getKey()) {
            case "srcpropname": {
                EntityUtil.showSelectEntityFieldForm(this.getView(), EntityUtil.getFormIdByField(this.getModel(), "srcbill"), null, new CloseCallBack((IFormPlugin)this, "srcpropname"));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "rebatemodel": {
                this.loadRebateModel();
                break;
            }
            case "srcpropname": {
                if (e.getChangeSet()[0].getNewValue() != null && !e.getChangeSet()[0].getNewValue().toString().equals("")) break;
                this.setValue("srcpropid", "", e.getChangeSet()[0].getRowIndex());
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData != null) {
            switch (e.getActionId()) {
                case "srcpropname": {
                    this.callBack4SourceFieldCol((String)returnData);
                }
            }
        }
    }

    private void loadRebateModel() {
        this.getModel().getDataEntity(true).getDynamicObjectCollection("entity").clear();
        DynamicObject rebateModel = this.getF7Value("rebatemodel");
        if (rebateModel != null) {
            List<IDataEntityProperty> rebateProperties = EntityUtil.getEntityAllDefinedField((String)rebateModel.getPkValue());
            DynamicObjectCollection entryCol = this.getModel().getEntryEntity("entity");
            for (IDataEntityProperty rebatePropertie : rebateProperties) {
                DynamicObject entry = entryCol.addNew();
                entry.set("modelpropname", (Object)rebatePropertie.getDisplayName());
                entry.set("modelpropid", (Object)rebatePropertie.getName());
            }
        }
        this.getView().updateView("entity");
    }

    private void callBack4SourceFieldCol(String field) {
        if (!StringUtil.isEmpty((String)field)) {
            MainEntityType billEntity = EntityUtil.getMainEntityType(EntityUtil.getFormIdByField(this.getModel(), "srcbill"));
            int row = this.getModel().getEntryCurrentRowIndex("entity");
            this.setValue("srcpropid", field, row);
            this.setValue("srcpropname", EntityUtil.getColFullName(billEntity, field), row);
        }
    }
}

