/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.formplugin.log;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msrcs.engine.common.TaskStatusManager;
import kd.mpscmm.msrcs.formplugin.base.BaseListPlugin;
import kd.mpscmm.msrcs.task.RebateCalculateHelper;

public class MsrcsTaskListPlugin
extends BaseListPlugin {
    private static final String OP_ShowSubTask = "showsubtask";
    private static final String OP_ClearRunStatus = "clearrunstatus";
    private static final String OP_RunChannelCustomer = "run_channel_customer";

    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        if (evt.getFieldName().equalsIgnoreCase("taskno")) {
            String taskNo = this.getTaskNo(this.getListView().getCurrentSelectedRowInfo().getPrimaryKeyValue());
            this.showTaskDetailInfo(taskNo);
            evt.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "showsubtask": {
                this.showTaskDetailInfo();
                break;
            }
            case "clearrunstatus": {
                this.clearnRunStatus();
                break;
            }
            case "run_channel_customer": {
                this.runChannelCustomer();
            }
        }
    }

    private void showTaskDetailInfo() {
        String taskNo = this.getTaskNo(this.getListView().getCurrentSelectedRowInfo().getPrimaryKeyValue());
        this.showTaskDetailInfo(taskNo);
    }

    private void clearnRunStatus() {
        TaskStatusManager.endRun("test_rebate");
        TaskStatusManager.endRun("rebate_channel_occpic_rebatetarget");
        this.getView().showSuccessNotification("\u6e05\u9664\u6210\u529f");
    }

    private void runChannelCustomer() {
        RebateCalculateHelper.executeRebateTask("occpic_rebatetarget", new Object[0]);
        this.getView().invokeOperation("refresh");
    }

    private void showTaskDetailInfo(String mainTaskNo) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setHasRight(true);
        parameter.setAppId("msrcs");
        parameter.setBillFormId("msrcs_subtask");
        parameter.setCustomParam("mainTaskNo", (Object)mainTaskNo);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private String getTaskNo(Object id) {
        QFilter filter = new QFilter("id", "=", id);
        DynamicObject data = QueryServiceHelper.queryOne((String)"msrcs_task", (String)"taskno", (QFilter[])filter.toArray());
        if (data == null) {
            throw new KDBizException("\u6ca1\u6709\u627e\u5230\u4efb\u52a1");
        }
        return data.getString("taskno");
    }
}

