/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msrcs.common.util.DynamicObjectUtils;

public class RebateOutputUniqeValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntityArray = this.getDataEntities();
        String operateKey = this.getOperateKey();
        this.checkUniqe(extendedDataEntityArray, operateKey);
    }

    private void checkUniqe(ExtendedDataEntity[] extendedDataEntityArray, String operateKey) {
        Map<String, List<ExtendedDataEntity>> map;
        if (extendedDataEntityArray != null && extendedDataEntityArray.length > 0 && !CollectionUtils.isEmpty(map = this.groupByEnableRebateModel(extendedDataEntityArray, operateKey))) {
            HashMap<String, ExtendedDataEntity> rebateModel2OutputMap = new HashMap<String, ExtendedDataEntity>();
            for (List<ExtendedDataEntity> extendedDataEntityList : map.values()) {
                if (extendedDataEntityList.size() > 1) {
                    for (ExtendedDataEntity extendedDataEntity : extendedDataEntityList) {
                        this.addErrorMessage(extendedDataEntity, this.buildErrorMessage(operateKey));
                    }
                    continue;
                }
                for (ExtendedDataEntity extendedDataEntity : extendedDataEntityList) {
                    rebateModel2OutputMap.put(this.getKey(extendedDataEntity.getDataEntity()), extendedDataEntity);
                }
            }
            if (!CollectionUtils.isEmpty(rebateModel2OutputMap)) {
                String plicytargetId;
                long rebateSchemalId;
                QFilter qFilter = new QFilter("enable", "=", (Object)"1");
                QFilter tempQfilter = null;
                for (String key : rebateModel2OutputMap.keySet()) {
                    String[] keyArray = key.split("#");
                    rebateSchemalId = Long.parseLong(keyArray[0]);
                    plicytargetId = keyArray[1];
                    if (tempQfilter == null) {
                        tempQfilter = new QFilter("rebateschema", "=", (Object)rebateSchemalId).and("policytarget", "=", (Object)plicytargetId);
                        continue;
                    }
                    tempQfilter = tempQfilter.or(new QFilter("rebateschema", "=", (Object)rebateSchemalId).and("policytarget", "=", (Object)plicytargetId));
                }
                qFilter.and(tempQfilter);
                DynamicObjectCollection rebateModelOutputCol = QueryServiceHelper.query((String)"msrcs_rebateoutput", (String)String.join((CharSequence)",", "id", "rebateschema", "policytarget"), (QFilter[])qFilter.toArray());
                for (DynamicObject rebateModelOutput : rebateModelOutputCol) {
                    ExtendedDataEntity extendedDataEntity;
                    rebateSchemalId = rebateModelOutput.getLong("rebateschema");
                    plicytargetId = rebateModelOutput.getString("policytarget");
                    String key = String.join((CharSequence)"#", String.valueOf(rebateSchemalId), plicytargetId);
                    long id = rebateModelOutput.getLong("id");
                    if (id == (extendedDataEntity = (ExtendedDataEntity)rebateModel2OutputMap.get(key)).getDataEntity().getLong("id")) continue;
                    this.addErrorMessage(extendedDataEntity, this.buildErrorMessage(operateKey));
                }
            }
        }
    }

    private Map<String, List<ExtendedDataEntity>> groupByEnableRebateModel(ExtendedDataEntity[] extendedDataEntityArray, String operateKey) {
        HashMap<String, List<ExtendedDataEntity>> map = new HashMap<String, List<ExtendedDataEntity>>(extendedDataEntityArray.length);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String enable = dataEntity.getString("enable");
            if ("enable".equals(this.getOperateKey())) {
                if (!"0".equals(enable)) continue;
                this.buildMap(map, extendedDataEntity, dataEntity);
                continue;
            }
            if (!"1".equals(enable)) continue;
            this.buildMap(map, extendedDataEntity, dataEntity);
        }
        return map;
    }

    private void buildMap(Map<String, List<ExtendedDataEntity>> map, ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        String key = this.getKey(dataEntity);
        List<ExtendedDataEntity> extendedDataEntityList = map.get(key);
        if (extendedDataEntityList == null) {
            extendedDataEntityList = new ArrayList<ExtendedDataEntity>();
            extendedDataEntityList.add(extendedDataEntity);
            map.put(key, extendedDataEntityList);
        } else {
            extendedDataEntityList.add(extendedDataEntity);
        }
    }

    private String getKey(DynamicObject dataEntity) {
        long rebateSchemalId = DynamicObjectUtils.getDynamicObjectLPkValue(dataEntity, "rebateschema");
        String plicytargetId = DynamicObjectUtils.getDynamicObjectSPkValue(dataEntity, "policytarget");
        return String.join((CharSequence)"#", String.valueOf(rebateSchemalId), plicytargetId);
    }

    private String buildErrorMessage(String operateKey) {
        String message = "\u5df2\u5b58\u5728\u76f8\u540c\u8fd4\u5229\u8ba1\u7b97\u65b9\u6848\u3001\u653f\u7b56\u5bf9\u8c61 \u542f\u7528\u72b6\u6001\u7684\u8fd4\u5229\u8ba1\u7b97\u8f93\u51fa\u89c4\u5219";
        message = "enable".equals(operateKey) ? message + "\uff0c\u4e0d\u5141\u8bb8\u542f\u7528\u3002" : message + "\uff0c\u8bf7\u4fee\u6539\u3002";
        return message;
    }
}

