/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msrcs.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msrcs.business.ExtPointServiceHelper;
import kd.mpscmm.msrcs.business.policyparserule.PolicyParseRuleHelper;
import kd.mpscmm.msrcs.common.util.CollectionUtil;
import kd.mpscmm.msrcs.common.util.DateUtil;
import kd.mpscmm.msrcs.common.util.DynamicObjectUtils;
import kd.mpscmm.msrcs.common.util.QueryUtil;
import kd.mpscmm.msrcs.engine.RebateEngine;
import kd.mpscmm.msrcs.engine.enginer.Kpi;
import kd.mpscmm.msrcs.engine.enginer.Ladder;
import kd.mpscmm.msrcs.engine.enginer.RebateTaskInfo;
import kd.sdk.mpscmm.msrcs.extpoint.IRebatePlugin;

public class RebateCalculateHelper {
    private static Log logger = LogFactory.getLog(RebateCalculateHelper.class);
    private static final int MAXCALCULATEBATHCHSIZE = 5000;

    private RebateCalculateHelper() {
    }

    public static final void executeRebateTask(String rebateTargetFormId, Object ... rebateTargetIdArray) {
        DynamicObject[] targetArray = null;
        if (rebateTargetIdArray != null && rebateTargetIdArray.length > 0) {
            targetArray = QueryUtil.loadArray(rebateTargetIdArray, rebateTargetFormId, new String[0]);
        } else {
            RebateCalculateHelper.updateRebateTargetCalculateStatus(rebateTargetFormId);
            targetArray = RebateCalculateHelper.loadRebateTargetArray(rebateTargetFormId);
        }
        if (targetArray != null && targetArray.length > 0) {
            RebateTaskInfo[] rebateTaskArray = RebateCalculateHelper.buildRebateTaskInfoArray(targetArray, rebateTargetFormId, ExtPointServiceHelper.getTargetGroupRebatePluginProxy());
            RebateEngine rebateEngine = RebateEngine.get("rebate_channel_" + rebateTargetFormId);
            for (RebateTaskInfo rebateTaskInfo : rebateTaskArray) {
                rebateEngine.addTask(rebateTaskInfo);
            }
            rebateEngine.run();
        }
    }

    public static final void updateRebateTargetCalculateStatus(String rebateTargetFormId) {
        Date now = KDDateUtils.now();
        QFilter qf = new QFilter("calculatestatus", "not in", (Object)new Object[]{"B", "C", "D"});
        qf.and("endtime", ">=", (Object)now);
        qf.and("starttime", "<=", (Object)now);
        DynamicObject[] rebateTargetArray = BusinessDataServiceHelper.load((String)rebateTargetFormId, (String)"calculatestatus", (QFilter[])qf.toArray());
        if (rebateTargetArray != null && rebateTargetArray.length > 0) {
            for (DynamicObject rebateTarget : rebateTargetArray) {
                rebateTarget.set("calculatestatus", (Object)"B");
            }
            SaveServiceHelper.save((DynamicObject[])rebateTargetArray);
        }
    }

    public static final DynamicObject[] loadRebateTargetArray(String rebateTargetFormId) {
        QFilter qf = new QFilter("billstatus", "=", (Object)"C");
        qf.and("calculatestatus", "=", (Object)"B");
        return QueryUtil.load(rebateTargetFormId, qf.toArray(), new String[0]);
    }

    public static final RebateTaskInfo[] buildRebateTaskInfoArray(DynamicObject[] rebateTargetArray, String rebateTargetFormId, PluginProxy<IRebatePlugin> pluginProxy) {
        Map<String, List<DynamicObject>> targetMap = RebateCalculateHelper.getCalculateTargetMap(rebateTargetArray, pluginProxy);
        ArrayList<RebateTaskInfo> rebateTaskList = new ArrayList<RebateTaskInfo>(targetMap.size() * 10);
        for (List<DynamicObject> targetList : targetMap.values()) {
            Map<DynamicObject, List<DynamicObject>> groupByPolicyParseRuleTargetListMap = PolicyParseRuleHelper.getParseIdTargetDosMap(targetList);
            for (Map.Entry<DynamicObject, List<DynamicObject>> groupByPolicyParseRuleTargetListEntry : groupByPolicyParseRuleTargetListMap.entrySet()) {
                DynamicObject policyParseRule = groupByPolicyParseRuleTargetListEntry.getKey();
                long policyParseRuleId = policyParseRule.getLong("id");
                List<DynamicObject> tempTargetList = groupByPolicyParseRuleTargetListEntry.getValue();
                if (policyParseRuleId > 0L) {
                    for (List<DynamicObject> splitedtargetList : CollectionUtil.splitList(tempTargetList, 5000)) {
                        RebateCalculateHelper.buildRebateTask(rebateTargetFormId, splitedtargetList, rebateTaskList, policyParseRule);
                    }
                    continue;
                }
                String targetNumberStr = String.join((CharSequence)",", (CharSequence[])tempTargetList.stream().map(r -> r.getString("billno")).limit(100L).toArray(String[]::new));
                String targetNumberStrPostfix = tempTargetList.size() > 100 ? " ..." : "";
                logger.error(String.format("\u8fd4\u5229\u8c03\u5ea6\u8ba1\u5212\u6267\u884c\u51fa\u73b0\u9519\u8bef : \u653f\u7b56\u76ee\u6807(%1$s%2$s)\u6ca1\u6709\u67e5\u627e\u5230\u5339\u914d\u7684\u653f\u7b56\u89e3\u6790\u89c4\u5219\uff0c\u5df2\u9000\u51fa\u8fd4\u5229\u8ba1\u7b97\u3002", targetNumberStr, targetNumberStrPostfix));
            }
        }
        return (RebateTaskInfo[])rebateTaskList.stream().toArray(RebateTaskInfo[]::new);
    }

    private static final void buildRebateTask(String rebateTargetFormId, List<DynamicObject> targetList, List<RebateTaskInfo> rebateTaskList, DynamicObject policyParseRule) {
        if (!CollectionUtils.isEmpty(targetList)) {
            DynamicObject target = targetList.get(0);
            long judgeBasisId = DynamicObjectUtils.getDynamicObjectLPkValue(target, "nladdertype");
            long rebateCalcFormulaId = DynamicObjectUtils.getDynamicObjectLPkValue(target, "nrebatetype");
            long rebateClassId = DynamicObjectUtils.getDynamicObjectLPkValue(target, "nrebateclass");
            QFilter condition = PolicyParseRuleHelper.buildConditionMatchHeaderFilter(policyParseRule, target);
            long currencyId = DynamicObjectUtils.getDynamicObjectLPkValue(target, "currency");
            RebateTaskInfo rebateTaskInfo = RebateTaskInfo.newInstance(rebateTargetFormId, condition, rebateClassId, judgeBasisId, rebateCalcFormulaId, currencyId);
            rebateTaskInfo.setKpiList(RebateCalculateHelper.buildKpiList(target, policyParseRule));
            rebateTaskInfo.setRebateObjectIds(PolicyParseRuleHelper.getRebateFieldTargetIdMap(policyParseRule, targetList));
            rebateTaskList.add(rebateTaskInfo);
        }
    }

    private static final List<Kpi> buildKpiList(DynamicObject target, DynamicObject policyParseRule) {
        String calScopeType = target.getString("calscopetype");
        Map<String, String> sourceFieldEntryKeyMap = PolicyParseRuleHelper.getSourceFieldEntryKeyMap(target);
        List<Object> kpiList = new ArrayList(0);
        if ("A".equals(calScopeType)) {
            kpiList = RebateCalculateHelper.buildCalAllTargetKpiList(target, sourceFieldEntryKeyMap, policyParseRule);
        } else if ("B".equals(calScopeType)) {
            kpiList = RebateCalculateHelper.buildCalGroupTargetKpiList(target, sourceFieldEntryKeyMap, policyParseRule);
        }
        return kpiList;
    }

    private static final List<Kpi> buildCalGroupTargetKpiList(DynamicObject target, Map<String, String> sourceFieldEntryKeyMap, DynamicObject policyParseRule) {
        String ladderIdentifier = "itemformulaentity";
        DynamicObjectCollection entries = target.getDynamicObjectCollection(ladderIdentifier);
        ArrayList<Kpi> kpiList = new ArrayList<Kpi>(entries.size());
        if (!CollectionUtils.isEmpty((Collection)entries)) {
            Map<Integer, List<DynamicObject>> map = entries.stream().collect(Collectors.groupingBy(r -> r.getInt("group")));
            for (Map.Entry<Integer, List<DynamicObject>> entry : map.entrySet()) {
                Kpi kpi = Kpi.newGroupInstance(entry.getKey());
                kpi.setLadderIdentifier(ladderIdentifier);
                List<DynamicObject> groupedEntryList = entry.getValue();
                ArrayList<Ladder> ladderList = new ArrayList<Ladder>(groupedEntryList.size());
                for (DynamicObject groupedEntry : groupedEntryList) {
                    if (kpi.getGroupCondition() == null) {
                        QFilter groupCondition = PolicyParseRuleHelper.buildConditionMatchConditionGroupFilter(policyParseRule, DynamicObjectUtils.getDynamicObjectLPkValue(groupedEntry, "conditongroup"));
                        kpi.setGroupCondition(groupCondition);
                    }
                    ladderList.add(RebateCalculateHelper.buildLadder(groupedEntry, sourceFieldEntryKeyMap));
                }
                kpi.setLadderList(ladderList);
                kpiList.add(kpi);
            }
        }
        return kpiList;
    }

    private static final List<Kpi> buildCalAllTargetKpiList(DynamicObject target, Map<String, String> sourceFieldEntryKeyMap, DynamicObject policyParseRule) {
        String ladderIdentifier = "formulaentity";
        ArrayList<Kpi> kpiList = new ArrayList<Kpi>(1);
        List entryList = target.getDynamicObjectCollection(ladderIdentifier).stream().collect(Collectors.toList());
        Kpi kpi = new Kpi();
        kpi.setLadderIdentifier(ladderIdentifier);
        QFilter groupCondition = PolicyParseRuleHelper.buildConditionMatchItemRangeEntryFilter(policyParseRule, target);
        kpi.setGroupCondition(groupCondition);
        ArrayList<Ladder> ladderList = new ArrayList<Ladder>(entryList.size());
        Map<String, Object> headLadder = RebateCalculateHelper.buildHeadLadder(target, sourceFieldEntryKeyMap);
        for (DynamicObject entry : entryList) {
            Ladder ladder = RebateCalculateHelper.buildLadder(entry, sourceFieldEntryKeyMap);
            RebateCalculateHelper.buildHeadLadder(ladder, headLadder);
            ladderList.add(ladder);
        }
        kpi.setLadderList(ladderList);
        kpiList.add(kpi);
        return kpiList;
    }

    private static final void buildHeadLadder(Ladder ladder, Map<String, Object> headLadder) {
        if (ladder != null && !CollectionUtils.isEmpty(headLadder)) {
            for (Map.Entry<String, Object> headLadderEntry : headLadder.entrySet()) {
                ladder.put(headLadderEntry.getKey(), headLadderEntry.getValue());
            }
        }
    }

    private static final Map<String, Object> buildHeadLadder(DynamicObject target, Map<String, String> sourceFieldEntryKeyMap) {
        HashMap<String, Object> headLadder = new HashMap<String, Object>(0);
        if (target != null && !CollectionUtils.isEmpty(sourceFieldEntryKeyMap)) {
            headLadder = new HashMap(sourceFieldEntryKeyMap.size());
            for (Map.Entry<String, String> sourceFieldEntryKeyEntry : sourceFieldEntryKeyMap.entrySet()) {
                if (!StringUtils.isEmpty((String)sourceFieldEntryKeyEntry.getValue())) continue;
                String ladderKey = sourceFieldEntryKeyEntry.getKey();
                Object ladderValue = target.get(ladderKey);
                headLadder.put(ladderKey, ladderValue);
            }
        }
        return headLadder;
    }

    private static final Ladder buildLadder(DynamicObject entityObject, Map<String, String> sourceFieldEntryKeyMap) {
        DataEntityPropertyCollection properties = entityObject.getDynamicObjectType().getProperties();
        Ladder ladder = new Ladder();
        for (IDataEntityProperty property : properties) {
            String propertyName = property.getName();
            if (!sourceFieldEntryKeyMap.containsKey(propertyName)) continue;
            ladder.put(property.getName(), entityObject.get(property.getName()));
        }
        return ladder;
    }

    private static final Map<String, List<DynamicObject>> getCalculateTargetMap(DynamicObject[] targetArray, PluginProxy<IRebatePlugin> pluginProxy) {
        if (targetArray != null && targetArray.length > 0) {
            return Arrays.stream(targetArray).collect(Collectors.groupingBy(r -> RebateCalculateHelper.buildTargetGroupKey(r, pluginProxy)));
        }
        return new HashMap<String, List<DynamicObject>>(0);
    }

    private static final String buildTargetGroupKey(DynamicObject target, PluginProxy<IRebatePlugin> pluginProxy) {
        String targetGroupKey = null;
        if (pluginProxy != null && !pluginProxy.getPlugins().isEmpty()) {
            try {
                List targetGroupKeyList = pluginProxy.callReplaceIfPresent(p -> p.buildTargetGroupKey(target));
                if (!CollectionUtils.isEmpty((Collection)targetGroupKeyList)) {
                    targetGroupKey = String.join((CharSequence)"#", (CharSequence[])targetGroupKeyList.stream().filter(r -> StringUtils.isNotEmpty((String)r)).toArray(String[]::new));
                }
            }
            catch (Exception e) {
                logger.error("\u4e1a\u52a1\u6269\u5c55\u573a\u666f-\u8fd4\u5229\u653f\u7b56\u76ee\u6807\u5206\u7ec4 \u6267\u884c\u51fa\u9519:", (Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("RebateCalculateHelper.buildTargetGroupKey", "\u4e1a\u52a1\u6269\u5c55\u573a\u666f-\u8fd4\u5229\u653f\u7b56\u76ee\u6807\u5206\u7ec4 \u6267\u884c\u51fa\u9519"), new Object[0]);
            }
        }
        return StringUtils.isEmpty(targetGroupKey) ? String.join((CharSequence)"#", String.valueOf(DynamicObjectUtils.getDynamicObjectLPkValue(target, "policy")), DateUtil.getDateTimeFormat(target.getDate("starttime")), DateUtil.getDateTimeFormat(target.getDate("endtime")), DateUtil.getDateTimeFormat(target.getDate("modifytime"))) : targetGroupKey;
    }
}

