/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.mservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.constants.DBRouteConst;
import kd.occ.ocbase.common.entity.AccountRecord;
import kd.occ.ocbase.common.entity.ServiceResult;
import kd.occ.ocbase.common.enums.AccountUpdateTypeEnum;
import kd.occ.ocbase.common.util.CollectionUtil;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.occba.business.helper.RebateAccountHelper;
import kd.occ.occba.business.rebate.RebateAccountPoolHelper;
import kd.occ.occba.business.rebateservice.RebateAccountServiceHelper;
import kd.occ.occba.business.rebateservice.RebateCalculateHelper;
import kd.occ.occba.business.rebateservice.RebateServiceHelper;
import kd.occ.occba.mservice.RebateServiceImpl;
import kd.occ.occba.mservice.api.RebateAccountPoolService;

public class RebateAccountPoolServiceImpl
implements RebateAccountPoolService {
    private static Log logger = LogFactory.getLog(RebateAccountPoolServiceImpl.class);

    @Deprecated
    public ServiceResult usebalance(List<AccountRecord> paramList) {
        return RebateAccountPoolHelper.useBalance(paramList);
    }

    @Deprecated
    public ServiceResult balanceAdjustment(List<AccountRecord> paramList) {
        return RebateAccountPoolHelper.balanceAdjustment(paramList);
    }

    @Deprecated
    public ServiceResult balanceOccupy(List<AccountRecord> paramList) {
        return RebateAccountPoolHelper.balanceOccupy(paramList);
    }

    @Deprecated
    public ServiceResult releaseOccupy(List<AccountRecord> paramList) {
        return RebateAccountPoolHelper.releaseOccupy(paramList);
    }

    @Deprecated
    public ServiceResult settlementPayment(List<AccountRecord> paramList) {
        return RebateAccountPoolHelper.settlementPayment(paramList);
    }

    @Deprecated
    public void updateRebateAccountPool(List<AccountRecord> accountRecordList) {
        String tag = this.getMethodTag("updateRebateAccountPool");
        try (TXHandle tx = TX.required((String)tag);){
            try {
                this.updateRebateAccountPoolByType(accountRecordList);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    @Deprecated
    private void updateRebateAccountPoolByType(List<AccountRecord> accountRecordList) {
        if (CollectionUtils.isEmpty(accountRecordList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u91d1\u6c60\u8d26\u6237\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a\u5165\u53c2\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"RebateAccountPoolServiceImpl_0", (String)"occ-occba-mservice", (Object[])new Object[0]));
        }
        Map<String, List<AccountRecord>> groupMap = accountRecordList.stream().collect(Collectors.groupingBy(AccountRecord::getUpdateType));
        for (Map.Entry<String, List<AccountRecord>> group : groupMap.entrySet()) {
            ServiceResult serviceResult = this.getRebateAccountPoolResult(group.getValue(), group.getKey());
            if (serviceResult.getCode() == 200) continue;
            throw new KDBizException(serviceResult.getErrorMsg());
        }
    }

    private String getMethodTag(String methodName) {
        return String.format("%s.%s", RebateServiceImpl.class.getName(), methodName);
    }

    @Deprecated
    private ServiceResult getRebateAccountPoolResult(List<AccountRecord> accountRecordList, String accountUpdateType) {
        if (AccountUpdateTypeEnum.balanceAdjust.getValue().equalsIgnoreCase(accountUpdateType)) {
            return RebateAccountPoolHelper.balanceAdjustment(accountRecordList);
        }
        if (AccountUpdateTypeEnum.amountOccupy.getValue().equalsIgnoreCase(accountUpdateType)) {
            return RebateAccountPoolHelper.balanceOccupy(accountRecordList);
        }
        if (AccountUpdateTypeEnum.amountRelease.getValue().equalsIgnoreCase(accountUpdateType)) {
            return RebateAccountPoolHelper.releaseOccupy(accountRecordList);
        }
        if (AccountUpdateTypeEnum.useAmount.getValue().equalsIgnoreCase(accountUpdateType)) {
            return RebateAccountPoolHelper.useBalance(accountRecordList);
        }
        if (AccountUpdateTypeEnum.useAmountRelease.getValue().equalsIgnoreCase(accountUpdateType)) {
            return RebateAccountPoolHelper.useBalanceRelease(accountRecordList);
        }
        return RebateAccountPoolHelper.settlementPayment(accountRecordList);
    }

    public List<ServiceResult> batchUpdateRebateAccount(List<AccountRecord> accountRecordList) {
        return this.batchCalculateRebateAccounts(accountRecordList, false);
    }

    public List<ServiceResult> batchUpdateRebateAccountList(List<AccountRecord> accountRecordList) {
        return this.batchCalculateRebateAccounts(accountRecordList, true);
    }

    private List<ServiceResult> batchCalculateRebateAccounts(List<AccountRecord> paramList, boolean isThrowException) {
        if (SysParamsUtil.isEnableBalModel()) {
            return this.buildSuccessServiceResults(paramList);
        }
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            int size = CollectionUtil.isNull(paramList) ? 0 : paramList.size();
            ArrayList resultList = new ArrayList(size);
            List satisfiedParamList = RebateCalculateHelper.getCalculateAccountParams(paramList, resultList, (boolean)isThrowException);
            this.batchLockRebateAccounts(satisfiedParamList);
            List list = RebateServiceHelper.getCalculateResults((List)satisfiedParamList, (boolean)isThrowException);
            return list;
        }
        catch (Exception error) {
            try {
                h.markRollback();
                throw error;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private List<ServiceResult> buildSuccessServiceResults(List<AccountRecord> paramList) {
        if (CollectionUtil.isNull(paramList)) {
            return new ArrayList<ServiceResult>(0);
        }
        ArrayList<ServiceResult> serviceResultList = new ArrayList<ServiceResult>(paramList.size());
        RebateCalculateHelper.buildSuccessServiceResultList(paramList, serviceResultList);
        return serviceResultList;
    }

    private void batchLockRebateAccounts(List<AccountRecord> satisfiedParamList) {
        RebateCalculateHelper.getQueryRebateAccountInfoMap(satisfiedParamList);
        this.batchUpdateRebateAccounts(satisfiedParamList);
    }

    private void batchUpdateRebateAccounts(List<AccountRecord> satisfiedParamList) {
        satisfiedParamList.sort(new Comparator<AccountRecord>(){

            @Override
            public int compare(AccountRecord param1, AccountRecord param2) {
                if (param1.getId() > param2.getId()) {
                    return 1;
                }
                if (param1.getId() == param2.getId()) {
                    return 0;
                }
                return -1;
            }
        });
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("UPDATE T_OCDBD_REBATEACCOUNT SET FBALANCE=FBALANCE+0 WHERE FID=?");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(100);
        for (AccountRecord accountRecord : satisfiedParamList) {
            if (accountRecord.getId() <= 0L) continue;
            Object[] paramObj = new Object[]{accountRecord.getId()};
            paramsList.add(paramObj);
        }
        if (CollectionUtil.isNotNull(paramsList)) {
            DB.executeBatch((DBRoute)DBRouteConst.DRP, (String)updateSql.toString(), paramsList);
        }
    }

    @Deprecated
    private List<ServiceResult> getUpdateRebateAccountServiceResult(List<AccountRecord> accountRecordList, boolean isThrowException) {
        int size = CollectionUtil.isNull(accountRecordList) ? 0 : accountRecordList.size();
        ArrayList resultList = new ArrayList(size);
        List satisfiedAccountList = RebateCalculateHelper.getCalculateAccountParams(accountRecordList, resultList, (boolean)isThrowException);
        List dLockList = RebateServiceHelper.batchCreateDLockList((List)satisfiedAccountList);
        TXHandle tx = null;
        try {
            tx = TX.requiresNew();
            try {
                Map<String, List<AccountRecord>> groupMap = satisfiedAccountList.stream().collect(Collectors.groupingBy(AccountRecord::getUpdateType));
                for (Map.Entry<String, List<AccountRecord>> group : groupMap.entrySet()) {
                    List result = RebateServiceHelper.getCalculateResults(group.getValue(), (AccountUpdateTypeEnum)this.getAccountUpdateTypeEnum(group.getKey()), (boolean)isThrowException);
                    if (!CollectionUtil.isNotNull((List)result)) continue;
                    resultList.addAll(result);
                }
                ArrayList arrayList = resultList;
                return arrayList;
            }
            catch (Exception ex) {
                try {
                    tx.markRollback();
                    logger.error((Throwable)ex);
                    throw new KDBizException(ex.getMessage());
                }
                catch (Exception ex2) {
                    throw new KDBizException(ex2.getMessage());
                }
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
            RebateServiceHelper.batchReleaseDLockList((List)dLockList);
        }
    }

    private AccountUpdateTypeEnum getAccountUpdateTypeEnum(String accountUpdateType) {
        if (AccountUpdateTypeEnum.balanceAdjust.getValue().equalsIgnoreCase(accountUpdateType)) {
            return AccountUpdateTypeEnum.balanceAdjust;
        }
        if (AccountUpdateTypeEnum.amountOccupy.getValue().equalsIgnoreCase(accountUpdateType)) {
            return AccountUpdateTypeEnum.amountOccupy;
        }
        if (AccountUpdateTypeEnum.amountRelease.getValue().equalsIgnoreCase(accountUpdateType)) {
            return AccountUpdateTypeEnum.amountRelease;
        }
        if (AccountUpdateTypeEnum.useAmount.getValue().equalsIgnoreCase(accountUpdateType)) {
            return AccountUpdateTypeEnum.useAmount;
        }
        if (AccountUpdateTypeEnum.useAmountRelease.getValue().equalsIgnoreCase(accountUpdateType)) {
            return AccountUpdateTypeEnum.useAmountRelease;
        }
        return AccountUpdateTypeEnum.settlementPayment;
    }

    public List<ServiceResult> getSaleOrderAccountOccupyResult(List<AccountRecord> paramList) {
        return RebateAccountHelper.getSaleOrderAccountOccupyResult(paramList);
    }

    public DynamicObject[] getRebateAccounts(DynamicObject bill, long balRuleId) {
        JSONObject data = new JSONObject();
        try {
            return RebateServiceHelper.queryRebateAccount((DynamicObject)bill, (long)balRuleId);
        }
        catch (Exception ex) {
            logger.error(String.format("\u67e5\u8be2\u8d44\u91d1\u6c60\u8d26\u6237\u4fe1\u606f\u65b9\u6cd5:getRebateAccounts,\u67e5\u8be2\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", ex.getMessage()));
            return null;
        }
    }

    public JSONObject getRebateAccountsJson(DynamicObject bill, long balRuleId) {
        JSONObject data = new JSONObject();
        try {
            DynamicObject[] rebateAccounts = RebateServiceHelper.queryRebateAccount((DynamicObject)bill, (long)balRuleId);
            JSONArray jsonArray = new JSONArray(0);
            data.put("code", (Object)"success");
            if (rebateAccounts != null && rebateAccounts.length > 0) {
                for (DynamicObject rebateAccount : rebateAccounts) {
                    JSONObject item = new JSONObject();
                    item.put("id", rebateAccount.get("id"));
                    item.put("number", rebateAccount.get("number"));
                    item.put("org", rebateAccount.get("org"));
                    item.put("customer", rebateAccount.get("customer"));
                    item.put("channel", rebateAccount.get("channel"));
                    item.put("receivechannel", rebateAccount.get("receivechannel"));
                    item.put("type", rebateAccount.get("type"));
                    item.put("accounttype", rebateAccount.get("accounttype"));
                    item.put("setcurrency", rebateAccount.get("setcurrency"));
                    item.put("occupyamount", rebateAccount.get("occupyamount"));
                    item.put("balance", rebateAccount.get("balance"));
                    item.put("availablebalance", rebateAccount.get("availablebalance"));
                    item.put("productline", rebateAccount.get("productline"));
                    jsonArray.add((Object)item);
                }
            }
            data.put("data", (Object)jsonArray);
        }
        catch (Exception ex) {
            logger.error(String.format("\u67e5\u8be2\u8d44\u91d1\u6c60\u8d26\u6237\u4fe1\u606f\u65b9\u6cd5:getRebateAccounts,\u67e5\u8be2\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", ex.getMessage()));
            data.put("code", (Object)"fail");
            data.put("errorMsg", (Object)ex.getMessage());
        }
        return data;
    }

    public List<Map<String, Object>> balanceUpdate(DynamicObject[] bills, String operateKey, Map<String, Object> params) {
        return RebateAccountServiceHelper.balanceUpdate((DynamicObject[])bills, (String)operateKey, params);
    }
}

