/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.report.businessaccount;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.SaleOrderUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.occba.report.businessaccount.BusinessAccountRptParam;
import kd.occ.occba.report.util.RptUtil;

public final class BusinessAccountRptForm
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final Set<String> HEADFILTER_SET = Stream.of("settleorgid", "balancechannelid", "balancecustomerid", "remark", "srcbilltype", "srcbillno", "accountypeid").collect(Collectors.toCollection(HashSet::new));
    private static final Set<String> HIDEFIELDSET = Stream.of("srcbillid", "srcbillentity").collect(Collectors.toCollection(HashSet::new));
    private static final String CACHE_KEY_ORG_IDS = "hasPermissionOrg";
    private static final String SAVECHECKACCOUNT = "savecheckaccount";
    private static final String CHECKPAGE = "occba_checkbusaccountlist";

    public void registerListener(EventObject e) {
        BasedataEdit periodF7;
        BasedataEdit customerF7;
        BasedataEdit channelF7;
        super.registerListener(e);
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("settleorgid_h");
        if (orgF7 != null) {
            orgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((channelF7 = (BasedataEdit)this.getControl("balancechannelid_h")) != null) {
            channelF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((customerF7 = (BasedataEdit)this.getControl("balancecustomerid_h")) != null) {
            customerF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((periodF7 = (BasedataEdit)this.getControl("period")) != null) {
            periodF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String key = e.getFieldName();
        if ("srcbillno".equals(key)) {
            this.showDetailRpt(e);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.removeCommonFilterGridCols();
        this.initQueryParamValue();
        this.getModel().setValue("sumkeycols", this.getModel().getValue("showkeycols"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        switch (fieldKey = e.getProperty().getName()) {
            case "settleorgid_h": {
                this.getModel().setValue("balancecustomerid_h", null);
                break;
            }
            case "period": {
                Object obj = this.getModel().getValue("period");
                if (!(obj instanceof DynamicObject)) break;
                DynamicObject periodDynObj = (DynamicObject)obj;
                this.getModel().setValue("startdate", (Object)periodDynObj.getDate("starttime"));
                this.getModel().setValue("enddate", (Object)periodDynObj.getDate("endtime"));
                break;
            }
            case "balancechannelid_h": {
                if (!this.isFromPurRpt()) break;
                this.getModel().setValue("settleorgid_h", (Object)this.getSettleOrgIdByRelation());
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        List keyCols;
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        if ("showkeycols".equals(key) && !(keyCols = Stream.of(((String)value).split(",")).collect(Collectors.toList())).contains("settleorgid") && !keyCols.contains("balancecustomerid")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u4f9d\u636e\u201d\u4e2d\u7684\u201c\u7ed3\u7b97\u7ec4\u7ec7\u3001\u7ed3\u7b97\u5ba2\u6237\u201d\u5fc5\u9009\u5176\u4e00\u3002", (String)"BusinessAccountRptForm_0", (String)"occ-occba-report", (Object[])new Object[0]));
            e.setCancel(true);
            this.getView().updateView(key);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent f7) {
        String name;
        switch (name = f7.getProperty().getName()) {
            case "settleorgid_h": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)new QFilter("id", "in", this.getSettleOrgIdList()));
                f7.getFormShowParameter().setCustomParam("isIncludeAllSub", (Object)true);
                break;
            }
            case "balancechannelid_h": {
                QFilter filter = new QFilter("id", "in", (Object)CUserHelper.getAuthorizedChannelIdList((boolean)false));
                if (!this.isFromPurRpt()) {
                    filter.and(new QFilter("customer", "!=", (Object)0L));
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)filter);
                break;
            }
            case "balancecustomerid_h": {
                if (RptUtil.isNull(this.getView(), "settleorgid_h")) {
                    f7.setCancel(true);
                    return;
                }
                List<Long> settleOrgIdList = RptUtil.getBaseDataLongIds(this.getView(), "settleorgid_h");
                QFilter qFilter = new QFilter("id", "=", (Object)0L);
                if (!settleOrgIdList.isEmpty()) {
                    qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", (Long)settleOrgIdList.get(0));
                    for (int i = 1; i < settleOrgIdList.size(); ++i) {
                        qFilter.or(BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", (Long)settleOrgIdList.get(i)));
                    }
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)qFilter);
                break;
            }
            case "period": {
                QFilter joinFiler = QFilter.join((String)"periodid", (String)String.join((CharSequence)".", "ocdbd_assess_period", "id"), (QFilter)new QFilter(String.join((CharSequence)".", "ocdbd_assess_period", "enable"), "=", (Object)"1"));
                F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)joinFiler);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        IReportView view = this.getView();
        boolean isVerify = this.verifyRptParams(view);
        if (isVerify) {
            this.buildReportParams();
        }
        return isVerify;
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        List columnList = event.getColumns();
        for (AbstractReportColumn reportColumn : columnList) {
            ReportColumn column = (ReportColumn)reportColumn;
            if (!HIDEFIELDSET.contains(column.getFieldKey())) continue;
            column.setHide(true);
        }
    }

    public void setSortAndFilter(List<SortAndFilterEvent> list) {
        super.setSortAndFilter(list);
        for (SortAndFilterEvent event : list) {
            if (!HEADFILTER_SET.contains(event.getColumnName())) continue;
            event.setFilter(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (key = operate.getOperateKey()) {
            case "savecheckaccount": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId(CHECKPAGE);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(parameter);
                break;
            }
        }
        super.beforeDoOperation(args);
    }

    private BusinessAccountRptParam buildReportParams() {
        ReportQueryParam param = this.getQueryParam();
        DynamicObject data = this.getModel().getDataEntity();
        BusinessAccountRptParam channelAccountRptParam = new BusinessAccountRptParam();
        channelAccountRptParam.setSettleOrgIdList(RptUtil.getBaseDataLongIds(this.getView(), "settleorgid_h"));
        channelAccountRptParam.setSettleChannelIdList(RptUtil.getBaseDataLongIds(this.getView(), "balancechannelid_h"));
        channelAccountRptParam.setSettleCustomerIdList(RptUtil.getBaseDataLongIds(this.getView(), "balancecustomerid_h"));
        DynamicObjectCollection channelColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("balancechannelid_h");
        Map<Long, Long> settleCustomerIdMap = channelColl.stream().collect(Collectors.toMap(o -> DynamicObjectUtils.getPkValue((DynamicObject)o.getDynamicObject("fbasedataid"), (String)"customer"), o -> DynamicObjectUtils.getPkValue((DynamicObject)o.getDynamicObject("fbasedataid")), (r1, r2) -> r1));
        channelAccountRptParam.setSettleCustomerIdMap(settleCustomerIdMap);
        channelAccountRptParam.setAccountTypeIdList(RptUtil.getBaseDataLongIds(this.getView(), "accountypeid_h"));
        channelAccountRptParam.setCurrencyId(DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"currencyid_h"));
        Date fromDate = RptUtil.getShortDate(data.getDate("startdate"));
        channelAccountRptParam.setFromDate(fromDate);
        Date toDate = RptUtil.getShortDate(data.getDate("enddate"), 1);
        channelAccountRptParam.setToDate(toDate);
        channelAccountRptParam.setOnlyShowRowCount(data.getBoolean("onlyshowrowcount"));
        param.getCustomParam().put(BusinessAccountRptParam.class.getName(), channelAccountRptParam);
        channelAccountRptParam.setPreviousPeriodId(this.getPreviousPeriodId());
        channelAccountRptParam.setFromPurRpt(this.isFromPurRpt());
        return channelAccountRptParam;
    }

    private void initQueryParamValue() {
        Date nowDate = DateUtil.getDataFormat((Date)KDDateUtils.now(), (boolean)true);
        QFilter filter = new QFilter("starttime", "<=", (Object)nowDate);
        filter.and(new QFilter("endtime", ">=", (Object)nowDate));
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingleFromCache((String)"ocdbd_assess_entity", (QFilter[])filter.toArray());
        if (dynObj != null) {
            this.getModel().setValue("period", (Object)dynObj.getLong("id"));
            this.getModel().setValue("startdate", (Object)dynObj.getDate("starttime"));
            this.getModel().setValue("enddate", (Object)dynObj.getDate("endtime"));
        }
        if (this.isFromPurRpt()) {
            long channelId = B2BUserHelper.getLoginChannelId();
            Object[] balanceChannelIds = new Object[]{channelId};
            this.getModel().setValue("balancechannelid_h", (Object)balanceChannelIds);
            this.getModel().setValue("settleorgid_h", (Object)this.getSettleOrgIdByRelation());
        } else {
            List<Long> orgIdList = this.getHasPermissionSettleOrg();
            Object[] ids = null;
            if (!CommonUtils.isNull(orgIdList) && orgIdList.contains(UserUtil.getOrgId()) && OrgUnitServiceHelper.checkOrgFunction((Long)UserUtil.getOrgId(), (String)"10")) {
                ids = new Object[]{UserUtil.getOrgId()};
            }
            this.getModel().setValue("settleorgid_h", ids);
        }
    }

    private Set<String> removeCommonFilterGridCols() {
        HashSet<String> removedPros = new HashSet<String>();
        removedPros.add("srcbillid");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if (removedPros.contains(fieldName.split("\\.")[0])) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
        return removedPros;
    }

    private boolean verifyRptParams(IReportView view) {
        boolean isCustomerNull;
        boolean isChannelNull;
        if (RptUtil.isNull(view, "settleorgid_h") || RptUtil.isNull(view, "currencyid_h") || RptUtil.isNull(view, "startdate") || RptUtil.isNull(view, "enddate") || RptUtil.isNull(view, "periodtype") || RptUtil.isNull(view, "period")) {
            return false;
        }
        boolean bl = isChannelNull = this.getModel().getValue("balancechannelid_h") == null;
        if (this.getModel().getValue("balancechannelid_h") instanceof DynamicObjectCollection) {
            isChannelNull = CommonUtils.isNull((Object)((DynamicObjectCollection)this.getModel().getValue("balancechannelid_h")));
        }
        boolean bl2 = isCustomerNull = this.getModel().getValue("balancecustomerid_h") == null;
        if (this.getModel().getValue("balancecustomerid_h") instanceof DynamicObjectCollection) {
            isCustomerNull = CommonUtils.isNull((Object)((DynamicObjectCollection)this.getModel().getValue("balancecustomerid_h")));
        }
        if (isChannelNull && isCustomerNull) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u6e20\u9053\u548c\u7ed3\u7b97\u5ba2\u6237\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"BusinessAccountRptForm_1", (String)"occ-occba-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject data = this.getModel().getDataEntity();
        Date startDate = data.getDate("startdate");
        Date enddate = data.getDate("enddate");
        if (enddate.before(startDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"BusinessAccountRptForm_2", (String)"occ-occba-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<Long> getHasPermissionSettleOrg() {
        List orgIdList = null;
        String idStr = this.getView().getPageCache().get(CACHE_KEY_ORG_IDS);
        if (StringUtils.isEmpty((String)idStr)) {
            String formId = this.getModel().getDataEntity().getDataEntityType().getName();
            HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)UserUtil.getCurrUserId(), (String)"10", (String)"occba", (String)formId, (String)"47150e89000000ac", (boolean)true);
            orgIdList = allPermOrgs.getHasPermOrgs();
            if (CommonUtils.isNull((Object)orgIdList)) {
                orgIdList.add(0L);
            }
            this.getView().getPageCache().put(CACHE_KEY_ORG_IDS, SerializationUtils.toJsonString((Object)orgIdList));
        } else {
            orgIdList = SerializationUtils.fromJsonStringToList((String)idStr, Long.class);
        }
        return orgIdList;
    }

    private void showDetailRpt(HyperLinkClickEvent e) {
        ReportList reportList = (ReportList)e.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(e.getRowIndex());
        String srcBillEntity = DynamicObjectUtils.getStrPkValue((DynamicObject)rowData, (String)"srcbillentity");
        long billId = rowData.getLong("srcbillid");
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(srcBillEntity);
        parameter.setPkId((Object)billId);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private long getPreviousPeriodId() {
        long previousPeriodId = 0L;
        Object obj = this.getModel().getValue("period");
        if (obj instanceof DynamicObject) {
            DynamicObject periodDynObj = (DynamicObject)obj;
            int entrySeq = periodDynObj.getInt("entryseq");
            int beforeEntrySeq = entrySeq - 1;
            long periodId = periodDynObj.getLong("periodid");
            if (beforeEntrySeq > 1 || entrySeq > 1) {
                QFilter filter = new QFilter("periodid", "=", (Object)periodId);
                filter.and(new QFilter("entryseq", "=", (Object)beforeEntrySeq));
                DynamicObject dynObj = BusinessDataServiceHelper.loadSingleFromCache((String)"ocdbd_assess_entity", (QFilter[])filter.toArray());
                previousPeriodId = DynamicObjectUtils.getPkValue((DynamicObject)dynObj);
            } else {
                QFilter filter = new QFilter("id", "=", (Object)periodId);
                DynamicObject dynObj = BusinessDataServiceHelper.loadSingleFromCache((String)"ocdbd_assess_period", (QFilter[])filter.toArray());
                int periodYear = DynamicObjectUtils.getInt((DynamicObject)dynObj, (String)"periodyear");
                filter = new QFilter("periodyear", "=", (Object)(periodYear - 1));
                if ((dynObj = BusinessDataServiceHelper.loadSingleFromCache((String)"ocdbd_assess_period", (QFilter[])filter.toArray())) != null) {
                    DynamicObject entryDynObj = dynObj.getDynamicObjectCollection("entity").stream().max(Comparator.comparing(o -> o.getInt("seq"))).get();
                    previousPeriodId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj);
                }
            }
        }
        return previousPeriodId;
    }

    private List<Long> getSettleOrgIdList() {
        List<Long> settleOrgIdList;
        if (this.isFromPurRpt()) {
            List<Long> balanceChannelIdList = RptUtil.getBaseDataLongIds(this.getView(), "balancechannelid_h");
            DynamicObjectCollection channelAuthDynObjColl = SaleOrderUtil.getChannelAuthColl(balanceChannelIdList, (String)"A");
            settleOrgIdList = new ArrayList<Long>(16);
            if (!CommonUtils.isNull((Object)channelAuthDynObjColl)) {
                for (DynamicObject dynObj : channelAuthDynObjColl) {
                    long orgId;
                    Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)dynObj.getLong("saleorg"), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                    if (CollectionUtils.isEmpty((Map)map) || settleOrgIdList.contains(orgId = Long.parseLong(map.get("id").toString()))) continue;
                    settleOrgIdList.add(orgId);
                }
            }
        } else {
            settleOrgIdList = this.getHasPermissionSettleOrg();
        }
        return settleOrgIdList;
    }

    private boolean isFromPurRpt() {
        return "occba_purbusiaccount_rpt".equals(this.getModel().getDataEntity().getDataEntityType().getName());
    }

    private Object[] getSettleOrgIdByRelation() {
        ArrayList<Long> settleOrgIdList = new ArrayList<Long>(16);
        List<Long> balanceChannelIdList = RptUtil.getBaseDataLongIds(this.getView(), "balancechannelid_h");
        for (Long channelId : balanceChannelIdList) {
            Map map;
            DynamicObject channelAuthDynObj = SaleOrderUtil.getDefaultChannelAuthDynObj(null, (Object)channelId, null, (String)"A");
            if (channelAuthDynObj == null || CollectionUtils.isEmpty((Map)(map = OrgUnitServiceHelper.getCompanyByOrg((Long)channelAuthDynObj.getLong("saleorg"), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)))) continue;
            settleOrgIdList.add(Long.parseLong(map.get("id").toString()));
        }
        return settleOrgIdList.toArray();
    }
}

