/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.report.businessaccount;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.occba.report.businessaccount.BusinessAccountRptParam;
import kd.occ.occba.report.businessaccount.transform.BusinessAccountAddSumRowTransform;
import kd.occ.occba.report.businessaccount.transform.BusinessAccountAfterUnionTransform;
import kd.occ.occba.report.businessaccount.transform.BusinessAccountResultTransform;
import kd.occ.occba.report.util.RptUtil;

public final class BusinessAccountRptHandle
implements IReportDataHandle {
    private BusinessAccountRptParam reportParam;

    public void setupCtx(ReportDataCtx ctx) {
        this.reportParam = (BusinessAccountRptParam)ctx.getParam(BusinessAccountRptParam.class.getName());
        this.setFixedFilter(ctx);
        this.setShowKeyCols(ctx);
        this.setSumKeyCols(ctx);
        this.setShowQtyCols(ctx);
        RptUtil.setBusinnessAccountHeadFilter(ctx, this.reportParam);
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        for (SrcBlockConf blockConf : blockCollector) {
            blockConf.setAllowNotMatch(true);
            String srcEntity = blockConf.getSrcEntity();
            QFilter dataFs = blockConf.getDataFs();
            switch (srcEntity) {
                case "occpic_rebatestatement": 
                case "occba_balanceadjust": 
                case "occpic_rebateuse": 
                case "ocbsoc_saleorder": 
                case "ocbsoc_returnorder": 
                case "ocmem_mc_reimburse": {
                    break;
                }
                case "occba_channelbalance": {
                    dataFs.and(new QFilter("periodid", "=", (Object)this.reportParam.getPreviousPeriodId()));
                    break;
                }
            }
        }
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("settleorgid");
        repoColFilter.add("balancechannelid");
        repoColFilter.add("balancecustomerid");
        repoColFilter.add("accountypeid");
        repoColFilter.add("srcbillno");
        repoColFilter.add("srcbillid");
        repoColFilter.add("srcbillentity");
        repoColFilter.add("srcbilltype");
        repoColFilter.add("recordedamount");
        repoColFilter.add("ajustamount");
        repoColFilter.add("useamount");
        repoColFilter.add("returnamount");
        repoColFilter.add("receivableamount");
        repoColFilter.add("remark");
        repoColFilter.add("bizdate");
        repoColFilter.add("currencyid");
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        String entityKey;
        Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
        switch (entityKey = blockConf.getSrcEntity()) {
            case "occpic_rebatestatement": 
            case "occba_balanceadjust": 
            case "occpic_rebateuse": 
            case "ocbsoc_saleorder": 
            case "ocbsoc_returnorder": 
            case "ocmem_mc_reimburse": {
                repoColFullSrcColMap.put("srcbillid", "id");
                break;
            }
            default: {
                repoColFullSrcColMap.put("srcbillid", "id");
            }
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new BusinessAccountAfterUnionTransform());
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        if (this.reportParam.isOnlyShowRowCount()) {
            transCollector.add(new BusinessAccountAddSumRowTransform());
        }
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new BusinessAccountResultTransform(ctx));
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> columns, ReportDataCtx ctx) {
        for (AbstractReportColumn col : columns) {
            ReportColumn reportCol = (ReportColumn)col;
            String field = reportCol.getFieldKey();
            if (!"srcbillno".equals(field) || this.reportParam.isFromPurRpt()) continue;
            reportCol.setHyperlink(true);
        }
        return columns;
    }

    private void setFixedFilter(ReportDataCtx ctx) {
        ArrayList fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            fixedFs = new ArrayList();
            ctx.setFixedFs(fixedFs);
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        filterList.add(new QFilter("settleorgid", "in", this.reportParam.getSettleOrgIdList()));
        if (!CommonUtils.isNull(this.reportParam.getSettleChannelIdList())) {
            filterList.add(new QFilter("balancechannelid", "in", this.reportParam.getSettleChannelIdList()));
        }
        if (!CommonUtils.isNull(this.reportParam.getSettleCustomerIdList())) {
            filterList.add(new QFilter("balancecustomerid", "in", this.reportParam.getSettleCustomerIdList()));
        }
        filterList.add(new QFilter(String.join((CharSequence)".", "accountypeid", "accounttype"), "in", (Object)new String[]{"A", "B"}));
        if (!CommonUtils.isNull(this.reportParam.getAccountTypeIdList())) {
            filterList.add(new QFilter("accountypeid", "in", this.reportParam.getAccountTypeIdList()));
        }
        filterList.add(new QFilter("currencyid", "=", (Object)this.reportParam.getCurrencyId()));
        QFilter bizDateFilter = new QFilter("bizdate", ">=", (Object)this.reportParam.getFromDate()).and("bizdate", "<", (Object)this.reportParam.getToDate());
        filterList.add(bizDateFilter);
        fixedFs.addAll(filterList);
    }

    private void setShowKeyCols(ReportDataCtx ctx) {
        Set showKeyColSet = ctx.getShowKeyCols();
        showKeyColSet.add("settleorgid");
        showKeyColSet.add("balancechannelid");
        showKeyColSet.add("balancecustomerid");
        showKeyColSet.add("currencyid");
        showKeyColSet.add("srcbillid");
        showKeyColSet.add("srcbillentity");
        showKeyColSet.add("accountypeid");
        showKeyColSet.add("remark");
        showKeyColSet.add("srcbilltype");
        showKeyColSet.add("bizdate");
        showKeyColSet.add("srcbillno");
    }

    private void setSumKeyCols(ReportDataCtx ctx) {
        Set sumKeyColSet = ctx.getSumKeyCols();
        sumKeyColSet.add("settleorgid");
        sumKeyColSet.add("balancechannelid");
        sumKeyColSet.add("balancecustomerid");
        sumKeyColSet.add("accountypeid");
        sumKeyColSet.add("currencyid");
        ctx.setSumKeyCols4Count(sumKeyColSet);
    }

    private void setShowQtyCols(ReportDataCtx ctx) {
        Set qtyCols = ctx.getShowQtyCols();
        qtyCols.add("recordedamount");
        qtyCols.add("ajustamount");
        qtyCols.add("useamount");
        qtyCols.add("receivableamount");
        ctx.setSumQtyCols4Count(qtyCols);
    }
}

