/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occba.report.businessaccount.transform.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bplat.scmc.report.util.TransformUtil;

public class BusinessAccountColumnMapFunc
extends MapFunction {
    private static final long serialVersionUID = 10000000999911L;
    private RowMeta rowMeta;
    private Map<String, Integer> indexs;

    public BusinessAccountColumnMapFunc(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.indexs = this.buildIndexs();
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX rowX) {
        BigDecimal useAmount = rowX.getBigDecimal(this.indexs.get("useamount").intValue());
        BigDecimal ajustAmount = rowX.getBigDecimal(this.indexs.get("ajustamount").intValue());
        BigDecimal recordedAmount = rowX.getBigDecimal(this.indexs.get("recordedamount").intValue());
        BigDecimal returnAmount = rowX.getBigDecimal(this.indexs.get("returnamount").intValue());
        String remark = rowX.getString(this.indexs.get("remark").intValue());
        BigDecimal initBalanceAmount = rowX.getBigDecimal(this.indexs.get("receivableamount").intValue());
        BigDecimal amount = "0".equals(remark) ? initBalanceAmount : useAmount.subtract(ajustAmount).subtract(recordedAmount).subtract(returnAmount);
        rowX.set(this.indexs.get("receivableamount").intValue(), (Object)amount);
        return rowX;
    }

    private Map<String, Integer> buildIndexs() {
        ArrayList<String> columns = new ArrayList<String>(5);
        columns.add("balancechannelid");
        columns.add("balancecustomerid");
        columns.add("useamount");
        columns.add("ajustamount");
        columns.add("recordedamount");
        columns.add("receivableamount");
        columns.add("returnamount");
        columns.add("remark");
        return TransformUtil.buildIndexs((RowMeta)this.rowMeta, columns);
    }
}

